<?php 
define ('P2_AVATAR_SIZE', 32);
define ('P2_EXCERPT_LENGTH', 60);

load_theme_textdomain('p2');

function prologue_get_avatar( $user_id, $email, $size ) {
	if (! ks_is_flat_rate()) {
		return;
	}
	if ( $user_id ) {
		return get_avatar( $user_id, $size );
	} else {
		return get_avatar( $email, $size );
	}
}

function prologue_fix_avatar($avatar, $id_or_email, $size = P2_AVATAR_SIZE, $default = '', $alt = false) {
	$avatar = str_replace("'", '"', $avatar);
	$avatar = preg_replace('/ (alt|class)="[^"]*"/', '', $avatar);
	$avatar = str_replace(' />', ' style="float:left;margin-right:2px;" align="left" />', $avatar);
	return $avatar;
}
add_filter('get_avatar', 'prologue_fix_avatar', 10, 5);

function ks_comment_content_inline($_comment = NULL, $args = array(), $depth = 0) {
	global $comment;
	if (isset($_comment)) {
		$comment = $_comment;
	}
	echo get_avatar(get_comment_author_email(), P2_AVATAR_SIZE);
	if (get_comment_type() == 'comment') {
		if ($comment->comment_approved == '0') {
			?><em><font color="red"><?php _e('Your comment is awaiting moderation.', 'ktai_style'); ?></font></em><br /><?php 
		}
		echo mb_strcut(get_comment_excerpt(), 0, P2_EXCERPT_LENGTH);
		comment_reply_link(array_merge(
			array(
				'before' => '', 
				'after' => '', 
				'reply_before' => '', 
				'reply_text' => '<img localsrc="149" alt="" />' . __('Reply'), 
				'login_text' => '<img localsrc="120" alt="" />' . __('Log in to Reply'), 
			), 
			$args, 
			array('depth' => $depth, 'max_depth' => $args['max_depth'])
		));
	} else {
		?><img localsrc="<?php comment_type(68, 112, 112); ?>" alt="" /><?php ks_comment_author_link();
	}
	echo '<br clear="all" />';
}

function ks_comment_content($_comment = NULL, $args = array(), $depth = 0) {
	global $comment;
	if (isset($_comment)) {
		$comment = $_comment;
	}
	?><hr /><?php
	echo get_avatar(get_comment_author_email(), P2_AVATAR_SIZE);
	?><img localsrc="<?php comment_type(68, 112, 112); ?>" alt="" /><?php ks_comment_author_link();
	?><br /><img localsrc="46" alt="@ " /><font color="#666666"><?php ks_comment_datetime(); ?></font>
	<?php if ($comment->comment_approved == '0') { ?>
		<br /><em><font color="red"><?php _e('Your comment is awaiting moderation.', 'ktai_style'); ?></font></em>
	<?php }
	comment_text();
	comment_reply_link(array_merge(
		array(
			'before' => '<div>', 
			'after' => '</div>', 
			'reply_before' => '', 
			'reply_text' => '<img localsrc="149" alt="" />' . __('Reply'), 
			'login_text' => '<img localsrc="120" alt="" />' . __('Log in to Reply'), 
		), 
		$args, 
		array('depth' => $depth, 'max_depth' => $args['max_depth'])
	));
}
?>