/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.Territory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FestivalMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FriendlyMobInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MinionInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2RaidBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2RiftInvaderInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;

public class L2AttackableAI
extends L2CharacterAI
implements Runnable {
    private static final int RANDOM_WALK_RATE = 30;
    private static final int MAX_ATTACK_TIMEOUT = 300;
    private Future<?> _aiTask;
    private int _attackTimeout;
    private int _globalAggro;
    private boolean _thinking;
    private int timepass = 0;
    private int chaostime = 0;
    private L2NpcTemplate _skillrender;
    int lastBuffTick;

    public L2AttackableAI(L2Character.AIAccessor accessor) {
        super(accessor);
        this._skillrender = NpcTable.getInstance().getTemplate(((L2Npc)this._actor).getTemplate().npcId);
        this._attackTimeout = Integer.MAX_VALUE;
        this._globalAggro = -10;
    }

    @Override
    public void run() {
        this.onEvtThink();
    }

    private boolean autoAttackCondition(L2Character target) {
        L2PcInstance owner;
        if (target == null || this._actor == null) {
            return false;
        }
        L2Attackable me = (L2Attackable)this._actor;
        if (target.isInvul()) {
            if (target instanceof L2PcInstance && ((L2PcInstance)target).isGM()) {
                return false;
            }
            if (target instanceof L2Summon && ((L2Summon)target).getOwner().isGM()) {
                return false;
            }
        }
        if (target instanceof L2DoorInstance) {
            return false;
        }
        if (target.isAlikeDead() || target instanceof L2Playable && !me.isInsideRadius(target, me.getAggroRange(), true, false)) {
            return false;
        }
        if (target instanceof L2Playable && !me.isRaid() && !me.canSeeThroughSilentMove() && ((L2Playable)target).isSilentMoving()) {
            return false;
        }
        if (target instanceof L2PcInstance) {
            if (((L2PcInstance)target).isGM() && !((L2PcInstance)target).getAccessLevel().canTakeAggro()) {
                return false;
            }
            if ("varka".equals(me.getFactionId()) && ((L2PcInstance)target).isAlliedWithVarka()) {
                return false;
            }
            if ("ketra".equals(me.getFactionId()) && ((L2PcInstance)target).isAlliedWithKetra()) {
                return false;
            }
            if (((L2PcInstance)target).isRecentFakeDeath()) {
                return false;
            }
            if (target.isInParty() && target.getParty().isInDimensionalRift()) {
                byte riftType = target.getParty().getDimensionalRift().getType();
                byte riftRoom = target.getParty().getDimensionalRift().getCurrentRoom();
                if (me instanceof L2RiftInvaderInstance && !DimensionalRiftManager.getInstance().getRoom(riftType, riftRoom).checkIfInZone(me.getX(), me.getY(), me.getZ())) {
                    return false;
                }
            }
        }
        if (target instanceof L2Summon && (owner = ((L2Summon)target).getOwner()) != null) {
            if (owner.isGM() && (owner.isInvul() || !owner.getAccessLevel().canTakeAggro())) {
                return false;
            }
            if ("varka".equals(me.getFactionId()) && owner.isAlliedWithVarka()) {
                return false;
            }
            if ("ketra".equals(me.getFactionId()) && owner.isAlliedWithKetra()) {
                return false;
            }
        }
        if (this._actor instanceof L2GuardInstance) {
            if (target instanceof L2PcInstance && ((L2PcInstance)target).getKarma() > 0) {
                return GeoData.getInstance().canSeeTarget((L2Object)me, target);
            }
            if (target instanceof L2MonsterInstance && Config.GUARD_ATTACK_AGGRO_MOB) {
                return ((L2MonsterInstance)target).isAggressive() && GeoData.getInstance().canSeeTarget((L2Object)me, target);
            }
            return false;
        }
        if (this._actor instanceof L2FriendlyMobInstance) {
            if (target instanceof L2Npc) {
                return false;
            }
            if (target instanceof L2PcInstance && ((L2PcInstance)target).getKarma() > 0) {
                return GeoData.getInstance().canSeeTarget((L2Object)me, target);
            }
            return false;
        }
        if (target instanceof L2Attackable) {
            if (((L2Attackable)this._actor).getEnemyClan() == null || ((L2Attackable)target).getClan() == null) {
                return false;
            }
            if (((L2Attackable)this._actor).getEnemyClan().equals(((L2Attackable)target).getClan())) {
                if (this._actor.isInsideRadius(target, ((L2Attackable)this._actor).getEnemyRange(), false, false)) {
                    return GeoData.getInstance().canSeeTarget((L2Object)this._actor, target);
                }
                return false;
            }
            if (((L2Attackable)this._actor).getIsChaos() > 0 && me.isInsideRadius(target, ((L2Attackable)this._actor).getIsChaos(), false, false)) {
                if (((L2Attackable)this._actor).getFactionId() != null && ((L2Attackable)this._actor).getFactionId().equals(((L2Attackable)target).getFactionId())) {
                    return false;
                }
                return GeoData.getInstance().canSeeTarget((L2Object)me, target);
            }
        }
        if (target instanceof L2Attackable || target instanceof L2Npc) {
            return false;
        }
        if (!Config.ALT_MOB_AGRO_IN_PEACEZONE && target.isInsideZone((byte)1)) {
            return false;
        }
        if (me.isChampion() && Config.L2JMOD_CHAMPION_PASSIVE) {
            return false;
        }
        return me.isAggressive() && GeoData.getInstance().canSeeTarget((L2Object)me, target);
    }

    public void startAITask() {
        if (this._aiTask == null) {
            this._aiTask = ThreadPoolManager.getInstance().scheduleAiAtFixedRate(this, 1000L, 1000L);
        }
    }

    public void stopAITask() {
        if (this._aiTask != null) {
            this._aiTask.cancel(false);
            this._aiTask = null;
        }
    }

    @Override
    protected void onEvtDead() {
        this.stopAITask();
        super.onEvtDead();
    }

    @Override
    synchronized void changeIntention(CtrlIntention intention, Object arg0, Object arg1) {
        if (intention == CtrlIntention.AI_INTENTION_IDLE || intention == CtrlIntention.AI_INTENTION_ACTIVE) {
            if (!this._actor.isAlikeDead()) {
                L2Attackable npc = (L2Attackable)this._actor;
                if (!npc.getKnownList().getKnownPlayers().isEmpty()) {
                    intention = CtrlIntention.AI_INTENTION_ACTIVE;
                } else if (npc.getSpawn() != null) {
                    int range = Config.MAX_DRIFT_RANGE;
                    if (!npc.isInsideRadius(npc.getSpawn().getLocx(), npc.getSpawn().getLocy(), npc.getSpawn().getLocz(), range + range, true, false)) {
                        intention = CtrlIntention.AI_INTENTION_ACTIVE;
                    }
                }
            }
            if (intention == CtrlIntention.AI_INTENTION_IDLE) {
                super.changeIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
                if (this._aiTask != null) {
                    this._aiTask.cancel(true);
                    this._aiTask = null;
                }
                this._accessor.detachAI();
                return;
            }
        }
        super.changeIntention(intention, arg0, arg1);
        this.startAITask();
    }

    @Override
    protected void onIntentionAttack(L2Character target) {
        this._attackTimeout = 300 + GameTimeController.getGameTicks();
        if (this.lastBuffTick + 30 < GameTimeController.getGameTicks()) {
            if (this._skillrender.hasBuffSkill()) {
                L2Skill sk;
                Iterator i$ = this._skillrender._buffskills.iterator();
                while (i$.hasNext() && !this.Cast(sk = (L2Skill)i$.next())) {
                }
            }
            this.lastBuffTick = GameTimeController.getGameTicks();
        }
        super.onIntentionAttack(target);
    }

    private void thinkActive() {
        L2MonsterInstance boss;
        L2Attackable npc = (L2Attackable)this._actor;
        if (this._globalAggro != 0) {
            this._globalAggro = this._globalAggro < 0 ? ++this._globalAggro : --this._globalAggro;
        }
        if (this._globalAggro >= 0) {
            Collection<L2Object> objs = this._actor.getKnownList().getKnownObjects().values();
            for (L2Object obj : objs) {
                int hating;
                L2PcInstance targetPlayer;
                if (!(obj instanceof L2Character)) continue;
                L2Character target = (L2Character)obj;
                if (this._actor instanceof L2FestivalMonsterInstance && obj instanceof L2PcInstance && !(targetPlayer = (L2PcInstance)obj).isFestivalParticipant() || !this.autoAttackCondition(target) || (hating = npc.getHating(target)) != 0) continue;
                npc.addDamageHate(target, 0, 0);
            }
            L2Character hated = this._actor.isConfused() ? this.getAttackTarget() : npc.getMostHated();
            if (hated != null) {
                int aggro = npc.getHating(hated);
                if (aggro + this._globalAggro > 0) {
                    if (!this._actor.isRunning()) {
                        this._actor.setRunning();
                    }
                    this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, hated);
                    if (this._actor instanceof L2MonsterInstance) {
                        boss = (L2MonsterInstance)this._actor;
                        if (boss.hasMinions()) {
                            List<L2MinionInstance> minions = boss.getSpawnedMinions();
                            for (L2MinionInstance m : minions) {
                                if (!m.isRunning()) {
                                    m.setRunning();
                                }
                                m.getAI().startFollow(this._actor);
                            }
                        }
                    } else if (this._actor instanceof L2MinionInstance) {
                        L2MinionInstance minion = (L2MinionInstance)this._actor;
                        boss = minion.getLeader();
                        if (!boss.isRunning()) {
                            boss.setRunning();
                        }
                        boss.getAI().startFollow(this._actor);
                        List<L2MinionInstance> minions = boss.getSpawnedMinions();
                        for (L2MinionInstance m : minions) {
                            if (m.getObjectId() == this._actor.getObjectId()) continue;
                            if (!m.isRunning()) {
                                m.setRunning();
                            }
                            m.getAI().startFollow(this._actor);
                        }
                    }
                }
                return;
            }
        }
        if (this._actor instanceof L2GuardInstance) {
            ((L2GuardInstance)this._actor).returnHome();
        }
        if (this._actor instanceof L2FestivalMonsterInstance) {
            return;
        }
        if (!npc.canReturnToSpawnPoint()) {
            return;
        }
        if (this._actor instanceof L2MinionInstance && ((L2MinionInstance)this._actor).getLeader() != null) {
            int offset = this._actor.isRaidMinion() ? 500 : 200;
            if (((L2MinionInstance)this._actor).getLeader().isRunning()) {
                this._actor.setRunning();
            } else {
                this._actor.setWalking();
            }
            if (this._actor.getPlanDistanceSq(((L2MinionInstance)this._actor).getLeader()) > (double)(offset * offset)) {
                int x1 = ((L2MinionInstance)this._actor).getLeader().getX() + Rnd.nextInt((offset - 30) * 2) - (offset - 30);
                int y1 = ((L2MinionInstance)this._actor).getLeader().getY() + Rnd.nextInt((offset - 30) * 2) - (offset - 30);
                int z1 = ((L2MinionInstance)this._actor).getLeader().getZ();
                this.moveTo(x1, y1, z1);
                return;
            }
            if (Rnd.nextInt(30) == 0 && this._skillrender.hasBuffSkill()) {
                for (L2Skill sk : this._skillrender._buffskills) {
                    if (!this.Cast(sk)) continue;
                    return;
                }
            }
        } else if (npc.getSpawn() != null && Rnd.nextInt(30) == 0 && !this._actor.isNoRndWalk()) {
            int z1;
            int y1;
            int x1;
            int range = Config.MAX_DRIFT_RANGE;
            if (this._skillrender.hasBuffSkill()) {
                for (L2Skill sk : this._skillrender._buffskills) {
                    if (!this.Cast(sk)) continue;
                    return;
                }
            }
            if (npc.getSpawn().getLocx() == 0 && npc.getSpawn().getLocy() == 0) {
                int[] p = Territory.getInstance().getRandomPoint(npc.getSpawn().getLocation());
                x1 = p[0];
                y1 = p[1];
                z1 = p[2];
                double distance2 = this._actor.getPlanDistanceSq(x1, y1);
                if (distance2 > (double)((range + range) * (range + range))) {
                    npc.setisReturningToSpawnPoint(true);
                    float delay = (float)Math.sqrt(distance2) / (float)range;
                    x1 = this._actor.getX() + (int)((float)(x1 - this._actor.getX()) / delay);
                    y1 = this._actor.getY() + (int)((float)(y1 - this._actor.getY()) / delay);
                }
                if (Territory.getInstance().getProcMax(npc.getSpawn().getLocation()) > 0 && !npc.isReturningToSpawnPoint()) {
                    return;
                }
            } else {
                x1 = npc.getSpawn().getLocx();
                if (!this._actor.isInsideRadius(x1, y1 = npc.getSpawn().getLocy(), z1 = npc.getSpawn().getLocz(), range + range, true, false)) {
                    npc.setisReturningToSpawnPoint(true);
                } else {
                    x1 += Rnd.nextInt(range * 2) - range;
                    y1 += Rnd.nextInt(range * 2) - range;
                    z1 = npc.getZ();
                }
            }
            this.moveTo(x1, y1, z1);
            if (this._actor instanceof L2MonsterInstance && (boss = (L2MonsterInstance)this._actor).hasMinions()) {
                boss.callMinions();
            }
        }
    }

    private void thinkAttack() {
        double distance2;
        block70: {
            if (this._attackTimeout < GameTimeController.getGameTicks() && this._actor.isRunning()) {
                this._actor.setWalking();
                this._attackTimeout = 300 + GameTimeController.getGameTicks();
            }
            if (this._actor.isCastingNow()) {
                return;
            }
            L2Character originalAttackTarget = this.getAttackTarget();
            if (originalAttackTarget == null || originalAttackTarget.isAlikeDead() || this._attackTimeout < GameTimeController.getGameTicks()) {
                if (originalAttackTarget != null) {
                    ((L2Attackable)this._actor).stopHating(originalAttackTarget);
                }
                this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                this._actor.setWalking();
                return;
            }
            if (((L2Npc)this._actor).getFactionId() != null) {
                String faction_id = ((L2Npc)this._actor).getFactionId();
                Collection<L2Object> objs = this._actor.getKnownList().getKnownObjects().values();
                try {
                    for (L2Object obj : objs) {
                        if (!(obj instanceof L2Npc)) continue;
                        L2Npc npc = (L2Npc)obj;
                        String npcfaction = npc.getFactionId();
                        boolean sevenSignFaction = false;
                        if ("c_dungeon_clan".equals(faction_id) && ("c_dungeon_lilim".equals(npcfaction) || "c_dungeon_nephi".equals(npcfaction))) {
                            sevenSignFaction = true;
                        } else if ("c_dungeon_lilim".equals(faction_id) && "c_dungeon_clan".equals(npcfaction)) {
                            sevenSignFaction = true;
                        } else if ("c_dungeon_nephi".equals(faction_id) && "c_dungeon_clan".equals(npcfaction)) {
                            sevenSignFaction = true;
                        }
                        if (!faction_id.equals(npc.getFactionId()) && !sevenSignFaction || !this._actor.isInsideRadius(npc, npc.getFactionRange() + npc.getTemplate().collisionRadius, true, false) || npc.getAI() == null || Math.abs(originalAttackTarget.getZ() - npc.getZ()) >= 600 || !this._actor.getAttackByList().contains(originalAttackTarget) || npc.getAI()._intention != CtrlIntention.AI_INTENTION_IDLE && npc.getAI()._intention != CtrlIntention.AI_INTENTION_ACTIVE || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, npc)) continue;
                        if (originalAttackTarget instanceof L2PcInstance || originalAttackTarget instanceof L2Summon) {
                            if (npc.getTemplate().getEventQuests(Quest.QuestEventType.ON_FACTION_CALL) == null) continue;
                            L2PcInstance player = originalAttackTarget instanceof L2PcInstance ? (L2PcInstance)originalAttackTarget : ((L2Summon)originalAttackTarget).getOwner();
                            for (Quest quest : npc.getTemplate().getEventQuests(Quest.QuestEventType.ON_FACTION_CALL)) {
                                quest.notifyFactionCall(npc, (L2Npc)this._actor, player, originalAttackTarget instanceof L2Summon);
                            }
                            continue;
                        }
                        if (!(npc instanceof L2Attackable) || this.getAttackTarget() == null || npc.getAI()._intention == CtrlIntention.AI_INTENTION_ATTACK) continue;
                        ((L2Attackable)npc).addDamageHate(this.getAttackTarget(), 0, ((L2Attackable)this._actor).getHating(this.getAttackTarget()));
                        npc.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this.getAttackTarget());
                    }
                }
                catch (NullPointerException e) {
                    _log.info("L2AttackableAI: thinkAttack() faction call failed.");
                    if (!Config.DEBUG) break block70;
                    e.printStackTrace();
                }
            }
        }
        double dist = 0.0;
        int dist2 = 0;
        int range = 0;
        L2Character MostHate = ((L2Attackable)this._actor).getMostHated();
        try {
            this.setAttackTarget(MostHate);
            this._actor.setTarget(MostHate);
            dist = Math.sqrt(this._actor.getPlanDistanceSq(this.getAttackTarget().getX(), this.getAttackTarget().getY()));
            dist2 = (int)dist - this._actor.getTemplate().collisionRadius;
            range = this._actor.getPhysicalAttackRange() + this._actor.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius;
            if (this.getAttackTarget().isMoving()) {
                range += 50;
                if (this._actor.isMoving()) {
                    range += 50;
                }
            }
        }
        catch (NullPointerException e) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            return;
        }
        if (!this._actor.isMovementDisabled() && Rnd.nextInt(100) <= 33) {
            int combinedCollision = this._actor.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius;
            int collision = this._actor.getTemplate().collisionRadius;
            for (L2Character nearby : this._actor.getKnownList().getKnownCharactersInRadius(collision)) {
                if (!(nearby instanceof L2Attackable) || nearby == this.getAttackTarget()) continue;
                int diffx = Rnd.get(combinedCollision, combinedCollision + 40);
                if (Rnd.get(10) < 5) {
                    diffx = -diffx;
                }
                int diffy = Rnd.get(combinedCollision, combinedCollision + 40);
                if (Rnd.get(10) < 5) {
                    diffy = -diffy;
                }
                this.moveTo(this.getAttackTarget().getX() + diffx, this.getAttackTarget().getY() + diffy, this.getAttackTarget().getZ());
                return;
            }
        }
        if (!this._actor.isMovementDisabled() && ((L2Attackable)this._actor).getCanDodge() > 0 && Rnd.get(100) <= ((L2Attackable)this._actor).getCanDodge() && Math.sqrt(distance2 = this._actor.getPlanDistanceSq(this.getAttackTarget().getX(), this.getAttackTarget().getY())) <= (double)(60 + this._actor.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius)) {
            int posX = this._actor.getX();
            int posY = this._actor.getY();
            int posZ = this._actor.getZ();
            posX = Rnd.get(1) > 0 ? (posX += Rnd.get(100)) : (posX -= Rnd.get(100));
            posY = Rnd.get(1) > 0 ? (posY += Rnd.get(100)) : (posY -= Rnd.get(100));
            this.setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(posX, posY, posZ, 0));
            return;
        }
        if (this._actor.isRaid() || this._actor.isRaidMinion()) {
            ++this.chaostime;
            if (this._actor instanceof L2RaidBossInstance && !((L2MonsterInstance)this._actor).hasMinions()) {
                if (this.chaostime > Config.RAID_CHAOS_TIME && (double)Rnd.get(100) <= 100.0 - this._actor.getCurrentHp() * 100.0 / (double)this._actor.getMaxHp()) {
                    this.AggroReconsider();
                    this.chaostime = 0;
                }
            } else if (this._actor instanceof L2RaidBossInstance && ((L2MonsterInstance)this._actor).hasMinions()) {
                if (this.chaostime > Config.RAID_CHAOS_TIME && (double)Rnd.get(100) <= 100.0 - this._actor.getCurrentHp() * 200.0 / (double)this._actor.getMaxHp()) {
                    this.AggroReconsider();
                    this.chaostime = 0;
                }
            } else if (this._actor instanceof L2GrandBossInstance) {
                double chaosRate;
                if (this.chaostime > Config.GRAND_CHAOS_TIME && ((chaosRate = 100.0 - this._actor.getCurrentHp() * 300.0 / (double)this._actor.getMaxHp()) <= 10.0 && Rnd.get(100) <= 10 || chaosRate > 10.0 && (double)Rnd.get(100) <= chaosRate)) {
                    this.AggroReconsider();
                    this.chaostime = 0;
                }
            } else if (this.chaostime > Config.MINION_CHAOS_TIME && (double)Rnd.get(100) <= 100.0 - this._actor.getCurrentHp() * 200.0 / (double)this._actor.getMaxHp()) {
                this.AggroReconsider();
                this.chaostime = 0;
            }
        }
        if (this._skillrender.hasSkill()) {
            if (this._skillrender.hasHealSkill() && this._skillrender._healskills != null) {
                L2MonsterInstance leader;
                double percentage = this._actor.getCurrentHp() / (double)this._actor.getMaxHp() * 100.0;
                if (this._actor instanceof L2MinionInstance && (leader = ((L2MinionInstance)this._actor).getLeader()) != null && !leader.isDead() && (double)Rnd.get(100) > leader.getCurrentHp() / (double)leader.getMaxHp() * 100.0) {
                    for (L2Skill sk : this._skillrender._healskills) {
                        if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_SELF || (double)sk.getMpConsume() >= this._actor.getCurrentMp() || this._actor.isSkillDisabled(sk.getId()) || sk.isMagic() && this._actor.isMuted() || !sk.isMagic() && this._actor.isPhysicalMuted()) continue;
                        if (!(Util.checkIfInRange(sk.getCastRange() + this._actor.getTemplate().collisionRadius + ((L2Character)leader).getTemplate().collisionRadius, this._actor, leader, false) || this.isParty(sk) || this._actor.isMovementDisabled())) {
                            this.moveToPawn(leader, sk.getCastRange() + this._actor.getTemplate().collisionRadius + ((L2Character)leader).getTemplate().collisionRadius);
                        }
                        if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, leader)) continue;
                        this.clientStopMoving(null);
                        this._actor.setTarget(leader);
                        this.clientStopMoving(null);
                        this._actor.doCast(sk);
                        return;
                    }
                }
                if ((double)Rnd.get(100) < (100.0 - percentage) / 3.0) {
                    for (L2Skill sk : this._skillrender._healskills) {
                        if ((double)sk.getMpConsume() >= this._actor.getCurrentMp() || this._actor.isSkillDisabled(sk.getId()) || sk.isMagic() && this._actor.isMuted() || !sk.isMagic() && this._actor.isPhysicalMuted()) continue;
                        this.clientStopMoving(null);
                        this._actor.setTarget(this._actor);
                        this._actor.doCast(sk);
                        return;
                    }
                }
                for (L2Skill sk : this._skillrender._healskills) {
                    if ((double)sk.getMpConsume() >= this._actor.getCurrentMp() || this._actor.isSkillDisabled(sk.getId()) || sk.isMagic() && this._actor.isMuted() || !sk.isMagic() && this._actor.isPhysicalMuted()) continue;
                    if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_ONE) {
                        for (L2Character obj : this._actor.getKnownList().getKnownCharactersInRadius(sk.getCastRange() + this._actor.getTemplate().collisionRadius)) {
                            if (!(obj instanceof L2Attackable) || obj.isDead()) continue;
                            L2Attackable targets = (L2Attackable)obj;
                            if (((L2Attackable)this._actor).getFactionId() != targets.getFactionId() && ((L2Attackable)this._actor).getFactionId() != null) continue;
                            percentage = targets.getCurrentHp() / (double)targets.getMaxHp() * 100.0;
                            if (!((double)Rnd.get(100) < (100.0 - percentage) / 10.0) || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, targets)) continue;
                            this.clientStopMoving(null);
                            this._actor.setTarget(obj);
                            this._actor.doCast(sk);
                            return;
                        }
                    }
                    if (!this.isParty(sk)) continue;
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    return;
                }
            }
            if (this._skillrender.hasResSkill()) {
                L2MonsterInstance leader;
                if (this._actor instanceof L2MinionInstance && (leader = ((L2MinionInstance)this._actor).getLeader()) != null && leader.isDead()) {
                    for (L2Skill sk : this._skillrender._resskills) {
                        if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_SELF || (double)sk.getMpConsume() >= this._actor.getCurrentMp() || this._actor.isSkillDisabled(sk.getId()) || sk.isMagic() && this._actor.isMuted() || !sk.isMagic() && this._actor.isPhysicalMuted()) continue;
                        if (!(Util.checkIfInRange(sk.getCastRange() + this._actor.getTemplate().collisionRadius + ((L2Character)leader).getTemplate().collisionRadius, this._actor, leader, false) || this.isParty(sk) || this._actor.isMovementDisabled())) {
                            this.moveToPawn(leader, sk.getCastRange() + this._actor.getTemplate().collisionRadius + ((L2Character)leader).getTemplate().collisionRadius);
                        }
                        if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, leader)) continue;
                        this.clientStopMoving(null);
                        this._actor.setTarget(((L2MinionInstance)this._actor).getLeader());
                        this._actor.doCast(sk);
                        return;
                    }
                }
                for (L2Skill sk : this._skillrender._resskills) {
                    if ((double)sk.getMpConsume() >= this._actor.getCurrentMp() || this._actor.isSkillDisabled(sk.getId()) || sk.isMagic() && this._actor.isMuted() || !sk.isMagic() && this._actor.isPhysicalMuted()) continue;
                    if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_ONE) {
                        for (L2Character obj : this._actor.getKnownList().getKnownCharactersInRadius(sk.getCastRange() + this._actor.getTemplate().collisionRadius)) {
                            if (!(obj instanceof L2Attackable) || !obj.isDead()) continue;
                            L2Attackable targets = (L2Attackable)obj;
                            if (((L2Attackable)this._actor).getFactionId() != targets.getFactionId() && ((L2Attackable)this._actor).getFactionId() != null || Rnd.get(100) >= 10 || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, targets)) continue;
                            this.clientStopMoving(null);
                            this._actor.setTarget(obj);
                            this._actor.doCast(sk);
                            return;
                        }
                    }
                    if (!this.isParty(sk)) continue;
                    this.clientStopMoving(null);
                    L2Character target = this.getAttackTarget();
                    this._actor.setTarget(this._actor);
                    this._actor.doCast(sk);
                    this._actor.setTarget(target);
                    return;
                }
            }
        }
        if (this._actor.isMovementDisabled() && (dist > (double)range || this.getAttackTarget().isMoving()) || dist > (double)range && this.getAttackTarget().isMoving()) {
            this.MovementDisable();
            return;
        }
        this.setTimepass(0);
        if (this._skillrender.hasSkill()) {
            if (Rnd.get(100) <= ((L2Npc)this._actor).getSkillChance()) {
                L2Skill skills = (L2Skill)this._skillrender._generalskills.get(Rnd.nextInt(this._skillrender._generalskills.size()));
                if (this.Cast(skills)) {
                    return;
                }
                for (L2Skill sk : this._skillrender._generalskills) {
                    if (!this.Cast(sk)) continue;
                    return;
                }
            }
            if (((L2Npc)this._actor).hasLSkill() || ((L2Npc)this._actor).hasSSkill()) {
                if (((L2Npc)this._actor).hasSSkill() && dist2 <= 150 && Rnd.get(100) <= ((L2Npc)this._actor).getSSkillChance()) {
                    this.SSkillRender();
                    if (this._skillrender._Srangeskills != null) {
                        L2Skill skills = (L2Skill)this._skillrender._Srangeskills.get(Rnd.nextInt(this._skillrender._Srangeskills.size()));
                        if (this.Cast(skills)) {
                            return;
                        }
                        for (L2Skill sk : this._skillrender._Srangeskills) {
                            if (!this.Cast(sk)) continue;
                            return;
                        }
                    }
                }
                if (((L2Npc)this._actor).hasLSkill() && dist2 > 150 && Rnd.get(100) <= ((L2Npc)this._actor).getSSkillChance()) {
                    this.LSkillRender();
                    if (this._skillrender._Lrangeskills != null) {
                        L2Skill skills = (L2Skill)this._skillrender._Lrangeskills.get(Rnd.nextInt(this._skillrender._Lrangeskills.size()));
                        if (this.Cast(skills)) {
                            return;
                        }
                        for (L2Skill sk : this._skillrender._Lrangeskills) {
                            if (!this.Cast(sk)) continue;
                            return;
                        }
                    }
                }
            }
        }
        if (dist2 > range || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, this.getAttackTarget())) {
            if (this._actor.isMovementDisabled()) {
                this.TargetReconsider();
                return;
            }
            if (this.getAttackTarget().isMoving()) {
                range -= 100;
            }
            if (range < 5) {
                range = 5;
            }
            this.moveToPawn(this.getAttackTarget(), range);
            return;
        }
        this.Melee(((L2Npc)this._actor).getPrimaryAttack());
    }

    private void Melee(int type) {
        if (type != 0) {
            switch (type) {
                case -1: {
                    if (this._skillrender._generalskills == null) break;
                    for (L2Skill sk : this._skillrender._generalskills) {
                        if (!this.Cast(sk)) continue;
                        return;
                    }
                    break;
                }
                case 1: {
                    if (!this._skillrender.hasAtkSkill()) break;
                    for (L2Skill sk : this._skillrender._atkskills) {
                        if (!this.Cast(sk)) continue;
                        return;
                    }
                    break;
                }
                default: {
                    if (this._skillrender._generalskills == null) break;
                    for (L2Skill sk : this._skillrender._generalskills) {
                        if (sk.getId() != ((L2Npc)this._actor).getPrimaryAttack() || !this.Cast(sk)) continue;
                        return;
                    }
                }
            }
        }
        this._accessor.doAttack(this.getAttackTarget());
    }

    private boolean Cast(L2Skill sk) {
        L2Character attackTarget;
        if (sk == null) {
            return false;
        }
        if ((double)sk.getMpConsume() >= this._actor.getCurrentMp() || this._actor.isSkillDisabled(sk.getId()) || sk.isMagic() && this._actor.isMuted() || !sk.isMagic() && this._actor.isPhysicalMuted()) {
            return false;
        }
        if (this.getAttackTarget() == null && ((L2Attackable)this._actor).getMostHated() != null) {
            this.setAttackTarget(((L2Attackable)this._actor).getMostHated());
        }
        if ((attackTarget = this.getAttackTarget()) == null) {
            return false;
        }
        double dist = Math.sqrt(this._actor.getPlanDistanceSq(attackTarget.getX(), attackTarget.getY()));
        double dist2 = dist - (double)attackTarget.getTemplate().collisionRadius;
        double range = this._actor.getPhysicalAttackRange() + this._actor.getTemplate().collisionRadius + attackTarget.getTemplate().collisionRadius;
        double srange = sk.getCastRange() + this._actor.getTemplate().collisionRadius;
        if (attackTarget.isMoving()) {
            dist2 -= 30.0;
        }
        switch (sk.getSkillType()) {
            case BUFF: 
            case REFLECT: {
                L2Character target;
                if (this._actor.getFirstEffect(sk) == null) {
                    this.clientStopMoving(null);
                    this._actor.setTarget(this._actor);
                    this._actor.doCast(sk);
                    return true;
                }
                if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_SELF) {
                    return false;
                }
                if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_ONE && (target = this.EffectTargetReconsider(sk, true)) != null) {
                    this.clientStopMoving(null);
                    L2Character targets = attackTarget;
                    this._actor.setTarget(target);
                    this._actor.doCast(sk);
                    this._actor.setTarget(targets);
                    return true;
                }
                if (!this.canParty(sk)) break;
                this.clientStopMoving(null);
                L2Character targets = attackTarget;
                this._actor.setTarget(this._actor);
                this._actor.doCast(sk);
                this._actor.setTarget(targets);
                return true;
            }
            case HEAL: 
            case HOT: 
            case HEAL_PERCENT: 
            case HEAL_STATIC: 
            case BALANCE_LIFE: {
                L2Npc targets;
                L2MonsterInstance leader;
                double percentage = this._actor.getCurrentHp() / (double)this._actor.getMaxHp() * 100.0;
                if (this._actor instanceof L2MinionInstance && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_SELF && (leader = ((L2MinionInstance)this._actor).getLeader()) != null && !leader.isDead() && (double)Rnd.get(100) > leader.getCurrentHp() / (double)leader.getMaxHp() * 100.0) {
                    if (!(Util.checkIfInRange(sk.getCastRange() + this._actor.getTemplate().collisionRadius + ((L2Character)leader).getTemplate().collisionRadius, this._actor, leader, false) || this.isParty(sk) || this._actor.isMovementDisabled())) {
                        this.moveToPawn(leader, sk.getCastRange() + this._actor.getTemplate().collisionRadius + ((L2Character)leader).getTemplate().collisionRadius);
                    }
                    if (GeoData.getInstance().canSeeTarget((L2Object)this._actor, leader)) {
                        this.clientStopMoving(null);
                        this._actor.setTarget(leader);
                        this._actor.doCast(sk);
                        return true;
                    }
                }
                if ((double)Rnd.get(100) < (100.0 - percentage) / 3.0) {
                    this.clientStopMoving(null);
                    this._actor.setTarget(this._actor);
                    this._actor.doCast(sk);
                    return true;
                }
                if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_ONE) {
                    for (L2Character obj : this._actor.getKnownList().getKnownCharactersInRadius(sk.getCastRange() + this._actor.getTemplate().collisionRadius)) {
                        if (!(obj instanceof L2Attackable) || obj.isDead()) continue;
                        targets = (L2Attackable)obj;
                        if (((L2Attackable)this._actor).getFactionId() != targets.getFactionId() && ((L2Attackable)this._actor).getFactionId() != null) continue;
                        percentage = targets.getCurrentHp() / (double)targets.getMaxHp() * 100.0;
                        if (!((double)Rnd.get(100) < (100.0 - percentage) / 10.0) || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, targets)) continue;
                        this.clientStopMoving(null);
                        this._actor.setTarget(obj);
                        this._actor.doCast(sk);
                        return true;
                    }
                }
                if (!this.isParty(sk)) break;
                for (L2Character obj : this._actor.getKnownList().getKnownCharactersInRadius(sk.getSkillRadius() + this._actor.getTemplate().collisionRadius)) {
                    if (!(obj instanceof L2Attackable)) continue;
                    targets = (L2Npc)obj;
                    L2Npc actors = (L2Npc)this._actor;
                    if (actors.getFactionId() == null || !targets.getFactionId().equals(actors.getFactionId()) || !(obj.getCurrentHp() < (double)obj.getMaxHp()) || Rnd.get(100) > 20) continue;
                    this.clientStopMoving(null);
                    this._actor.setTarget(this._actor);
                    this._actor.doCast(sk);
                    return true;
                }
                break;
            }
            case RESURRECT: {
                if (!this.isParty(sk)) {
                    if (this._actor instanceof L2MinionInstance && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_SELF) {
                        L2MonsterInstance leader = ((L2MinionInstance)this._actor).getLeader();
                        if (leader != null && leader.isDead() && !Util.checkIfInRange(sk.getCastRange() + this._actor.getTemplate().collisionRadius + ((L2Character)leader).getTemplate().collisionRadius, this._actor, leader, false) && !this.isParty(sk) && !this._actor.isMovementDisabled()) {
                            this.moveToPawn(leader, sk.getCastRange() + this._actor.getTemplate().collisionRadius + ((L2Character)leader).getTemplate().collisionRadius);
                        }
                        if (GeoData.getInstance().canSeeTarget((L2Object)this._actor, leader)) {
                            this.clientStopMoving(null);
                            this._actor.setTarget(((L2MinionInstance)this._actor).getLeader());
                            this._actor.doCast(sk);
                            return true;
                        }
                    }
                    for (L2Character obj : this._actor.getKnownList().getKnownCharactersInRadius(sk.getCastRange() + this._actor.getTemplate().collisionRadius)) {
                        if (!(obj instanceof L2Attackable) || !obj.isDead()) continue;
                        L2Attackable targets = (L2Attackable)obj;
                        if (((L2Attackable)this._actor).getFactionId() != targets.getFactionId() && ((L2Attackable)this._actor).getFactionId() != null || Rnd.get(100) >= 10 || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, targets)) continue;
                        this.clientStopMoving(null);
                        this._actor.setTarget(obj);
                        this._actor.doCast(sk);
                        return true;
                    }
                } else {
                    if (!this.isParty(sk)) break;
                    for (L2Character obj : this._actor.getKnownList().getKnownCharactersInRadius(sk.getSkillRadius() + this._actor.getTemplate().collisionRadius)) {
                        if (!(obj instanceof L2Attackable)) continue;
                        L2Npc targets = (L2Npc)obj;
                        L2Npc actors = (L2Npc)this._actor;
                        if (actors.getFactionId() == null || !actors.getFactionId().equals(targets.getFactionId()) || !(obj.getCurrentHp() < (double)obj.getMaxHp()) || Rnd.get(100) > 20) continue;
                        this.clientStopMoving(null);
                        this._actor.setTarget(this._actor);
                        this._actor.doCast(sk);
                        return true;
                    }
                }
                break;
            }
            case DEBUFF: 
            case WEAKNESS: 
            case POISON: 
            case DOT: 
            case MDOT: 
            case BLEED: {
                L2Character target;
                if (GeoData.getInstance().canSeeTarget((L2Object)this._actor, attackTarget) && !this.canAOE(sk) && !attackTarget.isDead() && dist2 <= srange) {
                    if (attackTarget.getFirstEffect(sk) != null) break;
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    return true;
                }
                if (this.canAOE(sk)) {
                    if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_BEHIND_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_FRONT_AURA) {
                        this.clientStopMoving(null);
                        this._actor.doCast(sk);
                        return true;
                    }
                    if (sk.getTargetType() != L2Skill.SkillTargetType.TARGET_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_BEHIND_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_FRONT_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_MULTIFACE || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, attackTarget) || attackTarget.isDead() || !(dist2 <= srange)) break;
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    return true;
                }
                if (sk.getTargetType() != L2Skill.SkillTargetType.TARGET_ONE || (target = this.EffectTargetReconsider(sk, false)) == null) break;
                this.clientStopMoving(null);
                this._actor.doCast(sk);
                return true;
            }
            case SLEEP: {
                if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_ONE) {
                    if (attackTarget != null && !attackTarget.isDead() && dist2 <= srange && (dist2 > range || attackTarget.isMoving()) && attackTarget.getFirstEffect(sk) == null) {
                        this.clientStopMoving(null);
                        this._actor.doCast(sk);
                        return true;
                    }
                    L2Character target = this.EffectTargetReconsider(sk, false);
                    if (target == null) break;
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    return true;
                }
                if (!this.canAOE(sk)) break;
                if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_BEHIND_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_FRONT_AURA) {
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    return true;
                }
                if (sk.getTargetType() != L2Skill.SkillTargetType.TARGET_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_BEHIND_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_FRONT_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_MULTIFACE || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, attackTarget) || attackTarget.isDead() || !(dist2 <= srange)) break;
                this.clientStopMoving(null);
                this._actor.doCast(sk);
                return true;
            }
            case ROOT: 
            case STUN: 
            case PARALYZE: {
                L2Character target;
                if (GeoData.getInstance().canSeeTarget((L2Object)this._actor, attackTarget) && !this.canAOE(sk) && dist2 <= srange) {
                    if (attackTarget.getFirstEffect(sk) != null) break;
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    return true;
                }
                if (this.canAOE(sk)) {
                    if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_BEHIND_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_FRONT_AURA) {
                        this.clientStopMoving(null);
                        this._actor.doCast(sk);
                        return true;
                    }
                    if (sk.getTargetType() != L2Skill.SkillTargetType.TARGET_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_BEHIND_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_FRONT_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_MULTIFACE || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, attackTarget) || attackTarget.isDead() || !(dist2 <= srange)) break;
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    return true;
                }
                if (sk.getTargetType() != L2Skill.SkillTargetType.TARGET_ONE || (target = this.EffectTargetReconsider(sk, false)) == null) break;
                this.clientStopMoving(null);
                this._actor.doCast(sk);
                return true;
            }
            case MUTE: 
            case FEAR: {
                L2Character target;
                if (GeoData.getInstance().canSeeTarget((L2Object)this._actor, attackTarget) && !this.canAOE(sk) && dist2 <= srange) {
                    if (attackTarget.getFirstEffect(sk) != null) break;
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    return true;
                }
                if (this.canAOE(sk)) {
                    if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_BEHIND_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_FRONT_AURA) {
                        this.clientStopMoving(null);
                        this._actor.doCast(sk);
                        return true;
                    }
                    if (sk.getTargetType() != L2Skill.SkillTargetType.TARGET_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_BEHIND_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_FRONT_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_MULTIFACE || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, attackTarget) || attackTarget.isDead() || !(dist2 <= srange)) break;
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    return true;
                }
                if (sk.getTargetType() != L2Skill.SkillTargetType.TARGET_ONE || (target = this.EffectTargetReconsider(sk, false)) == null) break;
                this.clientStopMoving(null);
                this._actor.doCast(sk);
                return true;
            }
            case CANCEL: 
            case NEGATE: {
                if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_ONE) {
                    if (attackTarget.getFirstEffect(L2EffectType.BUFF) != null && GeoData.getInstance().canSeeTarget((L2Object)this._actor, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                        this.clientStopMoving(null);
                        this._actor.doCast(sk);
                        return true;
                    }
                    L2Character target = this.EffectTargetReconsider(sk, false);
                    if (target == null) break;
                    this.clientStopMoving(null);
                    L2Character targets = attackTarget;
                    this._actor.setTarget(target);
                    this._actor.doCast(sk);
                    this._actor.setTarget(targets);
                    return true;
                }
                if (!this.canAOE(sk)) break;
                if ((sk.getTargetType() == L2Skill.SkillTargetType.TARGET_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_BEHIND_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_FRONT_AURA) && GeoData.getInstance().canSeeTarget((L2Object)this._actor, attackTarget)) {
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    return true;
                }
                if (sk.getTargetType() != L2Skill.SkillTargetType.TARGET_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_BEHIND_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_FRONT_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_MULTIFACE || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, attackTarget) || attackTarget.isDead() || !(dist2 <= srange)) break;
                this.clientStopMoving(null);
                this._actor.doCast(sk);
                return true;
            }
            case PDAM: 
            case MDAM: 
            case BLOW: 
            case DRAIN: 
            case CHARGEDAM: 
            case DEATHLINK: 
            case CPDAM: 
            case MANADAM: {
                if (!this.canAura(sk)) {
                    if (GeoData.getInstance().canSeeTarget((L2Object)this._actor, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                        this.clientStopMoving(null);
                        this._actor.doCast(sk);
                        return true;
                    }
                    L2Character target = this.SkillTargetReconsider(sk);
                    if (target == null) break;
                    this.clientStopMoving(null);
                    L2Character targets = attackTarget;
                    this._actor.setTarget(target);
                    this._actor.doCast(sk);
                    this._actor.setTarget(targets);
                    return true;
                }
                this.clientStopMoving(null);
                this._actor.doCast(sk);
                return true;
            }
            default: {
                if (!this.canAura(sk)) {
                    if (GeoData.getInstance().canSeeTarget((L2Object)this._actor, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                        this.clientStopMoving(null);
                        this._actor.doCast(sk);
                        return true;
                    }
                    L2Character target = this.SkillTargetReconsider(sk);
                    if (target == null) break;
                    this.clientStopMoving(null);
                    L2Character targets = attackTarget;
                    this._actor.setTarget(target);
                    this._actor.doCast(sk);
                    this._actor.setTarget(targets);
                    return true;
                }
                this.clientStopMoving(null);
                this._actor.doCast(sk);
                return true;
            }
        }
        return false;
    }

    private void MovementDisable() {
        double dist = 0.0;
        double dist2 = 0.0;
        int range = 0;
        try {
            if (this._actor.getTarget() == null) {
                this._actor.setTarget(this.getAttackTarget());
            }
            dist = Math.sqrt(this._actor.getPlanDistanceSq(this.getAttackTarget().getX(), this.getAttackTarget().getY()));
            dist2 = dist - (double)this._actor.getTemplate().collisionRadius;
            range = this._actor.getPhysicalAttackRange() + this._actor.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius;
            if (this.getAttackTarget().isMoving()) {
                dist -= 30.0;
                if (this._actor.isMoving()) {
                    dist -= 50.0;
                }
            }
        }
        catch (NullPointerException e) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            return;
        }
        if (this._skillrender.hasSkill()) {
            int random = Rnd.get(100);
            if (this._skillrender.hasImmobiliseSkill() && !this.getAttackTarget().isImmobilized() && random < 2) {
                for (L2Skill sk : this._skillrender._immobiliseskills) {
                    if ((double)sk.getMpConsume() >= this._actor.getCurrentMp() || this._actor.isSkillDisabled(sk.getId()) || (double)(sk.getCastRange() + this._actor.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius) <= dist2 && !this.canAura(sk) || sk.isMagic() && this._actor.isMuted() || !sk.isMagic() && this._actor.isPhysicalMuted() || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, this.getAttackTarget()) || this.getAttackTarget().getFirstEffect(sk) != null) continue;
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    return;
                }
            }
            if (this._skillrender.hasCOTSkill() && random < 5) {
                for (L2Skill sk : this._skillrender._cotskills) {
                    if ((double)sk.getMpConsume() >= this._actor.getCurrentMp() || this._actor.isSkillDisabled(sk.getId()) || (double)(sk.getCastRange() + this._actor.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius) <= dist2 && !this.canAura(sk) || sk.isMagic() && this._actor.isMuted() || !sk.isMagic() && this._actor.isPhysicalMuted() || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, this.getAttackTarget()) || this.getAttackTarget().getFirstEffect(sk) != null) continue;
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    return;
                }
            }
            if (this._skillrender.hasDebuffSkill() && random < 8) {
                for (L2Skill sk : this._skillrender._debuffskills) {
                    if ((double)sk.getMpConsume() >= this._actor.getCurrentMp() || this._actor.isSkillDisabled(sk.getId()) || (double)(sk.getCastRange() + this._actor.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius) <= dist2 && !this.canAura(sk) || sk.isMagic() && this._actor.isMuted() || !sk.isMagic() && this._actor.isPhysicalMuted() || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, this.getAttackTarget()) || this.getAttackTarget().getFirstEffect(sk) != null) continue;
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    return;
                }
            }
            if (this._skillrender.hasNegativeSkill() && random < 9) {
                for (L2Skill sk : this._skillrender._negativeskills) {
                    if ((double)sk.getMpConsume() >= this._actor.getCurrentMp() || this._actor.isSkillDisabled(sk.getId()) || (double)(sk.getCastRange() + this._actor.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius) <= dist2 && !this.canAura(sk) || sk.isMagic() && this._actor.isMuted() || !sk.isMagic() && this._actor.isPhysicalMuted() || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, this.getAttackTarget()) || this.getAttackTarget().getFirstEffect(L2EffectType.BUFF) == null) continue;
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    return;
                }
            }
            if (this._skillrender.hasAtkSkill()) {
                for (L2Skill sk : this._skillrender._atkskills) {
                    if ((double)sk.getMpConsume() >= this._actor.getCurrentMp() || this._actor.isSkillDisabled(sk.getId()) || (double)(sk.getCastRange() + this._actor.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius) <= dist2 && !this.canAura(sk) || sk.isMagic() && this._actor.isMuted() || !sk.isMagic() && this._actor.isPhysicalMuted() || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, this.getAttackTarget())) continue;
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    return;
                }
            }
        }
        if (this._actor.isMovementDisabled()) {
            this.TargetReconsider();
            return;
        }
        if (dist > (double)range || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, this.getAttackTarget())) {
            if (this.getAttackTarget().isMoving()) {
                range -= 100;
            }
            if (range < 5) {
                range = 5;
            }
            this.moveToPawn(this.getAttackTarget(), range);
            return;
        }
        this.Melee(((L2Npc)this._actor).getPrimaryAttack());
    }

    private L2Character EffectTargetReconsider(L2Skill sk, boolean positive) {
        if (sk == null) {
            return null;
        }
        if (sk.getSkillType() != L2SkillType.NEGATE || sk.getSkillType() != L2SkillType.CANCEL) {
            if (!positive) {
                double dist = 0.0;
                double dist2 = 0.0;
                int range = 0;
                L2Attackable actor = (L2Attackable)this._actor;
                if (actor.getAttackByList() != null) {
                    for (L2Character obj : actor.getAttackByList()) {
                        block20: {
                            if (obj == null || obj.isDead() || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, obj) || obj == this.getAttackTarget()) continue;
                            try {
                                this._actor.setTarget(this.getAttackTarget());
                                dist = Math.sqrt(this._actor.getPlanDistanceSq(obj.getX(), obj.getY()));
                                dist2 = dist - (double)this._actor.getTemplate().collisionRadius;
                                range = sk.getCastRange() + this._actor.getTemplate().collisionRadius + obj.getTemplate().collisionRadius;
                                if (!obj.isMoving()) break block20;
                                dist2 -= 70.0;
                            }
                            catch (NullPointerException e) {
                                continue;
                            }
                        }
                        if (!(dist2 <= (double)range) || this.getAttackTarget().getFirstEffect(sk) != null) continue;
                        return obj;
                    }
                }
                for (L2Character obj : this._actor.getKnownList().getKnownCharactersInRadius(range)) {
                    block21: {
                        if (obj.isDead() || obj == null || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, obj)) continue;
                        try {
                            this._actor.setTarget(this.getAttackTarget());
                            dist2 = dist = Math.sqrt(this._actor.getPlanDistanceSq(obj.getX(), obj.getY()));
                            range = sk.getCastRange() + this._actor.getTemplate().collisionRadius + obj.getTemplate().collisionRadius;
                            if (!obj.isMoving()) break block21;
                            dist2 -= 70.0;
                        }
                        catch (NullPointerException e) {
                            continue;
                        }
                    }
                    if (obj instanceof L2Attackable && ((L2Attackable)this._actor).getEnemyClan() != null && ((L2Attackable)this._actor).getEnemyClan().equals(((L2Attackable)obj).getClan()) && dist2 <= (double)range && this.getAttackTarget().getFirstEffect(sk) == null) {
                        return obj;
                    }
                    if (!(obj instanceof L2PcInstance) && !(obj instanceof L2Summon) || !(dist2 <= (double)range) || this.getAttackTarget().getFirstEffect(sk) != null) continue;
                    return obj;
                }
            } else if (positive) {
                double dist = 0.0;
                double dist2 = 0.0;
                int range = 0;
                for (L2Character obj : this._actor.getKnownList().getKnownCharactersInRadius(range)) {
                    block22: {
                        if (!(obj instanceof L2Attackable) || obj.isDead() || obj == null || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, obj)) continue;
                        L2Attackable targets = (L2Attackable)obj;
                        if (((L2Attackable)this._actor).getFactionId() != targets.getFactionId() && ((L2Attackable)this._actor).getFactionId() != null) continue;
                        try {
                            this._actor.setTarget(this.getAttackTarget());
                            dist = Math.sqrt(this._actor.getPlanDistanceSq(obj.getX(), obj.getY()));
                            dist2 = dist - (double)this._actor.getTemplate().collisionRadius;
                            range = sk.getCastRange() + this._actor.getTemplate().collisionRadius + obj.getTemplate().collisionRadius;
                            if (!obj.isMoving()) break block22;
                            dist2 -= 70.0;
                        }
                        catch (NullPointerException e) {
                            continue;
                        }
                    }
                    if (!(dist2 <= (double)range) || obj.getFirstEffect(sk) != null) continue;
                    return obj;
                }
            }
            return null;
        }
        double dist = 0.0;
        double dist2 = 0.0;
        int range = 0;
        range = sk.getCastRange() + this._actor.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius;
        for (L2Character obj : this._actor.getKnownList().getKnownCharactersInRadius(range)) {
            block23: {
                if (obj == null || obj.isDead() || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, obj)) continue;
                try {
                    this._actor.setTarget(this.getAttackTarget());
                    dist = Math.sqrt(this._actor.getPlanDistanceSq(obj.getX(), obj.getY()));
                    dist2 = dist - (double)this._actor.getTemplate().collisionRadius;
                    range = sk.getCastRange() + this._actor.getTemplate().collisionRadius + obj.getTemplate().collisionRadius;
                    if (!obj.isMoving()) break block23;
                    dist2 -= 70.0;
                }
                catch (NullPointerException e) {
                    continue;
                }
            }
            if (obj instanceof L2Attackable && ((L2Attackable)this._actor).getEnemyClan() != null && ((L2Attackable)this._actor).getEnemyClan().equals(((L2Attackable)obj).getClan()) && dist2 <= (double)range && this.getAttackTarget().getFirstEffect(L2EffectType.BUFF) != null) {
                return obj;
            }
            if (!(obj instanceof L2PcInstance) && !(obj instanceof L2Summon) || !(dist2 <= (double)range) || this.getAttackTarget().getFirstEffect(L2EffectType.BUFF) == null) continue;
            return obj;
        }
        return null;
    }

    private L2Character SkillTargetReconsider(L2Skill sk) {
        double dist = 0.0;
        double dist2 = 0.0;
        int range = 0;
        L2Attackable actor = (L2Attackable)this._actor;
        if (actor.getHateList() != null) {
            for (L2Character obj : actor.getHateList()) {
                if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, obj) || obj.isDead()) continue;
                try {
                    this._actor.setTarget(this.getAttackTarget());
                    dist = Math.sqrt(this._actor.getPlanDistanceSq(obj.getX(), obj.getY()));
                    dist2 = dist - (double)this._actor.getTemplate().collisionRadius;
                    range = sk.getCastRange() + this._actor.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius;
                }
                catch (NullPointerException e) {
                    continue;
                }
                if (!(dist2 <= (double)range)) continue;
                return obj;
            }
        }
        if (!(this._actor instanceof L2GuardInstance)) {
            Collection<L2Object> objs = this._actor.getKnownList().getKnownObjects().values();
            for (L2Object target : objs) {
                try {
                    this._actor.setTarget(this.getAttackTarget());
                    dist2 = dist = Math.sqrt(this._actor.getPlanDistanceSq(target.getX(), target.getY()));
                    range = sk.getCastRange() + this._actor.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius;
                }
                catch (NullPointerException e) {
                    continue;
                }
                L2Character obj = null;
                if (target instanceof L2Character) {
                    obj = (L2Character)target;
                }
                if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, obj) || dist2 > (double)range) continue;
                if (obj instanceof L2PcInstance) {
                    return obj;
                }
                if (obj instanceof L2Attackable) {
                    if (((L2Attackable)this._actor).getEnemyClan() != null && ((L2Attackable)this._actor).getEnemyClan().equals(((L2Attackable)obj).getClan())) {
                        return obj;
                    }
                    if (((L2Attackable)this._actor).getIsChaos() != 0) {
                        if (((L2Attackable)obj).getFactionId() != null && ((L2Attackable)obj).getFactionId().equals(((L2Attackable)this._actor).getFactionId())) continue;
                        return obj;
                    }
                }
                if (!(obj instanceof L2Summon)) continue;
                return obj;
            }
        }
        return null;
    }

    private void TargetReconsider() {
        double dist = 0.0;
        double dist2 = 0.0;
        int range = 0;
        L2Attackable actor = (L2Attackable)this._actor;
        L2Character MostHate = ((L2Attackable)this._actor).getMostHated();
        if (actor.getHateList() != null) {
            for (L2Character obj : actor.getHateList()) {
                block18: {
                    if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, obj) || obj.isDead() || obj != MostHate || obj == this._actor) continue;
                    try {
                        dist = Math.sqrt(this._actor.getPlanDistanceSq(obj.getX(), obj.getY()));
                        dist2 = dist - (double)this._actor.getTemplate().collisionRadius;
                        range = this._actor.getPhysicalAttackRange() + this._actor.getTemplate().collisionRadius + obj.getTemplate().collisionRadius;
                        if (!obj.isMoving()) break block18;
                        dist2 -= 70.0;
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                }
                if (!(dist2 <= (double)range)) continue;
                if (MostHate != null) {
                    actor.addDamageHate(obj, actor.getHating(MostHate), actor.getHating(MostHate));
                } else {
                    actor.addDamageHate(obj, 2000, 2000);
                }
                this._actor.setTarget(obj);
                this.setAttackTarget(obj);
                return;
            }
        }
        if (!(this._actor instanceof L2GuardInstance)) {
            Collection<L2Object> objs = this._actor.getKnownList().getKnownObjects().values();
            for (L2Object target : objs) {
                L2Character obj = null;
                if (target instanceof L2Character) {
                    obj = (L2Character)target;
                }
                if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, obj) || obj.isDead() || obj != MostHate || obj == this._actor || obj == this.getAttackTarget()) continue;
                if (obj instanceof L2PcInstance) {
                    if (MostHate != null) {
                        actor.addDamageHate(obj, actor.getHating(MostHate), actor.getHating(MostHate));
                    } else {
                        actor.addDamageHate(obj, 2000, 2000);
                    }
                    this._actor.setTarget(obj);
                    this.setAttackTarget(obj);
                    continue;
                }
                if (obj instanceof L2Attackable) {
                    if (((L2Attackable)this._actor).getEnemyClan() != null && ((L2Attackable)this._actor).getEnemyClan().equals(((L2Attackable)obj).getClan())) {
                        actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                        this._actor.setTarget(obj);
                    }
                    if (((L2Attackable)this._actor).getIsChaos() == 0 || ((L2Attackable)obj).getFactionId() != null && ((L2Attackable)obj).getFactionId().equals(((L2Attackable)this._actor).getFactionId())) continue;
                    if (MostHate != null) {
                        actor.addDamageHate(obj, actor.getHating(MostHate), actor.getHating(MostHate));
                    } else {
                        actor.addDamageHate(obj, 2000, 2000);
                    }
                    this._actor.setTarget(obj);
                    this.setAttackTarget(obj);
                    continue;
                }
                if (!(obj instanceof L2Summon)) continue;
                if (MostHate != null) {
                    actor.addDamageHate(obj, actor.getHating(MostHate), actor.getHating(MostHate));
                } else {
                    actor.addDamageHate(obj, 2000, 2000);
                }
                this._actor.setTarget(obj);
                this.setAttackTarget(obj);
            }
        }
    }

    private void AggroReconsider() {
        L2Attackable actor = (L2Attackable)this._actor;
        L2Character MostHate = ((L2Attackable)this._actor).getMostHated();
        if (actor.getHateList() != null) {
            int rand = Rnd.get(actor.getHateList().size());
            int count = 0;
            for (L2Character obj : actor.getHateList()) {
                if (count < rand) {
                    ++count;
                    continue;
                }
                if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, obj) || obj.isDead() || obj == this.getAttackTarget() || obj == actor) continue;
                try {
                    this._actor.setTarget(this.getAttackTarget());
                }
                catch (NullPointerException e) {
                    continue;
                }
                if (MostHate != null) {
                    actor.addDamageHate(obj, actor.getHating(MostHate), actor.getHating(MostHate));
                } else {
                    actor.addDamageHate(obj, 2000, 2000);
                }
                this._actor.setTarget(obj);
                this.setAttackTarget(obj);
                return;
            }
        }
        if (!(this._actor instanceof L2GuardInstance)) {
            Collection<L2Object> objs = this._actor.getKnownList().getKnownObjects().values();
            for (L2Object target : objs) {
                L2Character obj;
                obj = null;
                if (!(target instanceof L2Character) || (obj = (L2Character)target) == null || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, obj) || obj.isDead() || obj != MostHate || obj == this._actor) continue;
                if (obj instanceof L2PcInstance) {
                    if (MostHate != null || !MostHate.isDead()) {
                        actor.addDamageHate(obj, actor.getHating(MostHate), actor.getHating(MostHate));
                    } else {
                        actor.addDamageHate(obj, 2000, 2000);
                    }
                    this._actor.setTarget(obj);
                    this.setAttackTarget(obj);
                    continue;
                }
                if (obj instanceof L2Attackable) {
                    if (((L2Attackable)this._actor).getEnemyClan() != null && ((L2Attackable)this._actor).getEnemyClan().equals(((L2Attackable)obj).getClan())) {
                        if (MostHate != null) {
                            actor.addDamageHate(obj, actor.getHating(MostHate), actor.getHating(MostHate));
                        } else {
                            actor.addDamageHate(obj, 2000, 2000);
                        }
                        this._actor.setTarget(obj);
                    }
                    if (((L2Attackable)this._actor).getIsChaos() == 0 || ((L2Attackable)obj).getFactionId() != null && ((L2Attackable)obj).getFactionId().equals(((L2Attackable)this._actor).getFactionId())) continue;
                    if (MostHate != null) {
                        actor.addDamageHate(obj, actor.getHating(MostHate), actor.getHating(MostHate));
                    } else {
                        actor.addDamageHate(obj, 2000, 2000);
                    }
                    this._actor.setTarget(obj);
                    this.setAttackTarget(obj);
                    continue;
                }
                if (!(obj instanceof L2Summon)) continue;
                if (MostHate != null) {
                    actor.addDamageHate(obj, actor.getHating(MostHate), actor.getHating(MostHate));
                } else {
                    actor.addDamageHate(obj, 2000, 2000);
                }
                this._actor.setTarget(obj);
                this.setAttackTarget(obj);
            }
        }
    }

    private void LSkillRender() {
        if (this._skillrender._Lrangeskills == null) {
            this._skillrender._Lrangeskills = ((L2Npc)this._actor).getLrangeSkill();
        }
    }

    private void SSkillRender() {
        if (this._skillrender._Srangeskills == null) {
            this._skillrender._Srangeskills = ((L2Npc)this._actor).getSrangeSkill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onEvtThink() {
        if (this._thinking || this._actor.isAllSkillsDisabled()) {
            return;
        }
        this._thinking = true;
        try {
            if (this.getIntention() == CtrlIntention.AI_INTENTION_ACTIVE) {
                this.thinkActive();
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_ATTACK) {
                this.thinkAttack();
            }
        }
        finally {
            this._thinking = false;
        }
    }

    @Override
    protected void onEvtAttacked(L2Character attacker) {
        this._attackTimeout = 300 + GameTimeController.getGameTicks();
        if (this._globalAggro < 0) {
            this._globalAggro = 0;
        }
        ((L2Attackable)this._actor).addDamageHate(attacker, 0, 1);
        if (!this._actor.isRunning()) {
            this._actor.setRunning();
        }
        if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, attacker);
        } else if (((L2Attackable)this._actor).getMostHated() != this.getAttackTarget()) {
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, attacker);
        }
        super.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtAggression(L2Character target, int aggro) {
        L2Attackable me = (L2Attackable)this._actor;
        if (target != null) {
            me.addDamageHate(target, 0, aggro);
            if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
                if (!this._actor.isRunning()) {
                    this._actor.setRunning();
                }
                this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
            }
        }
    }

    @Override
    protected void onIntentionActive() {
        this._attackTimeout = Integer.MAX_VALUE;
        super.onIntentionActive();
    }

    public void setGlobalAggro(int value) {
        this._globalAggro = value;
    }

    public void setTimepass(int TP) {
        this.timepass = TP;
    }

    public int getTimepass() {
        return this.timepass;
    }
}

