/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai2;

import com.l2jserver.gameserver.ai2.AiEvent;
import com.l2jserver.gameserver.ai2.AiEventType;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import java.util.EnumSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import javolution.util.FastList;

public class AiParameters {
    private Queue<AiEvent> _eventQueue = new PriorityBlockingQueue<AiEvent>();
    private EnumSet<AiEventType> _inhibitions;
    private L2Npc _actor;
    private List<Hated> _hated = new FastList();
    private List<Liked> _liked = new FastList();

    public AiParameters(L2Npc actor) {
        this._actor = actor;
        this._inhibitions = EnumSet.noneOf(AiEventType.class);
    }

    public boolean hasEvents() {
        return this._eventQueue.isEmpty();
    }

    public AiEvent nextEvent() {
        return this._eventQueue.poll();
    }

    public void queueEvents(AiEvent set) {
        this._eventQueue.offer(set);
    }

    public L2Npc getActor() {
        return this._actor;
    }

    public List<Hated> getHated() {
        return this._hated;
    }

    public List<Liked> getLiked() {
        return this._liked;
    }

    public void addLiked(Liked cha) {
        this._liked.add(cha);
    }

    public void addHated(Hated cha) {
        this._hated.add(cha);
    }

    public void clear() {
        this._hated.clear();
        this._liked.clear();
        this._eventQueue.clear();
        this._inhibitions.clear();
    }

    public void inhibit(AiEventType type) {
        this._inhibitions.add(type);
    }

    public void deInhibit(AiEventType type) {
        this._inhibitions.remove((Object)type);
    }

    public boolean isEventInhibited(AiEventType type) {
        return this._inhibitions.contains((Object)type);
    }

    public static enum LikeReason {
        FRIEND,
        HEALED,
        HEALED_FRIEND,
        GAVE_DAMMAGE_TO_ENNEMY;

    }

    public static enum HateReason {
        GAVE_DAMMAGE,
        HEALS_ENNEMY,
        GAVE_DAMMAGE_TO_FRIEND,
        IS_ENNEMY;

    }

    public class Liked {
        public L2Character character;
        public LikeReason reason;
        public int degree;
    }

    public class Hated {
        public L2Character character;
        public HateReason reason;
        public int degree;
    }
}

