/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handler;

import com.l2jserver.gameserver.handler.IItemHandler;
import com.l2jserver.gameserver.templates.item.L2EtcItem;
import java.util.Map;
import javolution.util.FastMap;

public class ItemHandler {
    private Map<String, IItemHandler> _datatable = new FastMap();

    public static ItemHandler getInstance() {
        return SingletonHolder._instance;
    }

    public int size() {
        return this._datatable.size();
    }

    private ItemHandler() {
    }

    public void registerItemHandler(IItemHandler handler) {
        this._datatable.put(handler.getClass().getSimpleName().intern(), handler);
    }

    public IItemHandler getItemHandler(L2EtcItem item) {
        if (item == null) {
            return null;
        }
        return this._datatable.get(item.getHandlerName());
    }

    private static class SingletonHolder {
        protected static final ItemHandler _instance = new ItemHandler();

        private SingletonHolder() {
        }
    }
}

