/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GmListTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public final class PetitionManager {
    protected static final Logger _log = Logger.getLogger(PetitionManager.class.getName());
    private Map<Integer, Petition> _pendingPetitions;
    private Map<Integer, Petition> _completedPetitions;

    public static PetitionManager getInstance() {
        return SingletonHolder._instance;
    }

    private PetitionManager() {
        _log.info("Initializing PetitionManager");
        this._pendingPetitions = new FastMap();
        this._completedPetitions = new FastMap();
    }

    public void clearCompletedPetitions() {
        int numPetitions = this.getPendingPetitionCount();
        this.getCompletedPetitions().clear();
        _log.info("PetitionManager: Completed petition data cleared. " + numPetitions + " petition(s) removed.");
    }

    public void clearPendingPetitions() {
        int numPetitions = this.getPendingPetitionCount();
        this.getPendingPetitions().clear();
        _log.info("PetitionManager: Pending petition queue cleared. " + numPetitions + " petition(s) removed.");
    }

    public boolean acceptPetition(L2PcInstance respondingAdmin, int petitionId) {
        if (!this.isValidPetition(petitionId)) {
            return false;
        }
        Petition currPetition = this.getPendingPetitions().get(petitionId);
        if (currPetition.getResponder() != null) {
            return false;
        }
        currPetition.setResponder(respondingAdmin);
        currPetition.setState(PetitionState.In_Process);
        currPetition.sendPetitionerPacket(new SystemMessage(SystemMessageId.PETITION_APP_ACCEPTED));
        SystemMessage sm = new SystemMessage(SystemMessageId.PETITION_ACCEPTED_RECENT_NO_S1);
        sm.addNumber(currPetition.getId());
        currPetition.sendResponderPacket(sm);
        sm = new SystemMessage(SystemMessageId.STARTING_PETITION_WITH_C1);
        sm.addString(currPetition.getPetitioner().getName());
        currPetition.sendResponderPacket(sm);
        return true;
    }

    public boolean cancelActivePetition(L2PcInstance player) {
        for (Petition currPetition : this.getPendingPetitions().values()) {
            if (currPetition.getPetitioner() != null && currPetition.getPetitioner().getObjectId() == player.getObjectId()) {
                return currPetition.endPetitionConsultation(PetitionState.Petitioner_Cancel);
            }
            if (currPetition.getResponder() == null || currPetition.getResponder().getObjectId() != player.getObjectId()) continue;
            return currPetition.endPetitionConsultation(PetitionState.Responder_Cancel);
        }
        return false;
    }

    public void checkPetitionMessages(L2PcInstance petitioner) {
        if (petitioner != null) {
            for (Petition currPetition : this.getPendingPetitions().values()) {
                if (currPetition == null || currPetition.getPetitioner() == null || currPetition.getPetitioner().getObjectId() != petitioner.getObjectId()) continue;
                for (CreatureSay logMessage : currPetition.getLogMessages()) {
                    petitioner.sendPacket(logMessage);
                }
                return;
            }
        }
    }

    public boolean endActivePetition(L2PcInstance player) {
        if (!player.isGM()) {
            return false;
        }
        for (Petition currPetition : this.getPendingPetitions().values()) {
            if (currPetition == null || currPetition.getResponder() == null || currPetition.getResponder().getObjectId() != player.getObjectId()) continue;
            return currPetition.endPetitionConsultation(PetitionState.Completed);
        }
        return false;
    }

    protected Map<Integer, Petition> getCompletedPetitions() {
        return this._completedPetitions;
    }

    protected Map<Integer, Petition> getPendingPetitions() {
        return this._pendingPetitions;
    }

    public int getPendingPetitionCount() {
        return this.getPendingPetitions().size();
    }

    public int getPlayerTotalPetitionCount(L2PcInstance player) {
        if (player == null) {
            return 0;
        }
        int petitionCount = 0;
        for (Petition currPetition : this.getPendingPetitions().values()) {
            if (currPetition == null || currPetition.getPetitioner() == null || currPetition.getPetitioner().getObjectId() != player.getObjectId()) continue;
            ++petitionCount;
        }
        for (Petition currPetition : this.getCompletedPetitions().values()) {
            if (currPetition == null || currPetition.getPetitioner() == null || currPetition.getPetitioner().getObjectId() != player.getObjectId()) continue;
            ++petitionCount;
        }
        return petitionCount;
    }

    public boolean isPetitionInProcess() {
        for (Petition currPetition : this.getPendingPetitions().values()) {
            if (currPetition == null || currPetition.getState() != PetitionState.In_Process) continue;
            return true;
        }
        return false;
    }

    public boolean isPetitionInProcess(int petitionId) {
        if (!this.isValidPetition(petitionId)) {
            return false;
        }
        Petition currPetition = this.getPendingPetitions().get(petitionId);
        return currPetition.getState() == PetitionState.In_Process;
    }

    public boolean isPlayerInConsultation(L2PcInstance player) {
        if (player != null) {
            for (Petition currPetition : this.getPendingPetitions().values()) {
                if (currPetition == null || currPetition.getState() != PetitionState.In_Process || (currPetition.getPetitioner() == null || currPetition.getPetitioner().getObjectId() != player.getObjectId()) && (currPetition.getResponder() == null || currPetition.getResponder().getObjectId() != player.getObjectId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPetitioningAllowed() {
        return Config.PETITIONING_ALLOWED;
    }

    public boolean isPlayerPetitionPending(L2PcInstance petitioner) {
        if (petitioner != null) {
            for (Petition currPetition : this.getPendingPetitions().values()) {
                if (currPetition == null || currPetition.getPetitioner() == null || currPetition.getPetitioner().getObjectId() != petitioner.getObjectId()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidPetition(int petitionId) {
        return this.getPendingPetitions().containsKey(petitionId);
    }

    public boolean rejectPetition(L2PcInstance respondingAdmin, int petitionId) {
        if (!this.isValidPetition(petitionId)) {
            return false;
        }
        Petition currPetition = this.getPendingPetitions().get(petitionId);
        if (currPetition.getResponder() != null) {
            return false;
        }
        currPetition.setResponder(respondingAdmin);
        return currPetition.endPetitionConsultation(PetitionState.Responder_Reject);
    }

    public boolean sendActivePetitionMessage(L2PcInstance player, String messageText) {
        for (Petition currPetition : this.getPendingPetitions().values()) {
            if (currPetition == null) continue;
            if (currPetition.getPetitioner() != null && currPetition.getPetitioner().getObjectId() == player.getObjectId()) {
                CreatureSay cs = new CreatureSay(player.getObjectId(), 6, player.getName(), messageText);
                currPetition.addLogMessage(cs);
                currPetition.sendResponderPacket(cs);
                currPetition.sendPetitionerPacket(cs);
                return true;
            }
            if (currPetition.getResponder() == null || currPetition.getResponder().getObjectId() != player.getObjectId()) continue;
            CreatureSay cs = new CreatureSay(player.getObjectId(), 7, player.getName(), messageText);
            currPetition.addLogMessage(cs);
            currPetition.sendResponderPacket(cs);
            currPetition.sendPetitionerPacket(cs);
            return true;
        }
        return false;
    }

    public void sendPendingPetitionList(L2PcInstance activeChar) {
        StringBuilder htmlContent = StringUtil.startAppend(400 + this.getPendingPetitionCount() * 300, "<html><body><center><font color=\"LEVEL\">Current Petitions</font><br><table width=\"300\">");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM HH:mm z");
        if (this.getPendingPetitionCount() == 0) {
            htmlContent.append("<tr><td colspan=\"4\">There are no currently pending petitions.</td></tr>");
        } else {
            htmlContent.append("<tr><td></td><td><font color=\"999999\">Petitioner</font></td><td><font color=\"999999\">Petition Type</font></td><td><font color=\"999999\">Submitted</font></td></tr>");
        }
        for (Petition currPetition : this.getPendingPetitions().values()) {
            if (currPetition == null) continue;
            htmlContent.append("<tr><td>");
            if (currPetition.getState() != PetitionState.In_Process) {
                StringUtil.append(htmlContent, "<button value=\"View\" action=\"bypass -h admin_view_petition ", String.valueOf(currPetition.getId()), "\" width=\"40\" height=\"15\" back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\">");
            } else {
                htmlContent.append("<font color=\"999999\">In Process</font>");
            }
            StringUtil.append(htmlContent, "</td><td>", currPetition.getPetitioner().getName(), "</td><td>", currPetition.getTypeAsString(), "</td><td>", dateFormat.format(new Date(currPetition.getSubmitTime())), "</td></tr>");
        }
        htmlContent.append("</table><br><button value=\"Refresh\" action=\"bypass -h admin_view_petitions\" width=\"50\" height=\"15\" back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"><br><button value=\"Back\" action=\"bypass -h admin_admin\" width=\"40\" height=\"15\" back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></center></body></html>");
        NpcHtmlMessage htmlMsg = new NpcHtmlMessage(0);
        htmlMsg.setHtml(htmlContent.toString());
        activeChar.sendPacket(htmlMsg);
    }

    public int submitPetition(L2PcInstance petitioner, String petitionText, int petitionType) {
        Petition newPetition = new Petition(petitioner, petitionText, petitionType);
        int newPetitionId = newPetition.getId();
        this.getPendingPetitions().put(newPetitionId, newPetition);
        String msgContent = petitioner.getName() + " has submitted a new petition.";
        GmListTable.broadcastToGMs(new CreatureSay(petitioner.getObjectId(), 17, "Petition System", msgContent));
        return newPetitionId;
    }

    public void viewPetition(L2PcInstance activeChar, int petitionId) {
        if (!activeChar.isGM()) {
            return;
        }
        if (!this.isValidPetition(petitionId)) {
            return;
        }
        Petition currPetition = this.getPendingPetitions().get(petitionId);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE dd MMM HH:mm z");
        String htmlContent = StringUtil.concat("<html><body><center><br><font color=\"LEVEL\">Petition #", String.valueOf(currPetition.getId()), "</font><br1><img src=\"L2UI.SquareGray\" width=\"200\" height=\"1\"></center><br>Submit Time: ", dateFormat.format(new Date(currPetition.getSubmitTime())), "<br1>Petitioner: ", currPetition.getPetitioner().getName(), "<br1>Petition Type: ", currPetition.getTypeAsString(), "<br>", currPetition.getContent(), "<br><center><button value=\"Accept\" action=\"bypass -h admin_accept_petition ", String.valueOf(currPetition.getId()), "\" width=\"50\" height=\"15\" back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"><br1><button value=\"Reject\" action=\"bypass -h admin_reject_petition ", String.valueOf(currPetition.getId()), "\" width=\"50\" height=\"15\" back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"><br><button value=\"Back\" action=\"bypass -h admin_view_petitions\" width=\"40\" height=\"15\" back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></center></body></html>");
        NpcHtmlMessage htmlMsg = new NpcHtmlMessage(0);
        htmlMsg.setHtml(htmlContent);
        activeChar.sendPacket(htmlMsg);
    }

    private static class SingletonHolder {
        protected static final PetitionManager _instance = new PetitionManager();

        private SingletonHolder() {
        }
    }

    private class Petition {
        private long _submitTime = System.currentTimeMillis();
        private long _endTime = -1L;
        private int _id;
        private PetitionType _type;
        private PetitionState _state = PetitionState.Pending;
        private String _content;
        private List<CreatureSay> _messageLog = new FastList();
        private L2PcInstance _petitioner;
        private L2PcInstance _responder;

        public Petition(L2PcInstance petitioner, String petitionText, int petitionType) {
            this._id = IdFactory.getInstance().getNextId();
            if (--petitionType >= PetitionType.values().length) {
                _log.warning("PetitionManager:Petition : invalid petition type (received type was +1) : " + petitionType);
            }
            this._type = PetitionType.values()[petitionType];
            this._content = petitionText;
            this._petitioner = petitioner;
        }

        protected boolean addLogMessage(CreatureSay cs) {
            return this._messageLog.add(cs);
        }

        protected List<CreatureSay> getLogMessages() {
            return this._messageLog;
        }

        public boolean endPetitionConsultation(PetitionState endState) {
            this.setState(endState);
            this._endTime = System.currentTimeMillis();
            if (this.getResponder() != null && this.getResponder().isOnline() == 1) {
                if (endState == PetitionState.Responder_Reject) {
                    this.getPetitioner().sendMessage("Your petition was rejected. Please try again later.");
                } else {
                    SystemMessage sm = new SystemMessage(SystemMessageId.PETITION_ENDED_WITH_C1);
                    sm.addString(this.getPetitioner().getName());
                    this.getResponder().sendPacket(sm);
                    if (endState == PetitionState.Petitioner_Cancel) {
                        sm = new SystemMessage(SystemMessageId.RECENT_NO_S1_CANCELED);
                        sm.addNumber(this.getId());
                        this.getResponder().sendPacket(sm);
                    }
                }
            }
            if (this.getPetitioner() != null && this.getPetitioner().isOnline() == 1) {
                this.getPetitioner().sendPacket(new SystemMessage(SystemMessageId.THIS_END_THE_PETITION_PLEASE_PROVIDE_FEEDBACK));
            }
            PetitionManager.this.getCompletedPetitions().put(this.getId(), this);
            return PetitionManager.this.getPendingPetitions().remove(this.getId()) != null;
        }

        public String getContent() {
            return this._content;
        }

        public int getId() {
            return this._id;
        }

        public L2PcInstance getPetitioner() {
            return this._petitioner;
        }

        public L2PcInstance getResponder() {
            return this._responder;
        }

        public long getEndTime() {
            return this._endTime;
        }

        public long getSubmitTime() {
            return this._submitTime;
        }

        public PetitionState getState() {
            return this._state;
        }

        public String getTypeAsString() {
            return this._type.toString().replace("_", " ");
        }

        public void sendPetitionerPacket(L2GameServerPacket responsePacket) {
            if (this.getPetitioner() == null || this.getPetitioner().isOnline() == 0) {
                return;
            }
            this.getPetitioner().sendPacket(responsePacket);
        }

        public void sendResponderPacket(L2GameServerPacket responsePacket) {
            if (this.getResponder() == null || this.getResponder().isOnline() == 0) {
                this.endPetitionConsultation(PetitionState.Responder_Missing);
                return;
            }
            this.getResponder().sendPacket(responsePacket);
        }

        public void setState(PetitionState state) {
            this._state = state;
        }

        public void setResponder(L2PcInstance respondingAdmin) {
            if (this.getResponder() != null) {
                return;
            }
            this._responder = respondingAdmin;
        }
    }

    private static enum PetitionType {
        Immobility,
        Recovery_Related,
        Bug_Report,
        Quest_Related,
        Bad_User,
        Suggestions,
        Game_Tip,
        Operation_Related,
        Other;

    }

    private static enum PetitionState {
        Pending,
        Responder_Cancel,
        Responder_Missing,
        Responder_Reject,
        Responder_Complete,
        Petitioner_Cancel,
        Petitioner_Missing,
        In_Process,
        Completed;

    }
}

