/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager.lastimperialtomb;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.instancemanager.grandbosses.BossLair;
import com.l2jserver.gameserver.instancemanager.grandbosses.FrintezzaManager;
import com.l2jserver.gameserver.instancemanager.lastimperialtomb.LastImperialTombSpawnlist;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.ExShowScreenMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Rnd;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import javolution.util.FastList;

public final class LastImperialTombManager
extends BossLair {
    private static boolean _isInvaded = false;
    protected static List<L2Npc> _hallAlarmDevices = new FastList();
    protected static List<L2Npc> _darkChoirPlayers = new FastList();
    protected static List<L2Npc> _darkChoirCaptains = new FastList();
    protected static List<L2Npc> _room1Monsters = new FastList();
    protected static List<L2Npc> _room2InsideMonsters = new FastList();
    protected static List<L2Npc> _room2OutsideMonsters = new FastList();
    protected static List<L2DoorInstance> _room1Doors = new FastList();
    protected static List<L2DoorInstance> _room2InsideDoors = new FastList();
    protected static List<L2DoorInstance> _room2OutsideDoors = new FastList();
    protected static L2DoorInstance _room3Door = null;
    protected static List<L2PcInstance> _partyLeaders = new FastList();
    protected static List<L2PcInstance> _registedPlayers = new FastList();
    protected static L2PcInstance _commander = null;
    private static final int SCROLL = 8073;
    public static final int SOUL_BREAKING_ARROW = 8192;
    public static final int DEWDROP_OF_DESTRUCTION = 8556;
    private boolean _isReachToHall = false;
    private final int[][] _invadeLoc = new int[][]{{173235, -76884, -5107}, {175003, -76933, -5107}, {174196, -76190, -5107}, {174013, -76120, -5107}, {173263, -75161, -5107}};
    protected ScheduledFuture<?> _InvadeTask = null;
    protected ScheduledFuture<?> _RegistrationTimeInfoTask = null;
    protected ScheduledFuture<?> _Room1SpawnTask = null;
    protected ScheduledFuture<?> _Room2InsideDoorOpenTask = null;
    protected ScheduledFuture<?> _Room2OutsideSpawnTask = null;
    protected ScheduledFuture<?> _CheckTimeUpTask = null;
    private L2Npc _npc32011;
    private final int[][] _escapeLocations = new int[][]{{146690, -56270, -2785, 147190, -55770}, {146190, -56470, -2785, 146690, -55970}, {148240, -55770, -2785, 148740, -56270}, {147100, -58560, -2965, 148300, -58060}};

    private LastImperialTombManager() {
    }

    public static LastImperialTombManager getInstance() {
        return SingletonHolder._instance;
    }

    @Override
    public void setUnspawn() {
    }

    @Override
    public void init() {
        if (this.registerZone(this._invadeLoc[0][0], this._invadeLoc[0][1], this._invadeLoc[0][2]) == null) {
            _log.warning("LastImperialTombManager : Failed to load zone 'Last Imperial Tomb'");
        }
        LastImperialTombSpawnlist.getInstance().clear();
        LastImperialTombSpawnlist.getInstance().fill();
        this.initDoors();
        _log.info("LastImperialTombManager: Init The Last Imperial Tomb.");
    }

    private void initDoors() {
        int i;
        _room1Doors.clear();
        _room1Doors.add(DoorTable.getInstance().getDoor(25150042));
        for (i = 25150051; i <= 25150058; ++i) {
            _room1Doors.add(DoorTable.getInstance().getDoor(i));
        }
        _room2InsideDoors.clear();
        for (i = 25150061; i <= 25150070; ++i) {
            _room2InsideDoors.add(DoorTable.getInstance().getDoor(i));
        }
        _room2OutsideDoors.clear();
        _room2OutsideDoors.add(DoorTable.getInstance().getDoor(25150043));
        _room2OutsideDoors.add(DoorTable.getInstance().getDoor(25150045));
        _room3Door = DoorTable.getInstance().getDoor(25150046);
        for (L2DoorInstance door : _room1Doors) {
            door.closeMe();
        }
        for (L2DoorInstance door : _room2InsideDoors) {
            door.closeMe();
        }
        for (L2DoorInstance door : _room2OutsideDoors) {
            door.closeMe();
        }
        _room3Door.closeMe();
    }

    public boolean isInvaded() {
        return _isInvaded;
    }

    private boolean tryRegistrationCc(L2PcInstance pc) {
        if (_commander == null && pc.getParty() != null && pc.getParty().getCommandChannel() != null && pc.getParty().getCommandChannel().getChannelLeader() == pc && pc.getParty().getCommandChannel().getPartys().size() >= Config.LIT_MIN_PARTY_CNT && pc.getParty().getCommandChannel().getPartys().size() <= Config.LIT_MAX_PARTY_CNT && pc.getInventory().getInventoryItemCount(8073, -1) >= 1L) {
            return true;
        }
        pc.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc\u3092\u7387\u3044\u308b\u9023\u5408\u30c1\u30e3\u30f3\u30cd\u30eb\u306e\u30ea\u30fc\u30c0\u30fc\u304c\u300c\u30d5\u30ea\u30f3\u30c6\u30c3\u30b5\u306e\u7d50\u754c\u89e3\u9664\u30b9\u30af\u30ed\u30fc\u30eb\u300d\u3092\u6301\u3063\u3066\u3044\u308c\u3070\u3001\u30d5\u30ea\u30f3\u30c6\u30c3\u30b5\u69d8\u306e\u7d50\u754c\u5185\u90e8\u306b\u5165\u308c\u307e\u3059\u3002");
        return false;
    }

    private boolean tryRegistrationPt(L2PcInstance pc) {
        if (_partyLeaders.size() < Config.LIT_MAX_PARTY_CNT && pc.getParty() != null && pc.getParty().getLeader() == pc && pc.getInventory().getInventoryItemCount(8073, -1) >= 1L) {
            return true;
        }
        pc.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc\u3092\u7387\u3044\u308b\u30ea\u30fc\u30c0\u30fc\u304c\u300c\u30d5\u30ea\u30f3\u30c6\u30c3\u30b5\u306e\u7d50\u754c\u89e3\u9664\u30b9\u30af\u30ed\u30fc\u30eb\u300d\u3092\u6301\u3063\u3066\u3044\u308c\u3070\u3001\u30d5\u30ea\u30f3\u30c6\u30c3\u30b5\u69d8\u306e\u7d50\u754c\u5185\u90e8\u306b\u5165\u308c\u307e\u3059\u3002");
        return false;
    }

    private boolean tryRegistrationPc(L2PcInstance pc) {
        if (_registedPlayers.contains(pc)) {
            pc.sendMessage("\u767b\u9332\u6e08\u3067\u3059\u3002");
            return false;
        }
        if (_registedPlayers.size() < Config.LIT_MAX_PLAYER_CNT && pc.getInventory().getInventoryItemCount(8073, -1) >= 1L) {
            return true;
        }
        pc.sendMessage("\u300c\u30d5\u30ea\u30f3\u30c6\u30c3\u30b5\u306e\u7d50\u754c\u89e3\u9664\u30b9\u30af\u30ed\u30fc\u30eb\u300d\u3092\u6301\u3063\u3066\u3044\u308c\u3070\u3001\u30d5\u30ea\u30f3\u30c6\u30c3\u30b5\u69d8\u306e\u7d50\u754c\u5185\u90e8\u306b\u5165\u308c\u307e\u3059\u3002");
        return false;
    }

    private boolean isTooFarTeleporter(L2PcInstance pc) {
        MapRegionTable m = MapRegionTable.getInstance();
        if (m.getMapRegionX(this._npc32011.getX()) != m.getMapRegionX(pc.getX()) || m.getMapRegionY(this._npc32011.getY()) != m.getMapRegionY(pc.getY())) {
            return true;
        }
        for (L2ZoneType z : ZoneManager.getInstance().getZones(pc)) {
            if (z.isInsideZone(this._npc32011)) continue;
            return true;
        }
        return false;
    }

    public synchronized String registration(int event, L2Npc npc, L2PcInstance pc) {
        this._npc32011 = npc;
        String html = null;
        if (this.isInvaded()) {
            npc.broadcastPacket(new CreatureSay(npc.getObjectId(), 0, npc.getName(), "\u4ed6\u306e\u30b0\u30eb\u30fc\u30d7\u304c\u4f7f\u7528\u4e2d\u3067\u3059\u3002"));
            return html;
        }
        if (!FrintezzaManager.getInstance().isEnableEnterToLair()) {
            npc.broadcastPacket(new CreatureSay(npc.getObjectId(), 0, npc.getName(), "\u73fe\u5728\u3001\u5165\u5834\u3092\u53d7\u3051\u4ed8\u3051\u3066\u304a\u308a\u307e\u305b\u3093\u3002"));
            return html;
        }
        if (_commander == null && _partyLeaders.size() == 0 && _registedPlayers.size() == 0) {
            if (event == -1) {
                return "<html><body>\u30d5\u30ea\u30f3\u30c6\u30c3\u30b5 \u30c6\u30ec\u30dd\u30fc\u30bf\u30fc:<br>1\u4eba\u3067\u7d50\u754c\u306b\u5165\u308b\u306e\u306f\u3068\u3066\u3082\u5371\u967a\u3067\u3059\u3002<br><a action=\"bypass -h Quest lastimperialtomb 0\">\u9023\u5408\u30c1\u30e3\u30f3\u30cd\u30eb\u3067\u5165\u308b</a><br><a action=\"bypass -h Quest lastimperialtomb 1\">\u30d1\u30fc\u30c6\u30a3\u30fc\u3067\u5165\u308b</a><br><a action=\"bypass -h Quest lastimperialtomb 2\">\u30d5\u30ea\u30fc\u3067\u5165\u308b</a></body></html>";
            }
            Config.LIT_REGISTRATION_MODE = event;
        } else if (event != -1) {
            return html;
        }
        switch (Config.LIT_REGISTRATION_MODE) {
            case 0: {
                if (!this.tryRegistrationCc(pc)) {
                    return html;
                }
                _commander = pc;
                if (this._InvadeTask != null) {
                    this._InvadeTask.cancel(true);
                }
                this._InvadeTask = ThreadPoolManager.getInstance().scheduleGeneral(new Invade(), 10000L);
                npc.broadcastPacket(new CreatureSay(npc.getObjectId(), 0, npc.getName(), "\u9023\u5408\u30c1\u30e3\u30f3\u30cd\u30eb\u3092\u767b\u9332\u3057\u307e\u3057\u305f\u3002"));
                break;
            }
            case 1: {
                if (!this.tryRegistrationPt(pc)) {
                    return html;
                }
                _partyLeaders.add(pc);
                if (_partyLeaders.size() == 1) {
                    this._RegistrationTimeInfoTask = ThreadPoolManager.getInstance().scheduleGeneral(new AnnouncementRegstrationInfo(npc, Config.LIT_REGISTRATION_TIME), 1000L);
                }
                npc.broadcastPacket(new CreatureSay(npc.getObjectId(), 3, npc.getName(), "\u30d1\u30fc\u30c6\u30a3\u30fc\u3092\u767b\u9332\u3057\u307e\u3057\u305f\u3002"));
                break;
            }
            case 2: {
                if (!this.tryRegistrationPc(pc)) {
                    return html;
                }
                _registedPlayers.add(pc);
                if (_registedPlayers.size() == 1) {
                    this._RegistrationTimeInfoTask = ThreadPoolManager.getInstance().scheduleGeneral(new AnnouncementRegstrationInfo(npc, Config.LIT_REGISTRATION_TIME), 1000L);
                }
                pc.sendMessage("\u30d5\u30ea\u30fc\u3067\u767b\u9332\u3057\u307e\u3057\u305f\u3002");
                break;
            }
            default: {
                _log.warning("LastImperialTombManager: Invalid Registration Mode!");
                return html;
            }
        }
        return html;
    }

    protected void doAnnouncementRegstrationInfo(L2Npc npc, int remaining) {
        CreatureSay cs = null;
        if (remaining == Config.LIT_REGISTRATION_TIME) {
            cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u30d5\u30ea\u30f3\u30c6\u30c3\u30b5\u69d8\u306e\u7d50\u754c\u3078\u306e\u5165\u5834\u53d7\u4ed8\u3092\u958b\u59cb\u3057\u307e\u3059\u3002");
            npc.broadcastPacket(cs);
        }
        if (remaining > 60000) {
            cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u30d5\u30ea\u30f3\u30c6\u30c3\u30b5\u69d8\u306e\u7d50\u754c\u5165\u5834\u53d7\u4ed8\u7d42\u4e86\u307e\u3067\u3001\u3042\u3068 " + remaining / 60000 + "\u5206\u3067\u3059\u3002");
            npc.broadcastPacket(cs);
            remaining -= 60000;
            switch (Config.LIT_REGISTRATION_MODE) {
                case 1: {
                    cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u6700\u4f4e\u5165\u5834\u30d1\u30fc\u30c6\u30a3\u6570\u306f " + Config.LIT_MIN_PARTY_CNT);
                    npc.broadcastPacket(cs);
                    cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u6700\u5927\u5165\u5834\u30d1\u30fc\u30c6\u30a3\u6570\u306f " + Config.LIT_MAX_PARTY_CNT);
                    npc.broadcastPacket(cs);
                    cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u73fe\u5728 " + _partyLeaders.size() + " \u7d44\u306e\u30d1\u30fc\u30c6\u30a3\u304c\u767b\u9332\u6e08\u307f\u3067\u3059\u3002");
                    npc.broadcastPacket(cs);
                    break;
                }
                case 2: {
                    cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u6700\u4f4e\u5165\u5834\u8005\u6570\u306f " + Config.LIT_MIN_PLAYER_CNT);
                    npc.broadcastPacket(cs);
                    cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u6700\u5927\u5165\u5834\u8005\u6570\u306f " + Config.LIT_MAX_PLAYER_CNT);
                    npc.broadcastPacket(cs);
                    cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u73fe\u5728 " + _registedPlayers.size() + " \u540d\u304c\u767b\u9332\u6e08\u307f\u3067\u3059\u3002");
                    npc.broadcastPacket(cs);
                }
            }
            if (this._RegistrationTimeInfoTask != null) {
                this._RegistrationTimeInfoTask.cancel(true);
            }
            this._RegistrationTimeInfoTask = ThreadPoolManager.getInstance().scheduleGeneral(new AnnouncementRegstrationInfo(npc, remaining), 60000L);
        } else if (remaining >= 10000) {
            cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u30d5\u30ea\u30f3\u30c6\u30c3\u30b5\u69d8\u306e\u7d50\u754c\u5165\u5834\u53d7\u4ed8\u7d42\u4e86\u307e\u3067\u3001\u3042\u3068 " + remaining / 1000 + "\u79d2\u3067\u3059\u3002");
            npc.broadcastPacket(cs);
            remaining -= 10000;
            switch (Config.LIT_REGISTRATION_MODE) {
                case 1: {
                    cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u6700\u4f4e\u5165\u5834\u30d1\u30fc\u30c6\u30a3\u6570\u306f " + Config.LIT_MIN_PARTY_CNT);
                    npc.broadcastPacket(cs);
                    cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u6700\u5927\u5165\u5834\u30d1\u30fc\u30c6\u30a3\u6570\u306f " + Config.LIT_MAX_PARTY_CNT);
                    npc.broadcastPacket(cs);
                    cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u73fe\u5728 " + _partyLeaders.size() + " \u7d44\u306e\u30d1\u30fc\u30c6\u30a3\u304c\u767b\u9332\u6e08\u307f\u3067\u3059\u3002");
                    npc.broadcastPacket(cs);
                    break;
                }
                case 2: {
                    cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u73fe\u5728 " + _registedPlayers.size() + " \u540d\u304c\u767b\u9332\u6e08\u307f\u3067\u3059\u3002");
                    npc.broadcastPacket(cs);
                    cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u6700\u5927\u5165\u5834\u8005\u6570\u306f " + Config.LIT_MAX_PLAYER_CNT);
                    npc.broadcastPacket(cs);
                    cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u6700\u4f4e\u5165\u5834\u8005\u6570\u306f " + Config.LIT_MIN_PLAYER_CNT);
                    npc.broadcastPacket(cs);
                }
            }
            if (this._RegistrationTimeInfoTask != null) {
                this._RegistrationTimeInfoTask.cancel(true);
            }
            this._RegistrationTimeInfoTask = ThreadPoolManager.getInstance().scheduleGeneral(new AnnouncementRegstrationInfo(npc, remaining), 10000L);
        } else {
            cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u30d5\u30ea\u30f3\u30c6\u30c3\u30b5\u69d8\u306e\u7d50\u754c\u3078\u306e\u5165\u5834\u53d7\u4ed8\u3092\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
            npc.broadcastPacket(cs);
            switch (Config.LIT_REGISTRATION_MODE) {
                case 1: {
                    if (_partyLeaders.size() >= Config.LIT_MIN_PARTY_CNT && _partyLeaders.size() <= Config.LIT_MAX_PARTY_CNT) break;
                    cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u5165\u5834\u7d44\u6570\u306e\u6761\u4ef6\u3092\u6e80\u305f\u305b\u306a\u304b\u3063\u305f\u305f\u3081\u3001\u5165\u5834\u304c\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f\u3002");
                    npc.broadcastPacket(cs);
                    this.cleanUpTomb();
                    return;
                }
                case 2: {
                    if (_registedPlayers.size() >= Config.LIT_MIN_PLAYER_CNT && _registedPlayers.size() <= Config.LIT_MAX_PLAYER_CNT) break;
                    cs = new CreatureSay(npc.getObjectId(), 1, npc.getName(), "\u5165\u5834\u8005\u6570\u306e\u6761\u4ef6\u3092\u6e80\u305f\u305b\u306a\u304b\u3063\u305f\u305f\u3081\u3001\u5165\u5834\u304c\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f\u3002");
                    npc.broadcastPacket(cs);
                    this.cleanUpTomb();
                    return;
                }
            }
            if (this._RegistrationTimeInfoTask != null) {
                this._RegistrationTimeInfoTask.cancel(true);
            }
            this._RegistrationTimeInfoTask = null;
            if (this._InvadeTask != null) {
                this._InvadeTask.cancel(true);
            }
            this._InvadeTask = ThreadPoolManager.getInstance().scheduleGeneral(new Invade(), 10000L);
        }
    }

    public void doInvade() {
        this.initDoors();
        switch (Config.LIT_REGISTRATION_MODE) {
            case 0: {
                this.doInvadeCc();
                break;
            }
            case 1: {
                this.doInvadePt();
                break;
            }
            case 2: {
                this.doInvadePc();
                break;
            }
            default: {
                _log.warning("LastImperialTombManager: Invalid Registration Mode!");
                return;
            }
        }
        _commander = null;
        _partyLeaders.clear();
        _registedPlayers.clear();
        if (this.getZone().getAllowedPlayers().isEmpty()) {
            return;
        }
        if (Config.GEODATA == 0) {
            DoorTable.getInstance().getDoor(25150052).openMe();
            DoorTable.getInstance().getDoor(25150054).openMe();
            DoorTable.getInstance().getDoor(25150058).openMe();
        }
        _isInvaded = true;
        if (this._Room1SpawnTask != null) {
            this._Room1SpawnTask.cancel(true);
        }
        this._Room1SpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRoom1Mobs1st(), 15000L);
        if (this._CheckTimeUpTask != null) {
            this._CheckTimeUpTask.cancel(true);
        }
        this._CheckTimeUpTask = ThreadPoolManager.getInstance().scheduleGeneral(new CheckTimeUp(Config.LIT_TIME_LIMIT), 15000L);
    }

    private void destroyItem(L2PcInstance pc, int itemId) {
        L2ItemInstance i = pc.getInventory().getItemByItemId(itemId);
        if (i != null) {
            pc.destroyItemByItemId("Quest", itemId, i.getCount(), pc, true);
        }
    }

    private void doInvadeCc() {
        int locId = 0;
        if (_commander.getInventory().getInventoryItemCount(8073, -1) < 1L || this.isTooFarTeleporter(_commander)) {
            _commander.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS));
            _commander.sendMessage("\u6761\u4ef6\u3092\u6e80\u305f\u3057\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u5165\u5834\u304c\u62d2\u5426\u3055\u308c\u307e\u3057\u305f\u3002");
            return;
        }
        _commander.destroyItemByItemId("Quest", 8073, 1L, _commander, true);
        for (L2Party pt : _commander.getParty().getCommandChannel().getPartys()) {
            if (locId >= 5) {
                locId = 0;
            }
            for (L2PcInstance pc : pt.getPartyMembers()) {
                if (this.isTooFarTeleporter(pc)) continue;
                this.getZone().allowPlayerEntry(pc, 30);
                pc.teleToLocation(this._invadeLoc[locId][0] + Rnd.get(50), this._invadeLoc[locId][1] + Rnd.get(50), this._invadeLoc[locId][2]);
                this.destroyItem(pc, 8192);
                this.destroyItem(pc, 8556);
            }
            ++locId;
        }
    }

    private void doInvadePt() {
        int locId = 0;
        boolean isReadyToInvade = true;
        for (L2PcInstance ptl : _partyLeaders) {
            if (ptl.getInventory().getInventoryItemCount(8073, -1) >= 1L && !this.isTooFarTeleporter(ptl)) continue;
            ptl.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS));
            ptl.sendMessage("\u6761\u4ef6\u3092\u6e80\u305f\u3057\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u5165\u5834\u304c\u62d2\u5426\u3055\u308c\u307e\u3057\u305f\u3002");
            isReadyToInvade = false;
        }
        if (!isReadyToInvade) {
            for (L2PcInstance ptl : _partyLeaders) {
                ptl.sendMessage("\u6761\u4ef6\u3092\u6e80\u305f\u3057\u3066\u3044\u306a\u3044\u30d1\u30fc\u30c6\u30a3\u304c\u3042\u308b\u305f\u3081\u3001\u5165\u5834\u304c\u62d2\u5426\u3055\u308c\u307e\u3057\u305f\u3002");
            }
            return;
        }
        for (L2PcInstance ptl : _partyLeaders) {
            ptl.destroyItemByItemId("Quest", 8073, 1L, _commander, true);
            if (locId >= 5) {
                locId = 0;
            }
            for (L2PcInstance pc : ptl.getParty().getPartyMembers()) {
                if (this.isTooFarTeleporter(pc)) continue;
                this.getZone().allowPlayerEntry(pc, 30);
                pc.teleToLocation(this._invadeLoc[locId][0] + Rnd.get(50), this._invadeLoc[locId][1] + Rnd.get(50), this._invadeLoc[locId][2]);
                this.destroyItem(pc, 8192);
                this.destroyItem(pc, 8556);
            }
            ++locId;
        }
    }

    private void doInvadePc() {
        int locId = 0;
        boolean isReadyToInvade = true;
        for (L2PcInstance pc : _registedPlayers) {
            if (pc.getInventory().getInventoryItemCount(8073, -1) >= 1L) continue;
            SystemMessage sm = new SystemMessage(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS);
            pc.sendPacket(sm);
            pc.sendMessage("\u6761\u4ef6\u3092\u6e80\u305f\u3057\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u5165\u5834\u304c\u62d2\u5426\u3055\u308c\u307e\u3057\u305f\u3002");
            isReadyToInvade = false;
        }
        if (!isReadyToInvade) {
            for (L2PcInstance pc : _registedPlayers) {
                pc.sendMessage("\u6761\u4ef6\u3092\u6e80\u305f\u3057\u3066\u3044\u306a\u3044\u30d7\u30ec\u30a4\u30e4\u30fc\u304c\u3044\u308b\u305f\u3081\u3001\u5165\u5834\u304c\u62d2\u5426\u3055\u308c\u307e\u3057\u305f\u3002");
            }
            return;
        }
        for (L2PcInstance pc : _registedPlayers) {
            if (this.isTooFarTeleporter(pc)) continue;
            pc.destroyItemByItemId("Quest", 8073, 1L, _commander, true);
            if (locId >= 5) {
                locId = 0;
            }
            this.getZone().allowPlayerEntry(pc, 30);
            pc.teleToLocation(this._invadeLoc[locId][0] + Rnd.get(50), this._invadeLoc[locId][1] + Rnd.get(50), this._invadeLoc[locId][2]);
            this.destroyItem(pc, 8192);
            this.destroyItem(pc, 8556);
            ++locId;
        }
    }

    public void onKillHallAlarmDevice() {
        int killCnt = 0;
        for (L2Npc HallAlarmDevice : _hallAlarmDevices) {
            if (!HallAlarmDevice.isDead()) continue;
            ++killCnt;
        }
        switch (killCnt) {
            case 1: {
                if (Rnd.get(100) < 10) {
                    this.openRoom1Doors();
                    this.openRoom2OutsideDoors();
                    this.spawnRoom2InsideMob();
                    break;
                }
                if (this._Room1SpawnTask != null) {
                    this._Room1SpawnTask.cancel(true);
                }
                this._Room1SpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRoom1Mobs2nd(), 3000L);
                break;
            }
            case 2: {
                if (Rnd.get(100) < 20) {
                    this.openRoom1Doors();
                    this.openRoom2OutsideDoors();
                    this.spawnRoom2InsideMob();
                    break;
                }
                if (this._Room1SpawnTask != null) {
                    this._Room1SpawnTask.cancel(true);
                }
                this._Room1SpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRoom1Mobs3rd(), 3000L);
                break;
            }
            case 3: {
                if (Rnd.get(100) < 30) {
                    this.openRoom1Doors();
                    this.openRoom2OutsideDoors();
                    this.spawnRoom2InsideMob();
                    break;
                }
                if (this._Room1SpawnTask != null) {
                    this._Room1SpawnTask.cancel(true);
                }
                this._Room1SpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRoom1Mobs4th(), 3000L);
                break;
            }
            case 4: {
                this.openRoom1Doors();
                this.openRoom2OutsideDoors();
                this.spawnRoom2InsideMob();
            }
        }
    }

    public void onKillDarkChoirPlayer() {
        int killCnt = 0;
        for (L2Npc DarkChoirPlayer : _room2InsideMonsters) {
            if (!DarkChoirPlayer.isDead()) continue;
            ++killCnt;
        }
        if (_room2InsideMonsters.size() <= killCnt) {
            if (this._Room2InsideDoorOpenTask != null) {
                this._Room2InsideDoorOpenTask.cancel(true);
            }
            if (this._Room2OutsideSpawnTask != null) {
                this._Room2OutsideSpawnTask.cancel(true);
            }
            this._Room2InsideDoorOpenTask = ThreadPoolManager.getInstance().scheduleGeneral(new OpenRoom2InsideDoors(), 3000L);
            this._Room2OutsideSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRoom2OutsideMobs(), 4000L);
        }
    }

    public void onKillDarkChoirCaptain() {
        L2Npc alive = null;
        for (L2Npc DarkChoirCaptain : _darkChoirCaptains) {
            if (DarkChoirCaptain.isDead()) continue;
            alive = DarkChoirCaptain;
            break;
        }
        if (alive == null) {
            this.openRoom2OutsideDoors();
            for (L2Npc mob : _room2OutsideMonsters) {
                mob.deleteMe();
                mob.getSpawn().stopRespawn();
            }
            for (L2Npc DarkChoirCaptain : _darkChoirCaptains) {
                DarkChoirCaptain.deleteMe();
                DarkChoirCaptain.getSpawn().stopRespawn();
            }
        } else {
            alive.broadcastPacket(new CreatureSay(0, 1, "\u9ed2\u8056\u6b4c\u56e3\u9577", "\u9ed2\u8056\u6b4c\u56e3\u306e\u6f14\u594f\u3092\u59a8\u3052\u308b\u90aa\u9b54\u8005\u3092\u6d88\u305b\uff01"));
        }
    }

    private void openRoom1Doors() {
        for (L2Npc npc : _hallAlarmDevices) {
            npc.deleteMe();
            npc.getSpawn().stopRespawn();
        }
        for (L2Npc npc : _room1Monsters) {
            npc.deleteMe();
            npc.getSpawn().stopRespawn();
        }
        for (L2DoorInstance door : _room1Doors) {
            door.openMe();
        }
    }

    protected void openRoom2InsideDoors() {
        for (L2DoorInstance door : _room2InsideDoors) {
            door.openMe();
        }
    }

    protected void openRoom2OutsideDoors() {
        for (L2DoorInstance door : _room2OutsideDoors) {
            door.openMe();
        }
        _room3Door.openMe();
    }

    protected void closeRoom2OutsideDoors() {
        for (L2DoorInstance door : _room2OutsideDoors) {
            door.closeMe();
        }
        _room3Door.closeMe();
    }

    private void spawnRoom2InsideMob() {
        for (L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom2InsideSpawnList()) {
            L2Npc mob = spawn.doSpawn();
            mob.getSpawn().stopRespawn();
            _room2InsideMonsters.add(mob);
        }
    }

    public void setReachToHall() {
        this._isReachToHall = true;
        if (this._CheckTimeUpTask != null) {
            this._CheckTimeUpTask.cancel(false);
        }
        this._CheckTimeUpTask = null;
    }

    protected void doCheckTimeUp(int remaining) {
        int interval;
        int timeLeft;
        if (this._isReachToHall) {
            return;
        }
        ExShowScreenMessage cs = null;
        if (remaining > 300000) {
            timeLeft = remaining / 60000;
            interval = 300000;
            cs = new ExShowScreenMessage("\u6b8b\u308a" + timeLeft + "\u5206\u3067\u3059\u3002", 7000);
            remaining -= interval;
        } else if (remaining > 60000) {
            timeLeft = remaining / 60000;
            interval = 60000;
            cs = new ExShowScreenMessage("\u6b8b\u308a" + timeLeft + "\u5206\u3067\u3059\u3002", 7000);
            remaining -= interval;
        } else if (remaining > 30000) {
            timeLeft = remaining / 1000;
            interval = 30000;
            cs = new ExShowScreenMessage("\u6b8b\u308a" + timeLeft + "\u79d2\u3067\u3059\u3002", 7000);
            remaining -= interval;
        } else {
            timeLeft = remaining / 1000;
            interval = 10000;
            cs = new ExShowScreenMessage("\u6b8b\u308a" + timeLeft + "\u79d2\u3067\u3059\u3002", 7000);
            remaining -= interval;
        }
        for (L2PcInstance pc : this.getPlayersInside()) {
            pc.sendPacket(cs);
        }
        if (this._CheckTimeUpTask != null) {
            this._CheckTimeUpTask.cancel(true);
        }
        this._CheckTimeUpTask = remaining >= 10000 ? ThreadPoolManager.getInstance().scheduleGeneral(new CheckTimeUp(remaining), interval) : ThreadPoolManager.getInstance().scheduleGeneral(new TimeUp(), interval);
    }

    public void cleanUpTomb() {
        this.initDoors();
        this.cleanUpMobs();
        this.banishForeigners();
        this.cleanUpRegister();
        _isInvaded = false;
        this._isReachToHall = false;
        if (this._InvadeTask != null) {
            this._InvadeTask.cancel(true);
        }
        this._InvadeTask = null;
        if (this._RegistrationTimeInfoTask != null) {
            this._RegistrationTimeInfoTask.cancel(true);
        }
        this._RegistrationTimeInfoTask = null;
        if (this._Room1SpawnTask != null) {
            this._Room1SpawnTask.cancel(true);
        }
        this._Room1SpawnTask = null;
        if (this._Room2InsideDoorOpenTask != null) {
            this._Room2InsideDoorOpenTask.cancel(true);
        }
        this._Room2InsideDoorOpenTask = null;
        if (this._Room2OutsideSpawnTask != null) {
            this._Room2OutsideSpawnTask.cancel(true);
        }
        this._Room2OutsideSpawnTask = null;
        if (this._CheckTimeUpTask != null) {
            this._CheckTimeUpTask.cancel(true);
        }
        this._CheckTimeUpTask = null;
    }

    public void cleanUpMobs() {
        for (L2Npc mob : _hallAlarmDevices) {
            mob.getSpawn().stopRespawn();
            mob.deleteMe();
        }
        _hallAlarmDevices.clear();
        for (L2Npc mob : _darkChoirPlayers) {
            mob.getSpawn().stopRespawn();
            mob.deleteMe();
        }
        _darkChoirPlayers.clear();
        for (L2Npc mob : _darkChoirCaptains) {
            mob.getSpawn().stopRespawn();
            mob.deleteMe();
        }
        _darkChoirCaptains.clear();
        for (L2Npc mob : _room1Monsters) {
            mob.getSpawn().stopRespawn();
            mob.deleteMe();
        }
        _room1Monsters.clear();
        for (L2Npc mob : _room2InsideMonsters) {
            mob.getSpawn().stopRespawn();
            mob.deleteMe();
        }
        _room2InsideMonsters.clear();
        for (L2Npc mob : _room2OutsideMonsters) {
            mob.getSpawn().stopRespawn();
            mob.deleteMe();
        }
        _room2OutsideMonsters.clear();
    }

    private void cleanUpRegister() {
        _commander = null;
        _partyLeaders.clear();
        _registedPlayers.clear();
    }

    @Override
    public void checkAnnihilated() {
        if (this.isPlayersAnnihilated()) {
            ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

                @Override
                public void run() {
                    FrintezzaManager.getInstance().setUnspawn();
                    LastImperialTombManager.this.cleanUpTomb();
                }
            }, 10000L);
        }
    }

    public void escapeForeigner(L2PcInstance pc) {
        int[] loc = this._escapeLocations[Rnd.get(this._escapeLocations.length)];
        int x = Rnd.get(loc[0], loc[3]);
        int y = Rnd.get(loc[1], loc[4]);
        int z = loc[2];
        pc.teleToLocation(x, y, z);
    }

    @Override
    public void banishForeigners() {
        for (L2PcInstance pc : this.getPlayersInside()) {
            this.escapeForeigner(pc);
        }
        super.banishForeigners();
    }

    private static class SingletonHolder {
        protected static final LastImperialTombManager _instance = new LastImperialTombManager();

        private SingletonHolder() {
        }
    }

    class TimeUp
    implements Runnable {
        TimeUp() {
        }

        @Override
        public void run() {
            LastImperialTombManager.this.cleanUpTomb();
        }
    }

    private class CheckTimeUp
    implements Runnable {
        private final int _remaining;

        public CheckTimeUp(int remaining) {
            this._remaining = remaining;
        }

        @Override
        public void run() {
            LastImperialTombManager.this.doCheckTimeUp(this._remaining);
        }
    }

    class Invade
    implements Runnable {
        Invade() {
        }

        @Override
        public void run() {
            LastImperialTombManager.this.doInvade();
        }
    }

    private class AnnouncementRegstrationInfo
    implements Runnable {
        private final L2Npc _npc;
        private final int _remaining;

        public AnnouncementRegstrationInfo(L2Npc npc, int remaining) {
            this._npc = npc;
            this._remaining = remaining;
        }

        @Override
        public void run() {
            LastImperialTombManager.this.doAnnouncementRegstrationInfo(this._npc, this._remaining);
        }
    }

    class SpawnRoom2OutsideMobs
    implements Runnable {
        SpawnRoom2OutsideMobs() {
        }

        @Override
        public void run() {
            for (L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom2OutsideSpawnList()) {
                L2Npc mob;
                if (spawn.getNpcid() == 18334) {
                    mob = spawn.doSpawn();
                    mob.getSpawn().stopRespawn();
                    _darkChoirCaptains.add(mob);
                    continue;
                }
                mob = spawn.doSpawn();
                mob.getSpawn().startRespawn();
                _room2OutsideMonsters.add(mob);
            }
            _darkChoirCaptains.get(0).broadcastPacket(new CreatureSay(0, 1, "\u9ed2\u8056\u6b4c\u56e3\u9577", "\u9ed2\u8056\u6b4c\u56e3\u306e\u30b9\u30c6\u30fc\u30b8\u3092\u3076\u3061\u58ca\u3059\u3068\u306f\uff0e\uff0e\uff0e\u8a31\u305b\u306c\uff01"));
        }
    }

    class OpenRoom2InsideDoors
    implements Runnable {
        OpenRoom2InsideDoors() {
        }

        @Override
        public void run() {
            LastImperialTombManager.this.closeRoom2OutsideDoors();
            LastImperialTombManager.this.openRoom2InsideDoors();
        }
    }

    class SpawnRoom1Mobs4th
    implements Runnable {
        SpawnRoom1Mobs4th() {
        }

        @Override
        public void run() {
            for (L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom1SpawnList4th()) {
                L2Npc mob = spawn.doSpawn();
                mob.getSpawn().stopRespawn();
                _room1Monsters.add(mob);
            }
        }
    }

    class SpawnRoom1Mobs3rd
    implements Runnable {
        SpawnRoom1Mobs3rd() {
        }

        @Override
        public void run() {
            for (L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom1SpawnList3rd()) {
                L2Npc mob = spawn.doSpawn();
                mob.getSpawn().stopRespawn();
                _room1Monsters.add(mob);
            }
        }
    }

    class SpawnRoom1Mobs2nd
    implements Runnable {
        SpawnRoom1Mobs2nd() {
        }

        @Override
        public void run() {
            for (L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom1SpawnList2nd()) {
                L2Npc mob = spawn.doSpawn();
                mob.getSpawn().stopRespawn();
                _room1Monsters.add(mob);
            }
        }
    }

    class SpawnRoom1Mobs1st
    implements Runnable {
        SpawnRoom1Mobs1st() {
        }

        @Override
        public void run() {
            for (L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom1SpawnList1st()) {
                L2Npc mob;
                if (spawn.getNpcid() == 18328) {
                    mob = spawn.doSpawn();
                    mob.getSpawn().stopRespawn();
                    _hallAlarmDevices.add(mob);
                    continue;
                }
                mob = spawn.doSpawn();
                mob.getSpawn().stopRespawn();
                _room1Monsters.add(mob);
            }
        }
    }
}

