/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.Config;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.HelperBuffTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.TownManager;
import com.l2jserver.gameserver.instancemanager.games.Lottery;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2DropCategory;
import com.l2jserver.gameserver.model.L2DropData;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Multisell;
import com.l2jserver.gameserver.model.L2NpcAIData;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.MobGroupTable;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2ClanHallManagerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ControllableMobInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoormenInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FestivalGuideInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FishermanInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TeleporterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TrainerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2WarehouseInstance;
import com.l2jserver.gameserver.model.actor.knownlist.NpcKnownList;
import com.l2jserver.gameserver.model.actor.stat.NpcStat;
import com.l2jserver.gameserver.model.actor.status.NpcStatus;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.L2Event;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.quest.State;
import com.l2jserver.gameserver.model.zone.type.L2TownZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.EtcStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ExShowBaseAttributeCancelWindow;
import com.l2jserver.gameserver.network.serverpackets.ExShowVariationCancelWindow;
import com.l2jserver.gameserver.network.serverpackets.ExShowVariationMakeWindow;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.RadarControl;
import com.l2jserver.gameserver.network.serverpackets.ServerObjectInfo;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import com.l2jserver.gameserver.templates.L2HelperBuff;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.gameserver.util.StringUtil;
import com.l2jserver.util.Rnd;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javolution.util.FastList;

public class L2Npc
extends L2Character {
    public static final int INTERACTION_DISTANCE = 150;
    private L2Spawn _spawn;
    private boolean _isBusy = false;
    private String _busyMessage = "";
    volatile boolean _isDecayed = false;
    private int _castleIndex = -2;
    private int _fortIndex = -2;
    public boolean isEventMob = false;
    private boolean _isInTown = false;
    private long _lastSocialBroadcast = 0L;
    private int _minimalSocialInterval = 6000;
    protected RandomAnimationTask _rAniTask = null;
    private int _currentLHandId;
    private int _currentRHandId;
    private int _currentEnchant;
    private double _currentCollisionHeight;
    private double _currentCollisionRadius;
    public boolean _soulshotcharged = false;
    public boolean _spiritshotcharged = false;
    private int _soulshotamount = 0;
    private int _spiritshotamount = 0;
    public boolean _ssrecharged = true;
    public boolean _spsrecharged = true;
    int _aggroMask = -1;

    public int getSoulShot() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getSoulShot();
    }

    public int getSpiritShot() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getSpiritShot();
    }

    public int getSoulShotChance() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getSoulShotChance();
    }

    public int getSpiritShotChance() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getSpiritShotChance();
    }

    public boolean useSoulShot() {
        if (this._soulshotcharged) {
            return true;
        }
        if (this._ssrecharged) {
            this._soulshotamount = this.getSoulShot();
            this._ssrecharged = false;
        } else if (this._soulshotamount > 0) {
            if (Rnd.get(100) <= this.getSoulShotChance()) {
                --this._soulshotamount;
                Broadcast.toSelfAndKnownPlayersInRadius(this, new MagicSkillUse(this, this, 2154, 1, 0, 0), 360000L);
                this._soulshotcharged = true;
            }
        } else {
            return false;
        }
        return this._soulshotcharged;
    }

    public boolean useSpiritShot() {
        if (this._spiritshotcharged) {
            return true;
        }
        if (this._spsrecharged) {
            this._spiritshotamount = this.getSpiritShot();
            this._spsrecharged = false;
        } else if (this._spiritshotamount > 0) {
            if (Rnd.get(100) <= this.getSpiritShotChance()) {
                --this._spiritshotamount;
                Broadcast.toSelfAndKnownPlayersInRadius(this, new MagicSkillUse(this, this, 2061, 1, 0, 0), 360000L);
                this._spiritshotcharged = true;
            }
        } else {
            return false;
        }
        return this._spiritshotcharged;
    }

    public int getEnemyRange() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getEnemyRange();
    }

    public String getEnemyClan() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getEnemyClan();
    }

    public int getClanRange() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getClanRange();
    }

    public String getClan() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getClan();
    }

    public int getPrimaryAttack() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getPrimaryAttack();
    }

    public int getSkillChance() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getSkillChance();
    }

    public int getCanMove() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getCanMove();
    }

    public int getIsChaos() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getIsChaos();
    }

    public int getCanDodge() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getDodge();
    }

    public int getSSkillChance() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getShortRangeChance();
    }

    public int getLSkillChance() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getLongRangeChance();
    }

    public int getSwitchRangeChance() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getSwitchRangeChance();
    }

    public boolean hasLSkill() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getLongRangeSkill() != 0;
    }

    public boolean hasSSkill() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getShortRangeSkill() != 0;
    }

    public FastList<L2Skill> getLrangeSkill() {
        FastList skilldata = new FastList();
        boolean hasLrange = false;
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        if (AI == null || AI.getLongRangeSkill() == 0) {
            return null;
        }
        switch (AI.getLongRangeSkill()) {
            case -1: {
                L2Skill[] skills = null;
                skills = this.getAllSkills();
                if (skills == null) break;
                for (L2Skill sk : skills) {
                    if (sk == null || sk.isPassive() || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_SELF || sk.getCastRange() < 200) continue;
                    skilldata.add((Object)sk);
                    hasLrange = true;
                }
                break;
            }
            case 1: {
                if (this.getTemplate()._universalskills == null) break;
                for (L2Skill sk : this.getTemplate()._universalskills) {
                    if (sk.getCastRange() < 200) continue;
                    skilldata.add((Object)sk);
                    hasLrange = true;
                }
                break;
            }
            default: {
                for (L2Skill sk : this.getAllSkills()) {
                    if (sk.getId() != AI.getLongRangeSkill()) continue;
                    skilldata.add((Object)sk);
                    hasLrange = true;
                }
            }
        }
        return hasLrange ? skilldata : null;
    }

    public FastList<L2Skill> getSrangeSkill() {
        FastList skilldata = new FastList();
        boolean hasSrange = false;
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        if (AI == null || AI.getShortRangeSkill() == 0) {
            return null;
        }
        switch (AI.getShortRangeSkill()) {
            case -1: {
                L2Skill[] skills = null;
                skills = this.getAllSkills();
                if (skills == null) break;
                for (L2Skill sk : skills) {
                    if (sk == null || sk.isPassive() || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_SELF || sk.getCastRange() > 200) continue;
                    skilldata.add((Object)sk);
                    hasSrange = true;
                }
                break;
            }
            case 1: {
                if (this.getTemplate()._universalskills == null) break;
                for (L2Skill sk : this.getTemplate()._universalskills) {
                    if (sk.getCastRange() > 200) continue;
                    skilldata.add((Object)sk);
                    hasSrange = true;
                }
                break;
            }
            default: {
                for (L2Skill sk : this.getAllSkills()) {
                    if (sk.getId() != AI.getShortRangeSkill()) continue;
                    skilldata.add((Object)sk);
                    hasSrange = true;
                }
            }
        }
        return hasSrange ? skilldata : null;
    }

    public void onRandomAnimation() {
        long now = System.currentTimeMillis();
        if (now - this._lastSocialBroadcast > (long)this._minimalSocialInterval) {
            this._lastSocialBroadcast = now;
            this.broadcastPacket(new SocialAction(this.getObjectId(), Rnd.get(2, 3)));
        }
    }

    public void startRandomAnimationTimer() {
        if (!this.hasRandomAnimation()) {
            return;
        }
        int minWait = this.isMob() ? Config.MIN_MONSTER_ANIMATION : Config.MIN_NPC_ANIMATION;
        int maxWait = this.isMob() ? Config.MAX_MONSTER_ANIMATION : Config.MAX_NPC_ANIMATION;
        int interval = Rnd.get(minWait, maxWait) * 1000;
        this._rAniTask = new RandomAnimationTask();
        ThreadPoolManager.getInstance().scheduleGeneral(this._rAniTask, interval);
    }

    public boolean hasRandomAnimation() {
        return Config.MAX_NPC_ANIMATION > 0 && !this.getAiType().equals((Object)L2NpcTemplate.AIType.CORPSE);
    }

    public L2Npc(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.initCharStatusUpdateValues();
        this._currentLHandId = this.getTemplate().lhand;
        this._currentRHandId = this.getTemplate().rhand;
        this._currentEnchant = Config.ENABLE_RANDOM_ENCHANT_EFFECT ? Rnd.get(4, 21) : this.getTemplate().enchantEffect;
        this._currentCollisionHeight = this.getTemplate().fCollisionHeight;
        this._currentCollisionRadius = this.getTemplate().fCollisionRadius;
        if (template == null) {
            _log.severe("No template for Npc. Please check your datapack is setup correctly.");
            return;
        }
        this.setName(template.name);
    }

    @Override
    public NpcKnownList getKnownList() {
        return (NpcKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new NpcKnownList(this));
    }

    @Override
    public NpcStat getStat() {
        return (NpcStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new NpcStat(this));
    }

    @Override
    public NpcStatus getStatus() {
        return (NpcStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new NpcStatus(this));
    }

    @Override
    public final L2NpcTemplate getTemplate() {
        return (L2NpcTemplate)super.getTemplate();
    }

    public int getNpcId() {
        return this.getTemplate().npcId;
    }

    @Override
    public boolean isAttackable() {
        return Config.ALT_ATTACKABLE_NPCS;
    }

    public final String getFactionId() {
        return this.getClan();
    }

    @Override
    public final int getLevel() {
        return this.getTemplate().level;
    }

    public boolean isAggressive() {
        return false;
    }

    public int getAggroRange() {
        return this.getTemplate().aggroRange & this._aggroMask;
    }

    public void aggroDisable() {
        this._aggroMask = 0;
    }

    public void setAggroEnable() {
        this._aggroMask = -1;
    }

    public void setAggroEnable(long delay) {
        ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

            @Override
            public void run() {
                L2Npc.this._aggroMask = -1;
            }
        }, delay);
    }

    public int getFactionRange() {
        return this.getClanRange();
    }

    @Override
    public boolean isUndead() {
        return this.getTemplate().isUndead;
    }

    @Override
    public void updateAbnormalEffect() {
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (this.getRunSpeed() == 0) {
                player.sendPacket(new ServerObjectInfo(this, player));
                continue;
            }
            player.sendPacket(new AbstractNpcInfo.NpcInfo(this, player));
        }
    }

    public int getDistanceToWatchObject(L2Object object) {
        if (object instanceof L2FestivalGuideInstance) {
            return 10000;
        }
        if (object instanceof L2NpcInstance || !(object instanceof L2Character)) {
            return 0;
        }
        if (object instanceof L2Playable) {
            return 1500;
        }
        return 500;
    }

    public int getDistanceToForgetObject(L2Object object) {
        return 2 * this.getDistanceToWatchObject(object);
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    public int getLeftHandItem() {
        return this._currentLHandId;
    }

    public int getRightHandItem() {
        return this._currentRHandId;
    }

    public int getEnchantEffect() {
        return this._currentEnchant;
    }

    public final boolean isBusy() {
        return this._isBusy;
    }

    public void setBusy(boolean isBusy) {
        this._isBusy = isBusy;
    }

    public final String getBusyMessage() {
        return this._busyMessage;
    }

    public void setBusyMessage(String message) {
        this._busyMessage = message;
    }

    public boolean isWarehouse() {
        return false;
    }

    protected boolean canTarget(L2PcInstance player) {
        if (player.isOutOfControl()) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (player.isLockedTarget() && player.getLockedTarget() != this) {
            player.sendPacket(new SystemMessage(SystemMessageId.FAILED_CHANGE_TARGET));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        return true;
    }

    public boolean canInteract(L2PcInstance player) {
        if (player.isCastingNow() || player.isCastingSimultaneouslyNow()) {
            return false;
        }
        if (player.isDead() || player.isFakeDeath()) {
            return false;
        }
        if (player.isSitting()) {
            return false;
        }
        if (player.getPrivateStoreType() != 0) {
            return false;
        }
        if (!this.isInsideRadius(player, 150, true, false)) {
            return false;
        }
        return player.getInstanceId() == this.getInstanceId() || player.getInstanceId() == -1;
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (!this.canTarget(player)) {
            return;
        }
        player.setLastFolkNPC(this);
        if (this != player.getTarget()) {
            if (Config.DEBUG) {
                _log.fine("new target selected:" + this.getObjectId());
            }
            player.setTarget(this);
            if (this.isAutoAttackable(player)) {
                MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
                player.sendPacket(my);
                StatusUpdate su = new StatusUpdate(this.getObjectId());
                su.addAttribute(9, (int)this.getCurrentHp());
                su.addAttribute(10, this.getMaxHp());
                player.sendPacket(su);
            } else {
                MyTargetSelected my = new MyTargetSelected(this.getObjectId(), 0);
                player.sendPacket(my);
            }
            player.sendPacket(new ValidateLocation(this));
        } else if (interact) {
            player.sendPacket(new ValidateLocation(this));
            if (this.isAutoAttackable(player) && !this.isAlikeDead()) {
                if (Math.abs(player.getZ() - this.getZ()) < 400) {
                    player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
                } else {
                    player.sendPacket(ActionFailed.STATIC_PACKET);
                }
            } else if (!this.isAutoAttackable(player)) {
                if (!this.canInteract(player)) {
                    player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
                } else {
                    long now = System.currentTimeMillis();
                    if (now - this._lastSocialBroadcast > (long)this._minimalSocialInterval && !this.getAiType().equals((Object)L2NpcTemplate.AIType.CORPSE)) {
                        this._lastSocialBroadcast = now;
                        this.broadcastPacket(new SocialAction(this.getObjectId(), Rnd.get(8)));
                    }
                    if (this.isEventMob) {
                        L2Event.showEventHtml(player, String.valueOf(this.getObjectId()));
                    } else {
                        Quest[] qlst;
                        Quest[] qlsa = this.getTemplate().getEventQuests(Quest.QuestEventType.QUEST_START);
                        if (qlsa != null && qlsa.length > 0) {
                            player.setLastQuestNpcObject(this.getObjectId());
                        }
                        if ((qlst = this.getTemplate().getEventQuests(Quest.QuestEventType.ON_FIRST_TALK)) != null && qlst.length == 1) {
                            qlst[0].notifyFirstTalk(this, player);
                        } else {
                            this.showChatWindow(player);
                        }
                    }
                }
            }
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public void onActionShift(L2PcInstance player) {
        if (player == null) {
            return;
        }
        if (player.getAccessLevel().isGm()) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            if (this.isAutoAttackable(player)) {
                StatusUpdate su = new StatusUpdate(this.getObjectId());
                su.addAttribute(9, (int)this.getCurrentHp());
                su.addAttribute(10, this.getMaxHp());
                player.sendPacket(su);
            }
            NpcHtmlMessage html = new NpcHtmlMessage(0);
            StringBuilder html1 = StringUtil.startAppend(2500, "<html><body><center><font color=\"LEVEL\">NPC Info</font></center><br>Instance Type: ", this.getClass().getSimpleName(), "<br1>Faction: ", this.getFactionId() != null ? this.getFactionId() : "null");
            StringUtil.append(html1, "<br1>Coords: ", String.valueOf(this.getX()), ", ", String.valueOf(this.getY()), ",", String.valueOf(this.getZ()), " Heading ", String.valueOf(this.getHeading()));
            if (this.getSpawn() != null) {
                StringUtil.append(html1, "<br1>Spawn: ", String.valueOf(this.getSpawn().getLocx()), ", ", String.valueOf(this.getSpawn().getLocy()), ", ", String.valueOf(this.getSpawn().getLocz()), " ; Loc ID: ", String.valueOf(this.getSpawn().getLocation()), "<br1>Distance from spawn 2D: ", String.valueOf((int)Math.sqrt(this.getPlanDistanceSq(this.getSpawn().getLocx(), this.getSpawn().getLocy()))), " ; 3D: ", String.valueOf((int)Math.sqrt(this.getDistanceSq(this.getSpawn().getLocx(), this.getSpawn().getLocy(), this.getSpawn().getLocz()))));
            }
            html1.append("<br1>Distance from here  2D: ").append(Math.round(player.getDistance(this.getX(), this.getY())));
            if (this instanceof L2ControllableMobInstance) {
                StringUtil.append(html1, "<br1>Mob Group: ", String.valueOf(MobGroupTable.getInstance().getGroupForMob((L2ControllableMobInstance)this).getGroupId()), "<br>");
            } else {
                StringUtil.append(html1, "<br1>Respawn Time: ", this.getSpawn() == null ? "?" : String.valueOf(this.getSpawn().getRespawnDelay() / 1000), "  Seconds", this.getSpawn() == null ? "<BR>" : (this.getSpawn().isRespawnable() ? " (AUTO)<BR>" : " [STOP]<BR>"));
            }
            StringUtil.append(html1, "<table border=\"0\" width=\"100%\"><tr><td>Level</td><td>", String.valueOf(this.getLevel()), "</td><td>    </td><td>NPC ID</td><td>", String.valueOf(this.getTemplate().npcId), "</td></tr><tr><td>Aggro</td><td>" + String.valueOf(this instanceof L2Attackable ? ((L2Attackable)this).getAggroRange() : 0), "</td><td>    </td><td>Object ID</td><td>", String.valueOf(this.getObjectId()), "</td></tr><tr><td>Castle</td><td>", String.valueOf(this.getCastle().getCastleId()), "</td><td>    </td><td>AI </td><td>", this.hasAI() ? String.valueOf(this.getAI().getIntention().name()).replace("AI_INTENTION_", "") : "NULL", "</td></tr></table><br><font color=\"LEVEL\">Combat</font><table border=\"0\" width=\"100%\"><tr><td>Current HP</td><td>", String.format("%.1f", this.getCurrentHp()).replaceFirst("\\.0*$", ""), "</td><td>Current MP</td><td>", String.format("%.1f", this.getCurrentMp()).replaceFirst("\\.0*$", ""), "</td></tr><tr><td>Max.HP</td><td>", String.valueOf((int)((double)this.getMaxHp() / this.getStat().calcStat(Stats.MAX_HP, 1.0, this, null))), "*", String.valueOf((int)this.getStat().calcStat(Stats.MAX_HP, 1.0, this, null)), "</td><td>Max.MP</td><td>", String.valueOf(this.getMaxMp()), "</td></tr><tr><td>P.Atk.</td><td>", String.valueOf(this.getPAtk(null)), "</td><td>M.Atk.</td><td>", String.valueOf(this.getMAtk(null, null)), "</td></tr><tr><td>P.Def.</td><td>", String.valueOf(this.getPDef(null)), "</td><td>M.Def.</td><td>", String.valueOf(this.getMDef(null, null)), "</td></tr><tr><td>Accuracy</td><td>" + String.valueOf(this.getAccuracy()), "</td><td>Evasion</td><td>", String.valueOf(this.getEvasionRate(null)), "</td></tr><tr><td>Critical</td><td>", String.valueOf(this.getCriticalHit(null, null)), "</td><td>Speed</td><td>", String.valueOf(this.getRunSpeed()), "</td></tr><tr><td>Atk.Speed</td><td>", String.valueOf(this.getPAtkSpd()), "</td><td>Cast.Speed</td><td>", String.valueOf(this.getMAtkSpd()), "</td></tr></table><br><font color=\"LEVEL\">Basic Stats</font><table border=\"0\" width=\"100%\"><tr><td>STR</td><td>", String.valueOf(this.getSTR()), "</td><td>DEX</td><td>", String.valueOf(this.getDEX()), "</td><td>CON</td><td>", String.valueOf(this.getCON()), "</td></tr><tr><td>INT</td><td>", String.valueOf(this.getINT()), "</td><td>WIT</td><td>", String.valueOf(this.getWIT()), "</td><td>MEN</td><td>", String.valueOf(this.getMEN()), "</td></tr></table><br><center><table><tr><td><button value=\"Edit NPC\" action=\"bypass -h admin_edit_npc ", String.valueOf(this.getTemplate().npcId), "\" width=100 height=20 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"><br1></td><td><button value=\"Kill\" action=\"bypass -h admin_kill\" width=40 height=20 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td><br1></tr><tr><td><button value=\"Show DropList\" action=\"bypass -h admin_show_droplist ", String.valueOf(this.getTemplate().npcId), "\" width=100 height=20 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td></tr><td><button value=\"Delete\" action=\"bypass -h admin_delete\" width=40 height=20 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td></tr><tr><td><button value=\"Show SkillList\" action=\"bypass -h admin_show_skilllist_npc ", String.valueOf(this.getTemplate().npcId), "\" width=100 height=20 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td><td></td></tr></table></center><br></body></html>");
            html.setHtml(html1.toString());
            player.sendPacket(html);
        } else if (Config.ALT_GAME_VIEWNPC) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            if (this.isAutoAttackable(player)) {
                StatusUpdate su = new StatusUpdate(this.getObjectId());
                su.addAttribute(9, (int)this.getCurrentHp());
                su.addAttribute(10, this.getMaxHp());
                player.sendPacket(su);
            }
            NpcHtmlMessage html = new NpcHtmlMessage(0);
            StringBuilder html1 = StringUtil.startAppend(1000, "<html><body><br><center><font color=\"LEVEL\">[Combat Stats]</font></center><table border=0 width=\"100%\"><tr><td>Max.HP</td><td>", String.valueOf((int)((double)this.getMaxHp() / this.getStat().calcStat(Stats.MAX_HP, 1.0, this, null))), "*", String.valueOf((int)this.getStat().calcStat(Stats.MAX_HP, 1.0, this, null)), "</td><td>Max.MP</td><td>", String.valueOf(this.getMaxMp()), "</td></tr><tr><td>P.Atk.</td><td>", String.valueOf(this.getPAtk(null)), "</td><td>M.Atk.</td><td>", String.valueOf(this.getMAtk(null, null)), "</td></tr><tr><td>P.Def.</td><td>", String.valueOf(this.getPDef(null)), "</td><td>M.Def.</td><td>", String.valueOf(this.getMDef(null, null)), "</td></tr><tr><td>Accuracy</td><td>", String.valueOf(this.getAccuracy()), "</td><td>Evasion</td><td>", String.valueOf(this.getEvasionRate(null)), "</td></tr><tr><td>Critical</td><td>", String.valueOf(this.getCriticalHit(null, null)), "</td><td>Speed</td><td>", String.valueOf(this.getRunSpeed()), "</td></tr><tr><td>Atk.Speed</td><td>", String.valueOf(this.getPAtkSpd()), "</td><td>Cast.Speed</td><td>", String.valueOf(this.getMAtkSpd()), "</td></tr><tr><td>Race</td><td>", this.getTemplate().getRace().toString(), "</td><td></td><td></td></tr></table><br><center><font color=\"LEVEL\">[Basic Stats]</font></center><table border=0 width=\"100%\"><tr><td>STR</td><td>", String.valueOf(this.getSTR()), "</td><td>DEX</td><td>", String.valueOf(this.getDEX()), "</td><td>CON</td><td>", String.valueOf(this.getCON()), "</td></tr><tr><td>INT</td><td>", String.valueOf(this.getINT()), "</td><td>WIT</td><td>", String.valueOf(this.getWIT()), "</td><td>MEN</td><td>", String.valueOf(this.getMEN()), "</td></tr></table>");
            if (this.getTemplate().getDropData() != null) {
                StringUtil.append(html1, "<br><center><font color=\"LEVEL\">[Drop Info]</font></center><br>Rates legend: <font color=\"ff0000\">50%+</font> <font color=\"00ff00\">30%+</font> <font color=\"0000ff\">less than 30%</font><table border=0 width=\"100%\">");
                for (L2DropCategory cat : this.getTemplate().getDropData()) {
                    for (L2DropData drop : cat.getAllDrops()) {
                        L2Item item = ItemTable.getInstance().getTemplate(drop.getItemId());
                        if (item == null) continue;
                        String color = drop.getChance() >= 500000 ? "ff0000" : (drop.getChance() >= 300000 ? "00ff00" : "0000ff");
                        StringUtil.append(html1, "<tr><td><font color=\"", color, "\">", item.getName(), "</font></td><td>", drop.isQuestDrop() ? "Quest" : (cat.isSweep() ? "Sweep" : "Drop"), "</td></tr>");
                    }
                }
                html1.append("</table>");
            }
            html1.append("</body></html>");
            html.setHtml(html1.toString());
            player.sendPacket(html);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public final Castle getCastle() {
        if (this._castleIndex < 0) {
            L2TownZone town = TownManager.getTown(this.getX(), this.getY(), this.getZ());
            if (town != null) {
                this._castleIndex = CastleManager.getInstance().getCastleIndex(town.getTaxById());
            }
            if (this._castleIndex < 0) {
                this._castleIndex = CastleManager.getInstance().findNearestCastleIndex(this);
            } else {
                this._isInTown = true;
            }
        }
        if (this._castleIndex < 0) {
            return null;
        }
        return CastleManager.getInstance().getCastles().get(this._castleIndex);
    }

    public final Fort getFort() {
        if (this._fortIndex < 0) {
            Fort fort = FortManager.getInstance().getFort(this.getX(), this.getY(), this.getZ());
            if (fort != null) {
                this._fortIndex = FortManager.getInstance().getFortIndex(fort.getFortId());
            }
            if (this._fortIndex < 0) {
                this._fortIndex = FortManager.getInstance().findNearestFortIndex(this);
            }
        }
        if (this._fortIndex < 0) {
            return null;
        }
        return FortManager.getInstance().getForts().get(this._fortIndex);
    }

    public final boolean getIsInTown() {
        if (this._castleIndex < 0) {
            this.getCastle();
        }
        return this._isInTown;
    }

    public void onBypassFeedback(L2PcInstance player, String command) {
        if (this.isBusy() && this.getBusyMessage().length() > 0) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile("data/html/npcbusy.htm");
            html.replace((CharSequence)"%busymessage%", this.getBusyMessage());
            html.replace((CharSequence)"%npcname%", this.getName());
            html.replace((CharSequence)"%playername%", player.getName());
            player.sendPacket(html);
        } else if (command.equalsIgnoreCase("TerritoryStatus")) {
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            if (this.getCastle().getOwnerId() > 0) {
                html.setFile("data/html/territorystatus.htm");
                L2Clan clan = ClanTable.getInstance().getClan(this.getCastle().getOwnerId());
                html.replace((CharSequence)"%clanname%", clan.getName());
                html.replace((CharSequence)"%clanleadername%", clan.getLeaderName());
            } else {
                html.setFile("data/html/territorynoclan.htm");
            }
            html.replace((CharSequence)"%castlename%", this.getCastle().getNameJA());
            html.replace((CharSequence)"%taxpercent%", "" + this.getCastle().getTaxPercent());
            html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
            if (this.getCastle().getCastleId() > 6) {
                html.replace((CharSequence)"%territory%", "\u30a8\u30eb\u30e2\u30a2\u738b\u56fd");
            } else {
                html.replace((CharSequence)"%territory%", "\u30a2\u30c7\u30f3\u738b\u56fd");
            }
            player.sendPacket(html);
        } else if (command.startsWith("Quest")) {
            String quest = "";
            try {
                quest = command.substring(5).trim();
            }
            catch (IndexOutOfBoundsException ioobe) {
                // empty catch block
            }
            if (quest.length() == 0) {
                this.showQuestWindow(player);
            } else {
                this.showQuestWindow(player, quest);
            }
        } else if (command.startsWith("Chat")) {
            int val = 0;
            try {
                val = Integer.parseInt(command.substring(5));
            }
            catch (IndexOutOfBoundsException ioobe) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.showChatWindow(player, val);
        } else if (command.startsWith("Link")) {
            String path = command.substring(5).trim();
            if (path.indexOf("..") != -1) {
                return;
            }
            String filename = "data/html/" + path;
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile(filename);
            html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
            player.sendPacket(html);
        } else if (command.startsWith("NobleTeleport")) {
            if (!player.isNoble()) {
                String filename = "data/html/teleporter/nobleteleporter-no.htm";
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(filename);
                html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
                html.replace((CharSequence)"%npcname%", this.getName());
                player.sendPacket(html);
                return;
            }
            int val = 0;
            try {
                val = Integer.parseInt(command.substring(5));
            }
            catch (IndexOutOfBoundsException ioobe) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.showChatWindow(player, val);
        } else if (command.startsWith("Loto")) {
            int val = 0;
            try {
                val = Integer.parseInt(command.substring(5));
            }
            catch (IndexOutOfBoundsException ioobe) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (val == 0) {
                for (int i = 0; i < 5; ++i) {
                    player.setLoto(i, 0);
                }
            }
            this.showLotoWindow(player, val);
        } else if (command.startsWith("CPRecovery")) {
            this.makeCPRecovery(player);
        } else if (command.startsWith("SupportMagicServitor")) {
            this.makeSupportMagic(player, true);
        } else if (command.startsWith("SupportMagic")) {
            this.makeSupportMagic(player, false);
        } else if (command.startsWith("GiveBlessing")) {
            this.giveBlessingSupport(player);
        } else if (command.startsWith("multisell")) {
            int listId = Integer.parseInt(command.substring(9).trim());
            L2Multisell.getInstance().separateAndSend(listId, player, this.getNpcId(), false, this.getCastle().getTaxRate());
        } else if (command.startsWith("exc_multisell")) {
            int listId = Integer.parseInt(command.substring(13).trim());
            L2Multisell.getInstance().separateAndSend(listId, player, this.getNpcId(), true, this.getCastle().getTaxRate());
        } else if (command.startsWith("Augment")) {
            int cmdChoice = Integer.parseInt(command.substring(8, 9).trim());
            switch (cmdChoice) {
                case 1: {
                    player.sendPacket(new ExShowVariationMakeWindow());
                    break;
                }
                case 2: {
                    player.sendPacket(new ExShowVariationCancelWindow());
                }
            }
        } else if (command.startsWith("npcfind_byid")) {
            try {
                L2Spawn spawn = SpawnTable.getInstance().getTemplate(Integer.parseInt(command.substring(12).trim()));
                if (spawn != null) {
                    player.sendPacket(new RadarControl(2, 2, spawn.getLocx(), spawn.getLocy(), spawn.getLocz()));
                    player.sendPacket(new RadarControl(0, 1, spawn.getLocx(), spawn.getLocy(), spawn.getLocz()));
                }
            }
            catch (NumberFormatException nfe) {
                player.sendMessage("Wrong command parameters");
            }
        } else if (command.startsWith("EnterRift")) {
            try {
                Byte b1 = Byte.parseByte(command.substring(10));
                DimensionalRiftManager.getInstance().start(player, b1, this);
            }
            catch (Exception e) {}
        } else if (command.startsWith("ChangeRiftRoom")) {
            if (player.isInParty() && player.getParty().isInDimensionalRift()) {
                player.getParty().getDimensionalRift().manualTeleport(player, this);
            } else {
                DimensionalRiftManager.getInstance().handleCheat(player, this);
            }
        } else if (command.startsWith("remove_dp")) {
            int cmdChoice = Integer.parseInt(command.substring(10, 11).trim());
            int[] pen_clear_price = new int[]{3600, 8640, 25200, 50400, 86400, 144000, 144000, 144000};
            switch (cmdChoice) {
                case 1: {
                    String filename = "data/html/default/30981-1.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(filename);
                    html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
                    html.replace((CharSequence)"%dp_price%", String.valueOf(pen_clear_price[player.getExpertiseIndex()]));
                    player.sendPacket(html);
                    break;
                }
                case 2: {
                    NpcHtmlMessage Reply = new NpcHtmlMessage(this.getObjectId());
                    StringBuilder replyMSG = StringUtil.startAppend(400, "<html><body>\u30d6\u30e9\u30c3\u30af \u30b8\u30e3\u30c3\u30b8:<br>");
                    if (player.getDeathPenaltyBuffLevel() > 0) {
                        if (player.getAdena() >= (long)pen_clear_price[player.getExpertiseIndex()]) {
                            if (!player.reduceAdena("DeathPenality", pen_clear_price[player.getExpertiseIndex()], this, true)) {
                                return;
                            }
                            player.setDeathPenaltyBuffLevel(player.getDeathPenaltyBuffLevel() - 1);
                            player.sendPacket(new SystemMessage(SystemMessageId.DEATH_PENALTY_LIFTED));
                            player.sendPacket(new EtcStatusUpdate(player));
                            return;
                        }
                        replyMSG.append("<FONT COLOR=A0B0C0>\u50b7\u304c\u6df1\u3059\u304e\u3066\u3001\u3042\u306a\u305f\u306e\u6240\u6301\u91d1\u3067\u306f\u8db3\u308a\u307e\u305b\u3093\u3002\u6b7b\u304c\u3082\u305f\u3089\u3059\u50b7\u3092\u5b8c\u5168\u306b\u53d6\u308a\u9664\u304d\u305f\u3051\u308c\u3070\u3001\u3082\u3063\u3068\u591a\u304f\u306e\u30a2\u30c7\u30ca\u3092\u6301\u3063\u3066\u304d\u306a\u3055\u3044\u3002</FONT>");
                    } else {
                        replyMSG.append("<FONT COLOR=A0B0C0>\u3082\u3046\u7652\u3059\u3079\u304d\u50b7\u306f\u6b8b\u3063\u3066\u3044\u307e\u305b\u3093\u3002\u3055\u3041\u304a\u884c\u304d\u306a\u3055\u3044\u3002\u3053\u306e\u4e16\u754c\u3068\u3042\u306a\u305f\u81ea\u8eab\u306e\u6804\u5149\u306e\u305f\u3081\u306b\u6226\u3046\u306e\u3067\u3059\uff01<br>");
                    }
                    replyMSG.append("</body></html>");
                    Reply.setHtml(replyMSG.toString());
                    player.sendPacket(Reply);
                }
            }
        } else if (command.startsWith("ExitRift")) {
            if (player.isInParty() && player.getParty().isInDimensionalRift()) {
                player.getParty().getDimensionalRift().manualExitRift(player, this);
            } else {
                DimensionalRiftManager.getInstance().handleCheat(player, this);
            }
        } else {
            if (command.startsWith("open_gate")) {
                DoorTable _doorTable = DoorTable.getInstance();
                StringTokenizer st = new StringTokenizer(command.substring(10), ", ");
                while (st.hasMoreTokens()) {
                    int doorId = Integer.parseInt(st.nextToken());
                    try {
                        _doorTable.getDoor(doorId).openMe();
                        _doorTable.getDoor(doorId).onOpen();
                    }
                    catch (NullPointerException e) {
                        _log.warning("Door Id does not exist.(" + doorId + ")");
                    }
                }
                return;
            }
            if (command.startsWith("ReleaseAttribute")) {
                player.sendPacket(new ExShowBaseAttributeCancelWindow(player));
            } else {
                _log.info(this.getClass().getSimpleName() + ": Unknown NPC bypass: \"" + command + "\" NpcId: " + this.getNpcId());
            }
        }
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        int weaponId = this.getTemplate().rhand;
        if (weaponId < 1) {
            return null;
        }
        L2Item item = ItemTable.getInstance().getTemplate(this.getTemplate().rhand);
        if (!(item instanceof L2Weapon)) {
            return null;
        }
        return (L2Weapon)item;
    }

    public void giveBlessingSupport(L2PcInstance player) {
        if (player == null) {
            return;
        }
        int player_level = player.getLevel();
        this.setTarget(player);
        if (player_level > 39 || player.getClassId().level() >= 2) {
            String content = "<html><body>Newbie Guide:<br>I'm sorry, but you are not eligible to receive the protection blessing.<br1>It can only be bestowed on <font color=\"LEVEL\">characters below level 39 who have not made a seccond transfer.</font></body></html>";
            this.insertObjectIdAndShowChatWindow(player, content);
            return;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(5182, 1);
        this.doCast(skill);
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        int weaponId = this.getTemplate().lhand;
        if (weaponId < 1) {
            return null;
        }
        L2Item item = ItemTable.getInstance().getTemplate(this.getTemplate().lhand);
        if (!(item instanceof L2Weapon)) {
            return null;
        }
        return (L2Weapon)item;
    }

    public void insertObjectIdAndShowChatWindow(L2PcInstance player, String content) {
        content = content.replaceAll("%objectId%", String.valueOf(this.getObjectId()));
        NpcHtmlMessage npcReply = new NpcHtmlMessage(this.getObjectId());
        npcReply.setHtml(content);
        player.sendPacket(npcReply);
    }

    public String getHtmlPath(String prefix, int npcId, int val) {
        StringBuilder pom = new StringBuilder(64).append(prefix);
        if (npcId != 0) {
            pom.append(npcId);
        }
        if (val != 0) {
            pom.append('-').append(val);
        }
        return pom.append(".htm").toString();
    }

    public String getHtmlPath(String prefix, int npcId, int val, String defaultPath) {
        String temp = this.getHtmlPath(prefix, npcId, val);
        if (HtmCache.getInstance().getHtm(temp) != null) {
            return temp;
        }
        if (defaultPath != null) {
            return defaultPath;
        }
        return "data/html/npcdefault.htm";
    }

    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/default/", npcId, val, null);
    }

    @Deprecated
    public void TRACE(String message) {
        this.TRACE(this.getTitle() == null || this.getTitle().isEmpty() ? this.getName() : this.getTitle() + " " + this.getName(), message);
    }

    @Deprecated
    public void TRACE(String title, String message) {
    }

    public void showQuestChooseWindow(L2PcInstance player, Quest[] quests) {
        StringBuilder sb = StringUtil.startAppend(150, "<html><body>");
        for (Quest q : quests) {
            StringUtil.append(sb, "<a action=\"bypass -h npc_", String.valueOf(this.getObjectId()), "_Quest ", q.getName(), "\">[", q.getDescr());
            QuestState qs = player.getQuestState(q.getScriptName());
            if (qs != null) {
                if (qs.getState() == 1 && qs.getInt("cond") > 0) {
                    sb.append("(\u9032\u884c\u4e2d)");
                } else if (qs.getState() == 2) {
                    sb.append("(\u5b8c\u4e86)");
                }
            }
            sb.append("]</a><br>");
        }
        sb.append("</body></html>");
        this.insertObjectIdAndShowChatWindow(player, sb.toString());
    }

    public void showQuestWindow(L2PcInstance player, String questId) {
        String content = null;
        Quest q = QuestManager.getInstance().getQuest(questId);
        QuestState qs = player.getQuestState(questId);
        if (q == null) {
            content = "<html><body>\u30af\u30a8\u30b9\u30c8\u3092\u9042\u884c\u3057\u3066\u3044\u306a\u3044\u304b\u6761\u4ef6\u304c\u5408\u3044\u307e\u305b\u3093\u3002</body></html>";
        } else {
            if (q.getQuestIntId() >= 1 && q.getQuestIntId() < 20000 && (player.getWeightPenalty() >= 3 || (double)player.getInventoryLimit() * 0.8 <= (double)player.getInventory().getSize())) {
                player.sendPacket(new SystemMessage(SystemMessageId.INVENTORY_LESS_THAN_80_PERCENT));
                return;
            }
            if (qs == null) {
                Quest[] questList;
                if (q.getQuestIntId() >= 1 && q.getQuestIntId() < 20000 && (questList = player.getAllActiveQuests()).length >= 25) {
                    player.sendPacket(new SystemMessage(SystemMessageId.TOO_MANY_QUESTS));
                    return;
                }
                Quest[] qlst = this.getTemplate().getEventQuests(Quest.QuestEventType.QUEST_START);
                if (qlst != null && qlst.length > 0) {
                    for (Quest temp : qlst) {
                        if (temp != q) continue;
                        qs = q.newQuestState(player);
                        break;
                    }
                }
            }
        }
        if (qs != null) {
            if (!qs.getQuest().notifyTalk(this, qs)) {
                return;
            }
            questId = qs.getQuest().getName();
            String stateId = State.getStateName(qs.getState());
            String path = "data/scripts/quests/" + questId + "/" + stateId + ".htm";
            content = HtmCache.getInstance().getHtm(path);
            if (Config.DEBUG) {
                if (content != null) {
                    _log.fine("Showing quest window for quest " + questId + " html path: " + path);
                } else {
                    _log.fine("File not exists for quest " + questId + " html path: " + path);
                }
            }
        }
        if (content != null) {
            this.insertObjectIdAndShowChatWindow(player, content);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void showQuestWindow(L2PcInstance player) {
        FastList options = new FastList();
        QuestState[] awaits = player.getQuestsForTalk(this.getTemplate().npcId);
        Quest[] starts = this.getTemplate().getEventQuests(Quest.QuestEventType.QUEST_START);
        if (awaits != null) {
            for (QuestState questState : awaits) {
                if (options.contains(questState.getQuest()) || !questState.getQuest().isQuests()) continue;
                options.add(questState.getQuest());
            }
        }
        if (starts != null) {
            for (Quest quest : starts) {
                if (options.contains(quest) || !quest.isQuests()) continue;
                options.add(quest);
            }
        }
        if (options.size() > 1) {
            this.showQuestChooseWindow(player, options.toArray(new Quest[options.size()]));
        } else if (options.size() == 1) {
            this.showQuestWindow(player, ((Quest)options.get(0)).getName());
        } else {
            this.showQuestWindow(player, "");
        }
    }

    public void showLotoWindow(L2PcInstance player, int val) {
        int npcId = this.getTemplate().npcId;
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        if (val == 0) {
            String filename = this.getHtmlPath(npcId, 1);
            html.setFile(filename);
        } else if (val < 0) {
            String filename = this.getHtmlPath(npcId, -val);
            html.setFile(filename);
        } else if (val >= 1 && val <= 21) {
            String replace;
            int i;
            if (!Lottery.getInstance().isStarted()) {
                player.sendPacket(new SystemMessage(SystemMessageId.NO_LOTTERY_TICKETS_CURRENT_SOLD));
                return;
            }
            if (!Lottery.getInstance().isSellableTickets()) {
                player.sendPacket(new SystemMessage(SystemMessageId.NO_LOTTERY_TICKETS_AVAILABLE));
                return;
            }
            String filename = this.getHtmlPath(npcId, 5);
            html.setFile(filename);
            int count = 0;
            boolean found = false;
            for (i = 0; i < 5; ++i) {
                if (player.getLoto(i) == val) {
                    player.setLoto(i, 0);
                    found = true;
                    continue;
                }
                if (player.getLoto(i) <= 0) continue;
                ++count;
            }
            if (count < 5 && !found && val <= 20) {
                for (i = 0; i < 5; ++i) {
                    if (player.getLoto(i) != 0) continue;
                    player.setLoto(i, val);
                    break;
                }
            }
            count = 0;
            for (i = 0; i < 5; ++i) {
                if (player.getLoto(i) <= 0) continue;
                ++count;
                String button = String.valueOf(player.getLoto(i));
                if (player.getLoto(i) < 10) {
                    button = "0" + button;
                }
                String search = "fore=\"L2UI.lottoNum" + button + "\" back=\"L2UI.lottoNum" + button + "a_check\"";
                String replace2 = "fore=\"L2UI.lottoNum" + button + "a_check\" back=\"L2UI.lottoNum" + button + "\"";
                html.replace((CharSequence)search, replace2);
            }
            if (count == 5 && html.replace((CharSequence)"0\">Return", replace = "22\">\u4e0a\u306e\u756a\u53f7\u3067\u9078\u629e") == 0 && html.replace((CharSequence)"0\">\u623b\u308b", replace) == 0) {
                _log.warning(filename + "/" + replace + "/ can't replace.");
            }
        } else if (val == 22) {
            if (!Lottery.getInstance().isStarted()) {
                player.sendPacket(new SystemMessage(SystemMessageId.NO_LOTTERY_TICKETS_CURRENT_SOLD));
                return;
            }
            if (!Lottery.getInstance().isSellableTickets()) {
                player.sendPacket(new SystemMessage(SystemMessageId.NO_LOTTERY_TICKETS_AVAILABLE));
                return;
            }
            long price = Config.ALT_LOTTERY_TICKET_PRICE;
            int lotonumber = Lottery.getInstance().getId();
            int enchant = 0;
            int type2 = 0;
            for (int i = 0; i < 5; ++i) {
                if (player.getLoto(i) == 0) {
                    return;
                }
                if (player.getLoto(i) < 17) {
                    enchant = (int)((double)enchant + Math.pow(2.0, player.getLoto(i) - 1));
                    continue;
                }
                type2 = (int)((double)type2 + Math.pow(2.0, player.getLoto(i) - 17));
            }
            if (player.getAdena() < price) {
                SystemMessage sm = new SystemMessage(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
                player.sendPacket(sm);
                return;
            }
            if (!player.reduceAdena("Loto", price, this, true)) {
                return;
            }
            Lottery.getInstance().increasePrize(price);
            SystemMessage sm = new SystemMessage(SystemMessageId.ACQUIRED_S1_S2);
            sm.addNumber(lotonumber);
            sm.addItemName(4442);
            player.sendPacket(sm);
            L2ItemInstance item = new L2ItemInstance(IdFactory.getInstance().getNextId(), 4442);
            item.setCount(1L);
            item.setCustomType1(lotonumber);
            item.setEnchantLevel(enchant);
            item.setCustomType2(type2);
            player.getInventory().addItem("Loto", item, player, this);
            InventoryUpdate iu = new InventoryUpdate();
            iu.addItem(item);
            L2ItemInstance adenaupdate = player.getInventory().getItemByItemId(57);
            iu.addModifiedItem(adenaupdate);
            player.sendPacket(iu);
            String filename = this.getHtmlPath(npcId, 3);
            html.setFile(filename);
        } else if (val == 23) {
            String filename = this.getHtmlPath(npcId, 3);
            html.setFile(filename);
        } else if (val == 24) {
            String filename = this.getHtmlPath(npcId, 4);
            html.setFile(filename);
            int lotonumber = Lottery.getInstance().getId();
            StringBuilder message = new StringBuilder(2000);
            for (L2ItemInstance item : player.getInventory().getItems()) {
                if (item == null || item.getItemId() != 4442 || item.getCustomType1() >= lotonumber) continue;
                message.append("<a action=\"bypass -h npc_%objectId%_Loto ").append(item.getObjectId()).append("\">\u7b2c").append(item.getCustomType1()).append("\u56de: ");
                int[] numbers = Lottery.getInstance().decodeNumbers(item.getEnchantLevel(), item.getCustomType2());
                for (int i = 0; i < 5; ++i) {
                    message.append(numbers[i]).append(' ');
                }
                long[] check = Lottery.getInstance().checkTicket(item);
                if (check[0] > 0L) {
                    switch ((int)check[0]) {
                        case 1: {
                            message.append("- 1\u5f53");
                            break;
                        }
                        case 2: {
                            message.append("- 2\u5f53");
                            break;
                        }
                        case 3: {
                            message.append("- 3\u5f53");
                            break;
                        }
                        case 4: {
                            message.append("- 4\u5f53");
                        }
                    }
                    message.append(' ').append(check[1]).append('A');
                }
                message.append("</a><br>");
            }
            if (message.length() == 0) {
                message.append("\u5f53\u9078\u3057\u305f\u5b9d\u304f\u3058\u306f\u3042\u308a\u307e\u305b\u3093...<br>");
            }
            html.replace((CharSequence)"%result%", message.toString());
        } else if (val > 24) {
            int lotonumber = Lottery.getInstance().getId();
            L2ItemInstance item = player.getInventory().getItemByObjectId(val);
            if (item == null || item.getItemId() != 4442 || item.getCustomType1() >= lotonumber) {
                return;
            }
            long[] check = Lottery.getInstance().checkTicket(item);
            SystemMessage sm = new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
            sm.addItemName(4442);
            sm.addItemNumber(1L);
            player.sendPacket(sm);
            long adena = check[1];
            if (adena > 0L) {
                player.addAdena("Loto", adena, this, true);
            }
            player.destroyItem("Loto", item, this, false);
            return;
        }
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%race%", Lottery.getInstance().getId());
        html.replace((CharSequence)"%adena%", NumberFormat.getInstance().format(Lottery.getInstance().getPrize()));
        html.replace((CharSequence)"%ticket_price%", Config.ALT_LOTTERY_TICKET_PRICE);
        html.replace((CharSequence)"%prize5%", Config.ALT_LOTTERY_5_NUMBER_RATE * 100.0f);
        html.replace((CharSequence)"%prize4%", Config.ALT_LOTTERY_4_NUMBER_RATE * 100.0f);
        html.replace((CharSequence)"%prize3%", Config.ALT_LOTTERY_3_NUMBER_RATE * 100.0f);
        html.replace((CharSequence)"%prize2%", Config.ALT_LOTTERY_2_AND_1_NUMBER_PRIZE);
        html.replace((CharSequence)"%enddate%", DateFormat.getDateInstance().format(Lottery.getInstance().getEndDate()));
        player.sendPacket(html);
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void makeCPRecovery(L2PcInstance player) {
        if (this.getNpcId() != 31225 && this.getNpcId() != 31226) {
            return;
        }
        if (player.isCursedWeaponEquipped()) {
            player.sendMessage("\u51fa\u3066\u884c\u304d\u306a\u3055\u3044\u3002\u3053\u3053\u306f\u3042\u306a\u305f\u306e\u6765\u308b\u5834\u6240\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        int neededmoney = 100;
        if (!player.reduceAdena("RestoreCP", neededmoney, player.getLastFolkNPC(), true)) {
            return;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(4380, 1);
        if (skill != null) {
            this.setTarget(player);
            this.doCast(skill);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void makeSupportMagic(L2PcInstance player, boolean isSummon) {
        if (player == null) {
            return;
        }
        if (player.isCursedWeaponEquipped()) {
            return;
        }
        int player_level = player.getLevel();
        int lowestLevel = 0;
        int highestLevel = 0;
        if (isSummon) {
            if (player.getPet() == null || !(player.getPet() instanceof L2SummonInstance)) {
                String content = "<html><body>\u53ec\u559a\u7363\u7528\u306e\u88dc\u52a9\u9b54\u6cd5\u306f\u3001\u53ec\u559a\u7363\u306e\u307f\u306b\u52b9\u529b\u304c\u3042\u308a\u307e\u3059\u3002\u53ec\u559a\u7363\u304c\u3044\u306a\u3044\u5834\u5408\u306b\u306f\u3001\u9b54\u6cd5\u3092\u304b\u3051\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002</body></html>";
                this.insertObjectIdAndShowChatWindow(player, content);
                return;
            }
            this.setTarget(player.getPet());
        } else {
            this.setTarget(player);
        }
        if (isSummon) {
            lowestLevel = HelperBuffTable.getInstance().getServitorLowestLevel();
            highestLevel = HelperBuffTable.getInstance().getServitorHighestLevel();
        } else if (player.isMageClass()) {
            lowestLevel = HelperBuffTable.getInstance().getMagicClassLowestLevel();
            highestLevel = HelperBuffTable.getInstance().getMagicClassHighestLevel();
        } else {
            lowestLevel = HelperBuffTable.getInstance().getPhysicClassLowestLevel();
            highestLevel = HelperBuffTable.getInstance().getPhysicClassHighestLevel();
        }
        if (player_level > highestLevel) {
            String content = "<html><body>\u521d\u5fc3\u8005\u6848\u5185\u4eba:<br>\u88dc\u52a9\u9b54\u6cd5\u306f<font color=\"LEVEL\">\u30ec\u30d9\u30eb" + highestLevel + "\u4ee5\u4e0b\u306e\u65b0\u898f\u30ad\u30e3\u30e9\u30af\u30bf\u30fc</font>\u306e\u307f\u304c\u53d7\u3051\u3089\u308c\u307e\u3059\u3002<br>\u65b0\u898f\u30ad\u30e3\u30e9\u30af\u30bf\u3068\u306f\u3001\u30ef\u30fc\u30eb\u30c9\u5185\u3067\u6700\u521d\u306b\u80b2\u3066\u305f\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u306e\u3053\u3068\u3067\u3059\u3002</body></html>";
            this.insertObjectIdAndShowChatWindow(player, content);
            return;
        }
        if (player_level < lowestLevel) {
            String content = "<html><body>" + lowestLevel + "\u306b\u306a\u3063\u305f\u3089\u307e\u305f\u6765\u306a\u3055\u3044\u3002\u305d\u306e\u3068\u304d\u306f\u88dc\u52a9\u9b54\u6cd5\u3092\u304b\u3051\u3066\u3042\u3052\u307e\u3057\u3087\u3046\u3002</body></html>";
            this.insertObjectIdAndShowChatWindow(player, content);
            return;
        }
        L2Skill skill = null;
        if (isSummon) {
            for (L2HelperBuff helperBuffItem : HelperBuffTable.getInstance().getHelperBuffTable()) {
                if (!helperBuffItem.isForSummon() || (skill = SkillTable.getInstance().getInfo(helperBuffItem.getSkillID(), helperBuffItem.getSkillLevel())) == null) continue;
                this.doCast(skill);
            }
        } else {
            for (L2HelperBuff helperBuffItem : HelperBuffTable.getInstance().getHelperBuffTable()) {
                if (helperBuffItem.isMagicClassBuff() != player.isMageClass() || player_level < helperBuffItem.getLowerLevel() || player_level > helperBuffItem.getUpperLevel()) continue;
                skill = SkillTable.getInstance().getInfo(helperBuffItem.getSkillID(), helperBuffItem.getSkillLevel());
                if (skill.getSkillType() == L2SkillType.SUMMON) {
                    player.doSimultaneousCast(skill);
                    continue;
                }
                long castTimeLeft = this.getCastEndTimeLeftMilli();
                if (castTimeLeft > 0L) {
                    try {
                        Thread.sleep(castTimeLeft);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.doCast(skill);
            }
        }
    }

    public void showChatWindow(L2PcInstance player) {
        this.showChatWindow(player, 0);
    }

    private boolean showPkDenyChatWindow(L2PcInstance player, String type) {
        String html = HtmCache.getInstance().getHtm("data/html/" + type + "/" + this.getNpcId() + "-pk.htm");
        if (html != null) {
            NpcHtmlMessage pkDenyMsg = new NpcHtmlMessage(this.getObjectId());
            pkDenyMsg.setHtml(html);
            player.sendPacket(pkDenyMsg);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return true;
        }
        return false;
    }

    public void showChatWindow(L2PcInstance player, int val) {
        if (!(!player.isCursedWeaponEquipped() || player.getTarget() instanceof L2ClanHallManagerInstance && player.getTarget() instanceof L2DoormenInstance)) {
            player.setTarget(player);
            return;
        }
        if (player.getKarma() > 0 && (!Config.ALT_GAME_KARMA_PLAYER_CAN_SHOP && this instanceof L2MerchantInstance ? this.showPkDenyChatWindow(player, "merchant") : (!Config.ALT_GAME_KARMA_PLAYER_CAN_USE_GK && this instanceof L2TeleporterInstance ? this.showPkDenyChatWindow(player, "teleporter") : (!Config.ALT_GAME_KARMA_PLAYER_CAN_USE_WAREHOUSE && this instanceof L2WarehouseInstance ? this.showPkDenyChatWindow(player, "warehouse") : !Config.ALT_GAME_KARMA_PLAYER_CAN_SHOP && this instanceof L2FishermanInstance && this.showPkDenyChatWindow(player, "fisherman"))))) {
            return;
        }
        if ("L2Auctioneer".equals(this.getTemplate().type) && val == 0) {
            return;
        }
        int npcId = this.getTemplate().npcId;
        String filename = "data/html/seven_signs/";
        int sealAvariceOwner = SevenSigns.getInstance().getSealOwner(1);
        int sealGnosisOwner = SevenSigns.getInstance().getSealOwner(2);
        int playerCabal = SevenSigns.getInstance().getPlayerCabal(player);
        int compWinner = SevenSigns.getInstance().getCabalHighestScore();
        switch (npcId) {
            case 31127: 
            case 31128: 
            case 31129: 
            case 31130: 
            case 31131: {
                filename = filename + "festival/dawn_guide.htm";
                break;
            }
            case 31137: 
            case 31138: 
            case 31139: 
            case 31140: 
            case 31141: {
                filename = filename + "festival/dusk_guide.htm";
                break;
            }
            case 31092: {
                filename = filename + "blkmrkt_1.htm";
                break;
            }
            case 31113: {
                if (Config.ALT_STRICT_SEVENSIGNS) {
                    switch (compWinner) {
                        case 2: {
                            if (playerCabal == compWinner && playerCabal == sealAvariceOwner) break;
                            player.sendPacket(new SystemMessage(SystemMessageId.CAN_BE_USED_BY_DAWN));
                            player.sendPacket(ActionFailed.STATIC_PACKET);
                            return;
                        }
                        case 1: {
                            if (playerCabal == compWinner && playerCabal == sealAvariceOwner) break;
                            player.sendPacket(new SystemMessage(SystemMessageId.CAN_BE_USED_BY_DUSK));
                            player.sendPacket(ActionFailed.STATIC_PACKET);
                            return;
                        }
                        default: {
                            player.sendPacket(new SystemMessage(SystemMessageId.QUEST_EVENT_PERIOD));
                            return;
                        }
                    }
                }
                filename = filename + "mammmerch_1.htm";
                break;
            }
            case 31126: {
                if (Config.ALT_STRICT_SEVENSIGNS) {
                    switch (compWinner) {
                        case 2: {
                            if (playerCabal == compWinner && playerCabal == sealGnosisOwner) break;
                            player.sendPacket(new SystemMessage(SystemMessageId.CAN_BE_USED_BY_DAWN));
                            player.sendPacket(ActionFailed.STATIC_PACKET);
                            return;
                        }
                        case 1: {
                            if (playerCabal == compWinner && playerCabal == sealGnosisOwner) break;
                            player.sendPacket(new SystemMessage(SystemMessageId.CAN_BE_USED_BY_DUSK));
                            player.sendPacket(ActionFailed.STATIC_PACKET);
                            return;
                        }
                        default: {
                            player.sendPacket(new SystemMessage(SystemMessageId.QUEST_EVENT_PERIOD));
                            return;
                        }
                    }
                }
                filename = filename + "mammblack_1.htm";
                break;
            }
            case 31132: 
            case 31133: 
            case 31134: 
            case 31135: 
            case 31136: 
            case 31142: 
            case 31143: 
            case 31144: 
            case 31145: 
            case 31146: {
                filename = filename + "festival/festival_witch.htm";
                break;
            }
            case 31688: {
                if (player.isNoble()) {
                    filename = "data/html/olympiad/noble_main.htm";
                    break;
                }
                filename = this.getHtmlPath(npcId, val);
                break;
            }
            case 31690: 
            case 31769: 
            case 31770: 
            case 31771: 
            case 31772: {
                if (player.isHero() || player.isNoble()) {
                    filename = "data/html/olympiad/hero_main.htm";
                    break;
                }
                filename = this.getHtmlPath(npcId, val);
                break;
            }
            case 36402: {
                if (player.olyBuff > 0) {
                    filename = player.olyBuff == 5 ? "data/html/olympiad/olympiad_buffs.htm" : "data/html/olympiad/olympiad_5buffs.htm";
                    break;
                }
                filename = "data/html/olympiad/olympiad_nobuffs.htm";
                break;
            }
            default: {
                if (npcId >= 31865 && npcId <= 31918) {
                    if (val == 0) {
                        filename = filename + "rift/GuardianOfBorder.htm";
                        break;
                    }
                    filename = filename + "rift/GuardianOfBorder-" + val + ".htm";
                    break;
                }
                if (npcId >= 31093 && npcId <= 31094 || npcId >= 31172 && npcId <= 31201 || npcId >= 31239 && npcId <= 31254) {
                    return;
                }
                filename = this.getHtmlPath(npcId, val);
            }
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(filename);
        if (Config.ALLOW_RENTPET && this instanceof L2MerchantInstance && Config.LIST_PET_RENT_NPC.contains(npcId)) {
            html.replace((CharSequence)"_Quest", "_RentPet\">\u30da\u30c3\u30c8\u3092\u30ec\u30f3\u30bf\u30eb\u3059\u308b\u3002</a><br><a action=\"bypass -h npc_%objectId%_Quest");
        }
        html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
        html.replace((CharSequence)"%festivalMins%", SevenSignsFestival.getInstance().getTimeToNextFestivalStr());
        player.sendPacket(html);
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void showChatWindow(L2PcInstance player, String filename) {
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(filename);
        html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
        player.sendPacket(html);
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public int getExpReward() {
        double rateXp = this.getStat().calcStat(Stats.MAX_HP, 1.0, this, null);
        return (int)((double)this.getTemplate().rewardExp * rateXp * (double)Config.RATE_XP);
    }

    public int getSpReward() {
        double rateSp = this.getStat().calcStat(Stats.MAX_HP, 1.0, this, null);
        return (int)((double)this.getTemplate().rewardSp * rateSp * (double)Config.RATE_SP);
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        this._currentLHandId = this.getTemplate().lhand;
        this._currentRHandId = this.getTemplate().rhand;
        this._currentCollisionHeight = this.getTemplate().fCollisionHeight;
        this._currentCollisionRadius = this.getTemplate().fCollisionRadius;
        DecayTaskManager.getInstance().addDecayTask(this);
        return true;
    }

    public void setSpawn(L2Spawn spawn) {
        this._spawn = spawn;
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        if (this.getTemplate().getEventQuests(Quest.QuestEventType.ON_SPAWN) != null) {
            for (Quest quest : this.getTemplate().getEventQuests(Quest.QuestEventType.ON_SPAWN)) {
                quest.notifySpawn(this);
            }
        }
    }

    @Override
    public void onDecay() {
        if (this.isDecayed()) {
            return;
        }
        this.setDecayed(true);
        super.onDecay();
        if (this._spawn != null) {
            this._spawn.decreaseCount(this);
        }
    }

    public void deleteMe() {
        L2WorldRegion oldRegion = this.getWorldRegion();
        try {
            this.decayMe();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed decayMe().", e);
        }
        try {
            if (this._fusionSkill != null) {
                this.abortCast();
            }
            for (L2Character character : this.getKnownList().getKnownCharacters()) {
                if (character.getFusionSkill() == null || character.getFusionSkill().getTarget() != this) continue;
                character.abortCast();
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        if (oldRegion != null) {
            oldRegion.removeFromZones(this);
        }
        try {
            this.getKnownList().removeAllKnownObjects();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed removing cleaning knownlist.", e);
        }
        L2World.getInstance().removeObject(this);
    }

    public L2Spawn getSpawn() {
        return this._spawn;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.getTemplate().name + "(" + this.getNpcId() + ")" + "[" + this.getObjectId() + "]";
    }

    public boolean isDecayed() {
        return this._isDecayed;
    }

    public void setDecayed(boolean decayed) {
        this._isDecayed = decayed;
    }

    public void endDecayTask() {
        if (!this.isDecayed()) {
            DecayTaskManager.getInstance().cancelDecayTask(this);
            this.onDecay();
        }
    }

    public boolean isMob() {
        return false;
    }

    public void setLHandId(int newWeaponId) {
        this._currentLHandId = newWeaponId;
        this.updateAbnormalEffect();
    }

    public void setRHandId(int newWeaponId) {
        this._currentRHandId = newWeaponId;
        this.updateAbnormalEffect();
    }

    public void setLRHandId(int newLWeaponId, int newRWeaponId) {
        this._currentRHandId = newRWeaponId;
        this._currentLHandId = newLWeaponId;
        this.updateAbnormalEffect();
    }

    public void setEnchant(int newEnchantValue) {
        this._currentEnchant = newEnchantValue;
        this.updateAbnormalEffect();
    }

    public void setCollisionHeight(double height) {
        this._currentCollisionHeight = height;
    }

    public void setCollisionRadius(double radius) {
        this._currentCollisionRadius = radius;
    }

    public double getCollisionHeight() {
        return this._currentCollisionHeight;
    }

    public double getCollisionRadius() {
        return this._currentCollisionRadius;
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (Config.CHECK_KNOWN) {
            activeChar.sendMessage("Added NPC: " + this.getName());
        }
        if (this.getRunSpeed() == 0) {
            activeChar.sendPacket(new ServerObjectInfo(this, activeChar));
        } else {
            activeChar.sendPacket(new AbstractNpcInfo.NpcInfo(this, activeChar));
        }
    }

    public void showNoTeachHtml(L2PcInstance player) {
        int npcId = this.getNpcId();
        String html = "";
        if (this instanceof L2WarehouseInstance) {
            html = HtmCache.getInstance().getHtm("data/html/warehouse/" + npcId + "-noteach.htm");
        } else if (this instanceof L2TrainerInstance) {
            html = HtmCache.getInstance().getHtm("data/html/trainer/" + npcId + "-noteach.htm");
        }
        if (html == null) {
            _log.warning("Npc " + npcId + " missing noTeach html!");
            NpcHtmlMessage msg = new NpcHtmlMessage(this.getObjectId());
            String sb = StringUtil.concat("<html><body>I cannot teach you any skills.<br>You must find your current class teachers.", "</body></html>");
            msg.setHtml(sb);
            player.sendPacket(msg);
            return;
        }
        NpcHtmlMessage noTeachMsg = new NpcHtmlMessage(this.getObjectId());
        noTeachMsg.setHtml(html);
        noTeachMsg.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
        player.sendPacket(noTeachMsg);
    }

    public L2Npc scheduleDespawn(long delay) {
        ThreadPoolManager.getInstance().scheduleGeneral(new DespawnTask(this), delay);
        return this;
    }

    @Override
    protected final void notifyQuestEventSkillFinished(L2Skill skill, L2Object target) {
        try {
            if (this.getTemplate().getEventQuests(Quest.QuestEventType.ON_SPELL_FINISHED) != null) {
                L2PcInstance player = target.getActingPlayer();
                for (Quest quest : this.getTemplate().getEventQuests(Quest.QuestEventType.ON_SPELL_FINISHED)) {
                    quest.notifySpellFinished(this, player, skill);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "", e);
        }
    }

    @Override
    public boolean isMovementDisabled() {
        return super.isMovementDisabled() || this.getCanMove() > 0 || this.getAiType().equals((Object)L2NpcTemplate.AIType.CORPSE);
    }

    public L2NpcTemplate.AIType getAiType() {
        return this.getTemplate().getAIDataStatic().getAiType();
    }

    public class DespawnTask
    implements Runnable {
        L2Npc _npc;

        public DespawnTask(L2Npc npc) {
            this._npc = npc;
        }

        @Override
        public void run() {
            if (this._npc != null) {
                this._npc.deleteMe();
            }
        }
    }

    protected class RandomAnimationTask
    implements Runnable {
        protected RandomAnimationTask() {
        }

        @Override
        public void run() {
            try {
                if (this != L2Npc.this._rAniTask) {
                    return;
                }
                if (L2Npc.this.isMob() ? L2Npc.this.getAI().getIntention() != CtrlIntention.AI_INTENTION_ACTIVE : L2Npc.this.isInActiveRegion() == false) {
                    return;
                }
                if (!(L2Npc.this.isDead() || L2Npc.this.isStunned() || L2Npc.this.isSleeping() || L2Npc.this.isParalyzed())) {
                    L2Npc.this.onRandomAnimation();
                }
                L2Npc.this.startRandomAnimationTimer();
            }
            catch (Exception e) {
                L2Character._log.log(Level.SEVERE, "", e);
            }
        }
    }
}

