/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.instancemanager.AirShipManager;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2AirShipControllerInstance
extends L2NpcInstance {
    private boolean _isBoardAllowed = false;

    public L2AirShipControllerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        AirShipManager.getInstance().registerATC(this);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.equalsIgnoreCase("board")) {
            L2AirShipInstance ship = AirShipManager.getInstance().getAirShip();
            if (player.isFlyingMounted()) {
                player.sendPacket(new SystemMessage(SystemMessageId.YOU_CANNOT_MOUNT_NOT_MEET_REQUEIREMENTS));
            } else if (ship.isInDock() && this._isBoardAllowed) {
                ship.onPlayerBoarding(player);
                return;
            }
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    public void broadcastMessage(String message) {
        this.broadcastPacket(new NpcSay(this.getObjectId(), 1, this.getNpcId(), message));
    }

    public void setIsBoardAllowed(boolean val) {
        this._isBoardAllowed = val;
    }
}

