/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.Collection;
import java.util.StringTokenizer;

public final class L2CastleTeleporterInstance
extends L2Npc {
    private boolean _currentTask = false;

    public L2CastleTeleporterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        StringTokenizer st = new StringTokenizer(command, " ");
        String actualCommand = st.nextToken();
        if (actualCommand.equalsIgnoreCase("tele")) {
            if (!this.getTask()) {
                int delay = this.getCastle().getSiege().getIsInProgress() && this.getCastle().getSiege().getControlTowerCount() == 0 ? 480000 : 30000;
                this.setTask(true);
                ThreadPoolManager.getInstance().scheduleGeneral(new oustAllPlayers(), delay);
            }
            String filename = "data/html/castleteleporter/MassGK-1.htm";
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile(filename);
            player.sendPacket(html);
            return;
        }
        super.onBypassFeedback(player, command);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        String filename = !this.getTask() ? (this.getCastle().getSiege().getIsInProgress() && this.getCastle().getSiege().getControlTowerCount() == 0 ? "data/html/castleteleporter/MassGK-2.htm" : "data/html/castleteleporter/MassGK.htm") : "data/html/castleteleporter/MassGK-1.htm";
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(filename);
        html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
        player.sendPacket(html);
    }

    void oustAllPlayers() {
        this.getCastle().oustAllPlayers();
    }

    public boolean getTask() {
        return this._currentTask;
    }

    public void setTask(boolean state) {
        this._currentTask = state;
    }

    class oustAllPlayers
    implements Runnable {
        oustAllPlayers() {
        }

        @Override
        public void run() {
            try {
                NpcSay cs = new NpcSay(L2CastleTeleporterInstance.this.getObjectId(), 1, L2CastleTeleporterInstance.this.getNpcId(), "The defenders of " + L2CastleTeleporterInstance.this.getCastle().getName() + " castle will be teleported to the inner castle.");
                int region = MapRegionTable.getInstance().getMapRegion(L2CastleTeleporterInstance.this.getX(), L2CastleTeleporterInstance.this.getY());
                Collection<L2PcInstance> pls = L2World.getInstance().getAllPlayers().values();
                for (L2PcInstance player : pls) {
                    if (region != MapRegionTable.getInstance().getMapRegion(player.getX(), player.getY())) continue;
                    player.sendPacket(cs);
                }
                L2CastleTeleporterInstance.this.oustAllPlayers();
                L2CastleTeleporterInstance.this.setTask(false);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
    }
}

