/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SortedWareHouseWithdrawalList;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.WareHouseDepositList;
import com.l2jserver.gameserver.network.serverpackets.WareHouseWithdrawalList;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2CastleWarehouseInstance
extends L2NpcInstance {
    protected static final int COND_ALL_FALSE = 0;
    protected static final int COND_BUSY_BECAUSE_OF_SIEGE = 1;
    protected static final int COND_OWNER = 2;

    public L2CastleWarehouseInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public boolean isWarehouse() {
        return true;
    }

    private void showRetrieveWindow(L2PcInstance player, SortedWareHouseWithdrawalList.WarehouseListType itemtype, byte sortorder) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        player.setActiveWarehouse(player.getWarehouse());
        if (player.getActiveWarehouse().getSize() == 0) {
            player.sendPacket(new SystemMessage(SystemMessageId.NO_ITEM_DEPOSITED_IN_WH));
            return;
        }
        if (itemtype != null) {
            player.sendPacket(new SortedWareHouseWithdrawalList(player, 1, itemtype, sortorder));
        } else {
            player.sendPacket(new WareHouseWithdrawalList(player, 1));
        }
    }

    private void showDepositWindow(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        player.setActiveWarehouse(player.getWarehouse());
        player.tempInventoryDisable();
        player.sendPacket(new WareHouseDepositList(player, 1));
    }

    private void showDepositWindowClan(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        if (player.getClan() != null) {
            if (player.getClan().getLevel() == 0) {
                player.sendPacket(new SystemMessage(SystemMessageId.ONLY_LEVEL_1_CLAN_OR_HIGHER_CAN_USE_WAREHOUSE));
            } else {
                if ((player.getClanPrivileges() & 8) != 8) {
                    player.sendPacket(new SystemMessage(SystemMessageId.ONLY_CLAN_LEADER_CAN_RETRIEVE_ITEMS_FROM_CLAN_WAREHOUSE));
                }
                player.setActiveWarehouse(player.getClan().getWarehouse());
                player.tempInventoryDisable();
                WareHouseDepositList dl = new WareHouseDepositList(player, 4);
                player.sendPacket(dl);
            }
        }
    }

    private void showWithdrawWindowClan(L2PcInstance player, SortedWareHouseWithdrawalList.WarehouseListType itemtype, byte sortorder) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        if ((player.getClanPrivileges() & 8) != 8) {
            player.sendPacket(new SystemMessage(SystemMessageId.YOU_DO_NOT_HAVE_THE_RIGHT_TO_USE_CLAN_WAREHOUSE));
            return;
        }
        if (player.getClan().getLevel() == 0) {
            player.sendPacket(new SystemMessage(SystemMessageId.ONLY_LEVEL_1_CLAN_OR_HIGHER_CAN_USE_WAREHOUSE));
        } else {
            player.setActiveWarehouse(player.getClan().getWarehouse());
            if (itemtype != null) {
                player.sendPacket(new SortedWareHouseWithdrawalList(player, 4, itemtype, sortorder));
            } else {
                player.sendPacket(new WareHouseWithdrawalList(player, 4));
            }
        }
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (player.getActiveEnchantItem() != null) {
            return;
        }
        String[] param = command.split("_");
        if (command.startsWith("WithdrawP")) {
            if (Config.L2JMOD_ENABLE_WAREHOUSESORTING_PRIVATE) {
                String htmFile = "data/html/mods/WhSortedP.htm";
                String htmContent = HtmCache.getInstance().getHtm(htmFile);
                if (htmContent != null) {
                    NpcHtmlMessage npcHtmlMessage = new NpcHtmlMessage(this.getObjectId());
                    npcHtmlMessage.setHtml(htmContent);
                    npcHtmlMessage.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
                    player.sendPacket(npcHtmlMessage);
                } else {
                    _log.warning("Missing htm: " + htmFile + "!");
                    player.sendMessage("This NPC's html is missing. Please inform the server admin.");
                }
            } else {
                this.showRetrieveWindow(player, null, (byte)0);
            }
        } else if (command.startsWith("WithdrawSortedP")) {
            if (param.length > 2) {
                this.showRetrieveWindow(player, SortedWareHouseWithdrawalList.WarehouseListType.valueOf(param[1]), SortedWareHouseWithdrawalList.getOrder(param[2]));
            } else if (param.length > 1) {
                this.showRetrieveWindow(player, SortedWareHouseWithdrawalList.WarehouseListType.valueOf(param[1]), (byte)1);
            } else {
                this.showRetrieveWindow(player, SortedWareHouseWithdrawalList.WarehouseListType.ALL, (byte)1);
            }
        } else if (command.equals("DepositP")) {
            this.showDepositWindow(player);
        } else if (command.equals("WithdrawC")) {
            if (Config.L2JMOD_ENABLE_WAREHOUSESORTING_CLAN) {
                String htmFile = "data/html/mods/WhSortedC.htm";
                String htmContent = HtmCache.getInstance().getHtm(htmFile);
                if (htmContent != null) {
                    NpcHtmlMessage npcHtmlMessage = new NpcHtmlMessage(this.getObjectId());
                    npcHtmlMessage.setHtml(htmContent);
                    npcHtmlMessage.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
                    player.sendPacket(npcHtmlMessage);
                } else {
                    _log.warning("Missing htm: " + htmFile + "!");
                    player.sendMessage("This NPC's html is missing. Please inform the server admin.");
                }
            } else {
                this.showWithdrawWindowClan(player, null, (byte)0);
            }
        } else if (command.startsWith("WithdrawSortedC")) {
            if (param.length > 2) {
                this.showWithdrawWindowClan(player, SortedWareHouseWithdrawalList.WarehouseListType.valueOf(param[1]), SortedWareHouseWithdrawalList.getOrder(param[2]));
            } else if (param.length > 1) {
                this.showWithdrawWindowClan(player, SortedWareHouseWithdrawalList.WarehouseListType.valueOf(param[1]), (byte)1);
            } else {
                this.showWithdrawWindowClan(player, SortedWareHouseWithdrawalList.WarehouseListType.ALL, (byte)1);
            }
        } else if (command.equals("DepositC")) {
            this.showDepositWindowClan(player);
        } else if (command.startsWith("Chat")) {
            int val = 0;
            try {
                val = Integer.parseInt(command.substring(5));
            }
            catch (IndexOutOfBoundsException ioobe) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.showChatWindow(player, val);
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    @Override
    public void showChatWindow(L2PcInstance player, int val) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        String filename = "data/html/castlewarehouse/castlewarehouse-no.htm";
        int condition = this.validateCondition(player);
        if (condition > 0) {
            if (condition == 1) {
                filename = "data/html/castlewarehouse/castlewarehouse-busy.htm";
            } else if (condition == 2) {
                filename = val == 0 ? "data/html/castlewarehouse/castlewarehouse.htm" : "data/html/castlewarehouse/castlewarehouse-" + val + ".htm";
            }
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(filename);
        html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }

    protected int validateCondition(L2PcInstance player) {
        if (player.isGM()) {
            return 2;
        }
        if (this.getCastle() != null && this.getCastle().getCastleId() > 0 && player.getClan() != null) {
            if (this.getCastle().getSiege().getIsInProgress()) {
                return 1;
            }
            if (this.getCastle().getOwnerId() == player.getClanId()) {
                return 2;
            }
        }
        return 0;
    }
}

