/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.handler.ISkillHandler;
import com.l2jserver.gameserver.handler.SkillHandler;
import com.l2jserver.gameserver.instancemanager.DuelManager;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.model.entity.TvTEventTeam;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Formulas;
import com.l2jserver.gameserver.skills.l2skills.L2SkillDrain;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import com.l2jserver.util.Rnd;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class L2CubicInstance {
    protected static final Logger _log = Logger.getLogger(L2CubicInstance.class.getName());
    public static final int STORM_CUBIC = 1;
    public static final int VAMPIRIC_CUBIC = 2;
    public static final int LIFE_CUBIC = 3;
    public static final int VIPER_CUBIC = 4;
    public static final int POLTERGEIST_CUBIC = 5;
    public static final int BINDING_CUBIC = 6;
    public static final int AQUA_CUBIC = 7;
    public static final int SPARK_CUBIC = 8;
    public static final int ATTRACT_CUBIC = 9;
    public static final int SMART_CUBIC_EVATEMPLAR = 10;
    public static final int SMART_CUBIC_SHILLIENTEMPLAR = 11;
    public static final int SMART_CUBIC_ARCANALORD = 12;
    public static final int SMART_CUBIC_ELEMENTALMASTER = 13;
    public static final int SMART_CUBIC_SPECTRALMASTER = 14;
    public static final int MAX_MAGIC_RANGE = 900;
    public static final int SKILL_CUBIC_HEAL = 4051;
    public static final int SKILL_CUBIC_CURE = 5579;
    protected L2PcInstance _owner;
    protected L2Character _target;
    protected int _id;
    protected int _matk;
    protected int _activationtime;
    protected int _activationchance;
    protected boolean _active;
    private boolean _givenByOther;
    protected List<L2Skill> _skills = new FastList();
    private Future<?> _disappearTask;
    private Future<?> _actionTask;

    public L2CubicInstance(L2PcInstance owner, int id, int level, int mAtk, int activationtime, int activationchance, int totallifetime, boolean givenByOther) {
        this._owner = owner;
        this._id = id;
        this._matk = mAtk;
        this._activationtime = activationtime * 1000;
        this._activationchance = activationchance;
        this._active = false;
        this._givenByOther = givenByOther;
        switch (this._id) {
            case 1: {
                this._skills.add(SkillTable.getInstance().getInfo(4049, level));
                break;
            }
            case 2: {
                this._skills.add(SkillTable.getInstance().getInfo(4050, level));
                break;
            }
            case 3: {
                this._skills.add(SkillTable.getInstance().getInfo(4051, level));
                this.doAction();
                break;
            }
            case 4: {
                this._skills.add(SkillTable.getInstance().getInfo(4052, level));
                break;
            }
            case 5: {
                this._skills.add(SkillTable.getInstance().getInfo(4053, level));
                this._skills.add(SkillTable.getInstance().getInfo(4054, level));
                this._skills.add(SkillTable.getInstance().getInfo(4055, level));
                break;
            }
            case 6: {
                this._skills.add(SkillTable.getInstance().getInfo(4164, level));
                break;
            }
            case 7: {
                this._skills.add(SkillTable.getInstance().getInfo(4165, level));
                break;
            }
            case 8: {
                this._skills.add(SkillTable.getInstance().getInfo(4166, level));
                break;
            }
            case 9: {
                this._skills.add(SkillTable.getInstance().getInfo(5115, level));
                this._skills.add(SkillTable.getInstance().getInfo(5116, level));
                break;
            }
            case 12: {
                this._skills.add(SkillTable.getInstance().getInfo(4051, 7));
                this._skills.add(SkillTable.getInstance().getInfo(4165, 9));
                break;
            }
            case 13: {
                this._skills.add(SkillTable.getInstance().getInfo(4049, 8));
                this._skills.add(SkillTable.getInstance().getInfo(4166, 9));
                break;
            }
            case 14: {
                this._skills.add(SkillTable.getInstance().getInfo(4049, 8));
                this._skills.add(SkillTable.getInstance().getInfo(4052, 6));
                break;
            }
            case 10: {
                this._skills.add(SkillTable.getInstance().getInfo(4053, 8));
                this._skills.add(SkillTable.getInstance().getInfo(4165, 9));
                break;
            }
            case 11: {
                this._skills.add(SkillTable.getInstance().getInfo(4049, 8));
                this._skills.add(SkillTable.getInstance().getInfo(5115, 4));
            }
        }
        this._disappearTask = ThreadPoolManager.getInstance().scheduleGeneral(new Disappear(), totallifetime);
    }

    public synchronized void doAction() {
        if (this._active) {
            return;
        }
        this._active = true;
        switch (this._id) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this._actionTask = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new Action(this._activationchance), 0L, this._activationtime);
                break;
            }
            case 3: {
                this._actionTask = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new Heal(), 0L, this._activationtime);
            }
        }
    }

    public int getId() {
        return this._id;
    }

    public L2PcInstance getOwner() {
        return this._owner;
    }

    public final int getMCriticalHit(L2Character target, L2Skill skill) {
        return this._owner.getTemplate().baseMCritRate;
    }

    public int getMAtk() {
        return this._matk;
    }

    public void stopAction() {
        this._target = null;
        if (this._actionTask != null) {
            this._actionTask.cancel(true);
            this._actionTask = null;
        }
        this._active = false;
    }

    public void cancelDisappear() {
        if (this._disappearTask != null) {
            this._disappearTask.cancel(true);
            this._disappearTask = null;
        }
    }

    public void getCubicTarget() {
        try {
            this._target = null;
            L2Object ownerTarget = this._owner.getTarget();
            if (ownerTarget == null) {
                return;
            }
            if (TvTEvent.isStarted() && TvTEvent.isPlayerParticipant(this._owner.getObjectId())) {
                L2PcInstance target;
                TvTEventTeam enemyTeam = TvTEvent.getParticipantEnemyTeam(this._owner.getObjectId());
                if (ownerTarget.getActingPlayer() != null && enemyTeam.containsPlayer((target = ownerTarget.getActingPlayer()).getObjectId()) && !target.isDead()) {
                    this._target = (L2Character)ownerTarget;
                }
                return;
            }
            if (this._owner.isInDuel()) {
                L2PcInstance PlayerA = DuelManager.getInstance().getDuel(this._owner.getDuelId()).getPlayerA();
                L2PcInstance PlayerB = DuelManager.getInstance().getDuel(this._owner.getDuelId()).getPlayerB();
                if (DuelManager.getInstance().getDuel(this._owner.getDuelId()).isPartyDuel()) {
                    L2Party partyA = PlayerA.getParty();
                    L2Party partyB = PlayerB.getParty();
                    L2Party partyEnemy = null;
                    if (partyA != null) {
                        if (partyA.getPartyMembers().contains((Object)this._owner)) {
                            if (partyB != null) {
                                partyEnemy = partyB;
                            } else {
                                this._target = PlayerB;
                            }
                        } else {
                            partyEnemy = partyA;
                        }
                    } else if (PlayerA == this._owner) {
                        if (partyB != null) {
                            partyEnemy = partyB;
                        } else {
                            this._target = PlayerB;
                        }
                    } else {
                        this._target = PlayerA;
                    }
                    if ((this._target == PlayerA || this._target == PlayerB) && this._target == ownerTarget) {
                        return;
                    }
                    if (partyEnemy != null) {
                        if (partyEnemy.getPartyMembers().contains((Object)ownerTarget)) {
                            this._target = (L2Character)ownerTarget;
                        }
                        return;
                    }
                }
                if (PlayerA != this._owner && ownerTarget == PlayerA) {
                    this._target = PlayerA;
                    return;
                }
                if (PlayerB != this._owner && ownerTarget == PlayerB) {
                    this._target = PlayerB;
                    return;
                }
                this._target = null;
                return;
            }
            if (this._owner.isInOlympiadMode()) {
                L2PcInstance[] players;
                if (this._owner.isOlympiadStart() && (players = Olympiad.getInstance().getPlayers(this._owner.getOlympiadGameId())) != null) {
                    if (this._owner.getOlympiadSide() == 1) {
                        if (ownerTarget == players[1]) {
                            this._target = players[1];
                        } else if (players[1].getPet() != null && ownerTarget == players[1].getPet()) {
                            this._target = players[1].getPet();
                        }
                    } else if (ownerTarget == players[0]) {
                        this._target = players[0];
                    } else if (players[0].getPet() != null && ownerTarget == players[0].getPet()) {
                        this._target = players[0].getPet();
                    }
                }
                return;
            }
            if (ownerTarget instanceof L2Character && ownerTarget != this._owner.getPet() && ownerTarget != this._owner) {
                if (ownerTarget instanceof L2Attackable) {
                    if (((L2Attackable)ownerTarget).getAggroList().get((Object)this._owner) != null && !((L2Attackable)ownerTarget).isDead()) {
                        this._target = (L2Character)ownerTarget;
                        return;
                    }
                    if (this._owner.getPet() != null && ((L2Attackable)ownerTarget).getAggroList().get((Object)this._owner.getPet()) != null && !((L2Attackable)ownerTarget).isDead()) {
                        this._target = (L2Character)ownerTarget;
                        return;
                    }
                }
                L2PcInstance enemy = null;
                if (this._owner.getPvpFlag() > 0 && !this._owner.isInsideZone((byte)1) || this._owner.isInsideZone((byte)0)) {
                    if (ownerTarget instanceof L2Character && !((L2Character)ownerTarget).isDead()) {
                        enemy = ownerTarget.getActingPlayer();
                    }
                    if (enemy != null) {
                        boolean targetIt = true;
                        if (this._owner.getParty() != null) {
                            if (this._owner.getParty().getPartyMembers().contains((Object)enemy)) {
                                targetIt = false;
                            } else if (this._owner.getParty().getCommandChannel() != null && this._owner.getParty().getCommandChannel().getMembers().contains(enemy)) {
                                targetIt = false;
                            }
                        }
                        if (this._owner.getClan() != null && !this._owner.isInsideZone((byte)0)) {
                            if (this._owner.getClan().isMember(enemy.getObjectId())) {
                                targetIt = false;
                            }
                            if (this._owner.getAllyId() > 0 && enemy.getAllyId() > 0 && this._owner.getAllyId() == enemy.getAllyId()) {
                                targetIt = false;
                            }
                        }
                        if (enemy.getPvpFlag() == 0 && !enemy.isInsideZone((byte)0)) {
                            targetIt = false;
                        }
                        if (enemy.isInsideZone((byte)1)) {
                            targetIt = false;
                        }
                        if (this._owner.getSiegeState() > 0 && this._owner.getSiegeState() == enemy.getSiegeState()) {
                            targetIt = false;
                        }
                        if (!enemy.isVisible()) {
                            targetIt = false;
                        }
                        if (targetIt) {
                            this._target = enemy;
                            return;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "", e);
        }
    }

    public void useCubicContinuous(L2CubicInstance activeCubic, L2Skill skill, L2Object[] targets) {
        for (L2Character target : (L2Character[])targets) {
            byte shld;
            boolean acted;
            if (target == null || target.isDead()) continue;
            if (skill.isOffensive() && !(acted = Formulas.calcCubicSkillSuccess(activeCubic, target, skill, shld = Formulas.calcShldUse(activeCubic.getOwner(), target, skill)))) {
                activeCubic.getOwner().sendPacket(new SystemMessage(SystemMessageId.ATTACK_FAILED));
                continue;
            }
            if (target instanceof L2PcInstance && ((L2PcInstance)target).isInDuel() && skill.getSkillType() == L2SkillType.DEBUFF && activeCubic.getOwner().getDuelId() == ((L2PcInstance)target).getDuelId()) {
                DuelManager dm = DuelManager.getInstance();
                for (L2Effect debuff : skill.getEffects(activeCubic.getOwner(), target)) {
                    if (debuff == null) continue;
                    dm.onBuff((L2PcInstance)target, debuff);
                }
                continue;
            }
            skill.getEffects(activeCubic, target, null);
        }
    }

    public void useCubicMdam(L2CubicInstance activeCubic, L2Skill skill, L2Object[] targets) {
        for (L2Character target : (L2Character[])targets) {
            if (target == null) continue;
            if (target.isAlikeDead()) {
                if (!(target instanceof L2PcInstance)) continue;
                target.stopFakeDeath(null);
            }
            boolean mcrit = Formulas.calcMCrit(activeCubic.getMCriticalHit(target, skill));
            byte shld = Formulas.calcShldUse(activeCubic.getOwner(), target, skill);
            int damage = (int)Formulas.calcMagicDam(activeCubic, target, skill, mcrit, shld);
            if ((Formulas.calcSkillReflect(target, skill) & 1) > 0) {
                damage = 0;
            }
            if (Config.DEBUG) {
                _log.info("L2SkillMdam: useCubicSkill() -> damage = " + damage);
            }
            if (damage <= 0) continue;
            if (!target.isRaid() && Formulas.calcAtkBreak(target, damage)) {
                target.breakAttack();
                target.breakCast();
            }
            activeCubic.getOwner().sendDamageMessage(target, damage, mcrit, false, false);
            if (skill.hasEffects()) {
                target.stopSkillEffects(skill.getId());
                if (target.getFirstEffect(skill) != null) {
                    target.removeEffect(target.getFirstEffect(skill));
                }
                if (Formulas.calcCubicSkillSuccess(activeCubic, target, skill, shld)) {
                    skill.getEffects(activeCubic, target, null);
                }
            }
            target.reduceCurrentHp(damage, activeCubic.getOwner(), skill);
        }
    }

    public void useCubicDisabler(L2SkillType type, L2CubicInstance activeCubic, L2Skill skill, L2Object[] targets) {
        if (Config.DEBUG) {
            _log.info("Disablers: useCubicSkill()");
        }
        block7: for (L2Character target : (L2Character[])targets) {
            if (target == null || target.isDead()) continue;
            byte shld = Formulas.calcShldUse(activeCubic.getOwner(), target, skill);
            switch (type) {
                case STUN: {
                    int i$;
                    DuelManager dm;
                    if (Formulas.calcCubicSkillSuccess(activeCubic, target, skill, shld)) {
                        if (target instanceof L2PcInstance && ((L2PcInstance)target).isInDuel() && skill.getSkillType() == L2SkillType.DEBUFF && activeCubic.getOwner().getDuelId() == ((L2PcInstance)target).getDuelId()) {
                            dm = DuelManager.getInstance();
                            L2Effect[] arr$ = skill.getEffects(activeCubic.getOwner(), target);
                            int len$ = arr$.length;
                            for (i$ = 0; i$ < len$; ++i$) {
                                L2Effect debuff = arr$[i$];
                                if (debuff == null) continue;
                                dm.onBuff((L2PcInstance)target, debuff);
                            }
                        } else {
                            skill.getEffects(activeCubic, target, null);
                        }
                        if (!Config.DEBUG) continue block7;
                        _log.info("Disablers: useCubicSkill() -> success");
                        continue block7;
                    }
                    if (!Config.DEBUG) continue block7;
                    _log.info("Disablers: useCubicSkill() -> failed");
                    continue block7;
                }
                case PARALYZE: {
                    int i$;
                    DuelManager dm;
                    if (Formulas.calcCubicSkillSuccess(activeCubic, target, skill, shld)) {
                        if (target instanceof L2PcInstance && ((L2PcInstance)target).isInDuel() && skill.getSkillType() == L2SkillType.DEBUFF && activeCubic.getOwner().getDuelId() == ((L2PcInstance)target).getDuelId()) {
                            dm = DuelManager.getInstance();
                            L2Effect[] arr$ = skill.getEffects(activeCubic.getOwner(), target);
                            int len$ = arr$.length;
                            for (i$ = 0; i$ < len$; ++i$) {
                                L2Effect debuff = arr$[i$];
                                if (debuff == null) continue;
                                dm.onBuff((L2PcInstance)target, debuff);
                            }
                        } else {
                            skill.getEffects(activeCubic, target, null);
                        }
                        if (!Config.DEBUG) continue block7;
                        _log.info("Disablers: useCubicSkill() -> success");
                        continue block7;
                    }
                    if (!Config.DEBUG) continue block7;
                    _log.info("Disablers: useCubicSkill() -> failed");
                    continue block7;
                }
                case CANCEL_DEBUFF: {
                    L2Effect[] effects = target.getAllEffects();
                    if (effects == null || effects.length == 0) continue block7;
                    int count = skill.getMaxNegatedEffects() > 0 ? 0 : -2;
                    for (L2Effect e : effects) {
                        if (!e.getSkill().isDebuff() || count >= skill.getMaxNegatedEffects() || e.getSkill().getId() == 4215 || e.getSkill().getId() == 4515 || e.getSkill().getId() == 4082) continue;
                        e.exit();
                        if (count <= -1) continue;
                        ++count;
                    }
                    continue block7;
                }
                case ROOT: {
                    int i$;
                    DuelManager dm;
                    if (Formulas.calcCubicSkillSuccess(activeCubic, target, skill, shld)) {
                        if (target instanceof L2PcInstance && ((L2PcInstance)target).isInDuel() && skill.getSkillType() == L2SkillType.DEBUFF && activeCubic.getOwner().getDuelId() == ((L2PcInstance)target).getDuelId()) {
                            dm = DuelManager.getInstance();
                            L2Effect[] arr$ = skill.getEffects(activeCubic.getOwner(), target);
                            int len$ = arr$.length;
                            for (i$ = 0; i$ < len$; ++i$) {
                                L2Effect debuff = arr$[i$];
                                if (debuff == null) continue;
                                dm.onBuff((L2PcInstance)target, debuff);
                            }
                        } else {
                            skill.getEffects(activeCubic, target, null);
                        }
                        if (!Config.DEBUG) continue block7;
                        _log.info("Disablers: useCubicSkill() -> success");
                        continue block7;
                    }
                    if (!Config.DEBUG) continue block7;
                    _log.info("Disablers: useCubicSkill() -> failed");
                    continue block7;
                }
                case AGGDAMAGE: {
                    if (Formulas.calcCubicSkillSuccess(activeCubic, target, skill, shld)) {
                        if (target instanceof L2Attackable) {
                            target.getAI().notifyEvent(CtrlEvent.EVT_AGGRESSION, activeCubic.getOwner(), (int)(150.0 * skill.getPower() / (double)(target.getLevel() + 7)));
                        }
                        skill.getEffects(activeCubic, target, null);
                        if (!Config.DEBUG) continue block7;
                        _log.info("Disablers: useCubicSkill() -> success");
                        continue block7;
                    }
                    if (!Config.DEBUG) continue block7;
                    _log.info("Disablers: useCubicSkill() -> failed");
                }
            }
        }
    }

    public boolean isInCubicRange(L2Character owner, L2Character target) {
        int z;
        int y;
        if (owner == null || target == null) {
            return false;
        }
        int range = 900;
        int x = owner.getX() - target.getX();
        return x * x + (y = owner.getY() - target.getY()) * y + (z = owner.getZ() - target.getZ()) * z <= range * range;
    }

    public void CubicTargetForHeal() {
        L2Playable target = null;
        double percentleft = 100.0;
        L2Party party = this._owner.getParty();
        if (this._owner.isInDuel() && !DuelManager.getInstance().getDuel(this._owner.getDuelId()).isPartyDuel()) {
            party = null;
        }
        if (party != null && !this._owner.isInOlympiadMode()) {
            FastList<L2PcInstance> partyList = party.getPartyMembers();
            for (L2PcInstance partyMember : partyList) {
                if (!partyMember.isDead() && this.isInCubicRange(this._owner, partyMember) && partyMember.getCurrentHp() < (double)partyMember.getMaxHp() && percentleft > partyMember.getCurrentHp() / (double)partyMember.getMaxHp()) {
                    percentleft = partyMember.getCurrentHp() / (double)partyMember.getMaxHp();
                    target = partyMember;
                }
                if (((L2Character)partyMember).getPet() == null || ((L2Character)partyMember).getPet().isDead() || !this.isInCubicRange(this._owner, ((L2Character)partyMember).getPet()) || !(((L2Character)partyMember).getPet().getCurrentHp() < (double)((L2Character)partyMember).getPet().getMaxHp()) || !(percentleft > ((L2Character)partyMember).getPet().getCurrentHp() / (double)((L2Character)partyMember).getPet().getMaxHp())) continue;
                percentleft = ((L2Character)partyMember).getPet().getCurrentHp() / (double)((L2Character)partyMember).getPet().getMaxHp();
                target = ((L2Character)partyMember).getPet();
            }
        } else {
            if (this._owner.getCurrentHp() < (double)this._owner.getMaxHp()) {
                percentleft = this._owner.getCurrentHp() / (double)this._owner.getMaxHp();
                target = this._owner;
            }
            if (this._owner.getPet() != null && !this._owner.getPet().isDead() && this._owner.getPet().getCurrentHp() < (double)this._owner.getPet().getMaxHp() && percentleft > this._owner.getPet().getCurrentHp() / (double)this._owner.getPet().getMaxHp() && this.isInCubicRange(this._owner, this._owner.getPet())) {
                target = this._owner.getPet();
            }
        }
        this._target = target;
    }

    public boolean givenByOther() {
        return this._givenByOther;
    }

    private class Disappear
    implements Runnable {
        Disappear() {
        }

        @Override
        public void run() {
            L2CubicInstance.this.stopAction();
            L2CubicInstance.this._owner.delCubic(L2CubicInstance.this._id);
            L2CubicInstance.this._owner.broadcastUserInfo();
        }
    }

    private class Heal
    implements Runnable {
        Heal() {
        }

        @Override
        public void run() {
            if (L2CubicInstance.this._owner.isDead() && L2CubicInstance.this._owner.isOnline() == 0) {
                L2CubicInstance.this.stopAction();
                L2CubicInstance.this._owner.delCubic(L2CubicInstance.this._id);
                L2CubicInstance.this._owner.broadcastUserInfo();
                L2CubicInstance.this.cancelDisappear();
                return;
            }
            try {
                L2Skill skill = null;
                for (L2Skill sk : L2CubicInstance.this._skills) {
                    if (sk.getId() != 4051) continue;
                    skill = sk;
                    break;
                }
                if (skill != null) {
                    L2CubicInstance.this.CubicTargetForHeal();
                    L2Character target = L2CubicInstance.this._target;
                    if (target != null && !target.isDead() && (double)target.getMaxHp() - target.getCurrentHp() > skill.getPower()) {
                        L2Object[] targets = new L2Character[]{target};
                        ISkillHandler handler = SkillHandler.getInstance().getSkillHandler(skill.getSkillType());
                        if (handler != null) {
                            handler.useSkill(L2CubicInstance.this._owner, skill, targets);
                        } else {
                            skill.useSkill(L2CubicInstance.this._owner, targets);
                        }
                        MagicSkillUse msu = new MagicSkillUse(L2CubicInstance.this._owner, target, skill.getId(), skill.getLevel(), 0, 0);
                        L2CubicInstance.this._owner.broadcastPacket(msu);
                    }
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    private class Action
    implements Runnable {
        private int _chance;

        Action(int chance) {
            this._chance = chance;
        }

        @Override
        public void run() {
            try {
                if (L2CubicInstance.this._owner.isDead() || L2CubicInstance.this._owner.isOnline() == 0) {
                    L2CubicInstance.this.stopAction();
                    L2CubicInstance.this._owner.delCubic(L2CubicInstance.this._id);
                    L2CubicInstance.this._owner.broadcastUserInfo();
                    L2CubicInstance.this.cancelDisappear();
                    return;
                }
                if (!AttackStanceTaskManager.getInstance().getAttackStanceTask(L2CubicInstance.this._owner)) {
                    if (L2CubicInstance.this._owner.getPet() != null) {
                        if (!AttackStanceTaskManager.getInstance().getAttackStanceTask(L2CubicInstance.this._owner.getPet())) {
                            L2CubicInstance.this.stopAction();
                            return;
                        }
                    } else {
                        L2CubicInstance.this.stopAction();
                        return;
                    }
                }
                boolean UseCubicCure = false;
                L2Skill skill = null;
                if (L2CubicInstance.this._id >= 10 && L2CubicInstance.this._id <= 14) {
                    L2Effect[] effects;
                    for (L2Effect e : effects = L2CubicInstance.this._owner.getAllEffects()) {
                        if (e == null || !e.getSkill().isDebuff()) continue;
                        UseCubicCure = true;
                        e.exit();
                    }
                }
                if (UseCubicCure) {
                    MagicSkillUse msu = new MagicSkillUse(L2CubicInstance.this._owner, L2CubicInstance.this._owner, 5579, 1, 0, 0);
                    L2CubicInstance.this._owner.broadcastPacket(msu);
                } else if (Rnd.get(1, 100) < this._chance && (skill = L2CubicInstance.this._skills.get(Rnd.get(L2CubicInstance.this._skills.size()))) != null) {
                    if (skill.getId() == 4051) {
                        L2CubicInstance.this.CubicTargetForHeal();
                    } else {
                        L2CubicInstance.this.getCubicTarget();
                        if (!L2CubicInstance.this.isInCubicRange(L2CubicInstance.this._owner, L2CubicInstance.this._target)) {
                            L2CubicInstance.this._target = null;
                        }
                    }
                    L2Character target = L2CubicInstance.this._target;
                    if (target != null && !target.isDead()) {
                        if (Config.DEBUG) {
                            _log.info("L2CubicInstance: Action.run();");
                            _log.info("Cubic Id: " + L2CubicInstance.this._id + " Target: " + target.getName() + " distance: " + Math.sqrt(target.getDistanceSq(L2CubicInstance.this._owner.getX(), L2CubicInstance.this._owner.getY(), L2CubicInstance.this._owner.getZ())));
                        }
                        L2CubicInstance.this._owner.broadcastPacket(new MagicSkillUse(L2CubicInstance.this._owner, target, skill.getId(), skill.getLevel(), 0, 0));
                        L2SkillType type = skill.getSkillType();
                        ISkillHandler handler = SkillHandler.getInstance().getSkillHandler(skill.getSkillType());
                        L2Object[] targets = new L2Character[]{target};
                        if (type == L2SkillType.PARALYZE || type == L2SkillType.STUN || type == L2SkillType.ROOT || type == L2SkillType.AGGDAMAGE) {
                            if (Config.DEBUG) {
                                _log.info("L2CubicInstance: Action.run() handler " + (Object)((Object)type));
                            }
                            L2CubicInstance.this.useCubicDisabler(type, L2CubicInstance.this, skill, targets);
                        } else if (type == L2SkillType.MDAM) {
                            if (Config.DEBUG) {
                                _log.info("L2CubicInstance: Action.run() handler " + (Object)((Object)type));
                            }
                            L2CubicInstance.this.useCubicMdam(L2CubicInstance.this, skill, targets);
                        } else if (type == L2SkillType.POISON || type == L2SkillType.DEBUFF || type == L2SkillType.DOT) {
                            if (Config.DEBUG) {
                                _log.info("L2CubicInstance: Action.run() handler " + (Object)((Object)type));
                            }
                            L2CubicInstance.this.useCubicContinuous(L2CubicInstance.this, skill, targets);
                        } else if (type == L2SkillType.DRAIN) {
                            if (Config.DEBUG) {
                                _log.info("L2CubicInstance: Action.run() skill " + (Object)((Object)type));
                            }
                            ((L2SkillDrain)skill).useCubicSkill(L2CubicInstance.this, targets);
                        } else {
                            handler.useSkill(L2CubicInstance.this._owner, skill, targets);
                            if (Config.DEBUG) {
                                _log.info("L2CubicInstance: Action.run(); other handler");
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }
}

