/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ai.L2AttackableAI;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2MinionInstance
extends L2MonsterInstance {
    private L2MonsterInstance _master;

    public L2MinionInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    public L2MonsterInstance getLeader() {
        return this._master;
    }

    @Override
    public void onSpawn() {
        L2WorldRegion region;
        this.setIsNoRndWalk(true);
        if (this.getLeader() != null) {
            if (this.getLeader().isRaid()) {
                this.setChampion(false);
                this.setIsRaidMinion(true);
            }
            this.getLeader().notifyMinionSpawned(this);
        }
        if ((region = L2World.getInstance().getRegion(this.getX(), this.getY())) != null && !region.isActive().booleanValue()) {
            ((L2AttackableAI)this.getAI()).stopAITask();
        }
        super.onSpawn();
    }

    public void setLeader(L2MonsterInstance leader) {
        this._master = leader;
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (this.getLeader() != null) {
            this.getLeader().notifyMinionDied(this);
        }
        return true;
    }

    @Override
    public float getVitalityPoints(int damage) {
        return 0.0f;
    }
}

