/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.status.SiegeFlagStatus;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2SiegeFlagInstance
extends L2Npc {
    private L2Clan _clan;
    private L2PcInstance _player;
    private Siege _siege;
    private final boolean _isAdvanced;
    private boolean _canTalk;

    public L2SiegeFlagInstance(L2PcInstance player, int objectId, L2NpcTemplate template, boolean advanced) {
        super(objectId, template);
        this._clan = player.getClan();
        this._player = player;
        this._canTalk = true;
        this._siege = SiegeManager.getInstance().getSiege(this._player.getX(), this._player.getY(), this._player.getZ());
        if (this._clan == null || this._siege == null) {
            this.deleteMe();
        } else {
            L2SiegeClan sc = this._siege.getAttackerClan(this._clan);
            if (sc == null) {
                this.deleteMe();
            } else {
                sc.addFlag(this);
            }
        }
        this._isAdvanced = advanced;
        this.getStatus();
        this.setIsInvul(false);
    }

    @Deprecated
    public L2SiegeFlagInstance(L2PcInstance player, int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this._isAdvanced = false;
    }

    @Override
    public boolean isAttackable() {
        return true;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return true;
    }

    @Override
    public boolean doDie(L2Character killer) {
        L2SiegeClan sc;
        if (!super.doDie(killer)) {
            return false;
        }
        if (this._siege != null && this._clan != null && (sc = this._siege.getAttackerClan(this._clan)) != null) {
            sc.removeFlag(this);
        }
        return true;
    }

    @Override
    public void onForcedAttack(L2PcInstance player) {
        this.onAction(player);
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (player == null || !this.canTarget(player)) {
            return;
        }
        if (this != player.getTarget()) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            StatusUpdate su = new StatusUpdate(this.getObjectId());
            su.addAttribute(9, (int)this.getStatus().getCurrentHp());
            su.addAttribute(10, this.getMaxHp());
            player.sendPacket(su);
            player.sendPacket(new ValidateLocation(this));
        } else if (interact) {
            if (this.isAutoAttackable(player) && Math.abs(player.getZ() - this.getZ()) < 100) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
            } else {
                player.sendPacket(ActionFailed.STATIC_PACKET);
            }
        }
    }

    public boolean isAdvancedHeadquarter() {
        return this._isAdvanced;
    }

    @Override
    public SiegeFlagStatus getStatus() {
        return (SiegeFlagStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new SiegeFlagStatus(this));
    }

    @Override
    public void reduceCurrentHp(double damage, L2Character attacker, L2Skill skill) {
        super.reduceCurrentHp(damage, attacker, skill);
        if (this.canTalk()) {
            if (this.getCastle() != null && this.getCastle().getSiege().getIsInProgress()) {
                if (this._clan != null) {
                    this._clan.broadcastToOnlineMembers(new SystemMessage(SystemMessageId.BASE_UNDER_ATTACK));
                    this.setCanTalk(false);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleTalkTask(), 20000L);
                }
            } else if (this.getFort() != null && this.getFort().getSiege().getIsInProgress() && this._clan != null) {
                this._clan.broadcastToOnlineMembers(new SystemMessage(SystemMessageId.BASE_UNDER_ATTACK));
                this.setCanTalk(false);
                ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleTalkTask(), 20000L);
            }
        }
    }

    void setCanTalk(boolean val) {
        this._canTalk = val;
    }

    private boolean canTalk() {
        return this._canTalk;
    }

    private class ScheduleTalkTask
    implements Runnable {
        @Override
        public void run() {
            L2SiegeFlagInstance.this.setCanTalk(true);
        }
    }
}

