/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreeTable;
import com.l2jserver.gameserver.model.L2Multisell;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2TransformSkillLearn;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillList;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2TransformManagerInstance
extends L2MerchantInstance {
    public L2TransformManagerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/default/", npcId, val);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("TransformSkillList")) {
            if (L2TransformManagerInstance.canTransform(player)) {
                player.setSkillLearningClassId(player.getClassId());
                this.showTransformSkillList(player);
            } else {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile("data/html/default/" + this.getNpcId() + "-cantlearn.htm");
                player.sendPacket(html);
            }
        } else if (command.startsWith("BuyTransform")) {
            if (L2TransformManagerInstance.canTransform(player)) {
                L2Multisell.getInstance().separateAndSend(32323001, player, this.getNpcId(), false, this.getCastle().getTaxRate());
            } else {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile("data/html/default/" + this.getNpcId() + "-cantbuy.htm");
                player.sendPacket(html);
            }
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    public static boolean canTransform(L2PcInstance player) {
        QuestState st = player.getQuestState("136_MoreThanMeetsTheEye");
        return st != null && st.getState() == 2;
    }

    public void showTransformSkillList(L2PcInstance player) {
        L2TransformSkillLearn[] skills = SkillTreeTable.getInstance().getAvailableTransformSkills(player);
        AcquireSkillList asl = new AcquireSkillList(AcquireSkillList.SkillType.Usual);
        int counts = 0;
        for (L2TransformSkillLearn s : skills) {
            L2Skill sk = SkillTable.getInstance().getInfo(s.getId(), s.getLevel());
            if (sk == null) continue;
            ++counts;
            asl.addSkill(s.getId(), s.getLevel(), s.getLevel(), s.getSpCost(), 0);
        }
        if (counts == 0) {
            int minlevel = SkillTreeTable.getInstance().getMinLevelForNewTransformSkill(player);
            if (minlevel > 0) {
                SystemMessage sm = new SystemMessage(SystemMessageId.DO_NOT_HAVE_FURTHER_SKILLS_TO_LEARN);
                sm.addNumber(minlevel);
                player.sendPacket(sm);
            } else {
                player.sendPacket(new SystemMessage(SystemMessageId.NO_MORE_SKILLS_TO_LEARN));
            }
        } else {
            player.sendPacket(asl);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }
}

