/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2TvTEventNpcInstance
extends L2Npc {
    private static final String htmlPath = "data/html/mods/TvTEvent/";

    public L2TvTEventNpcInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public void onBypassFeedback(L2PcInstance playerInstance, String command) {
        TvTEvent.onBypass(command, playerInstance);
    }

    @Override
    public void showChatWindow(L2PcInstance playerInstance, int val) {
        String htmContent;
        if (playerInstance == null) {
            return;
        }
        if (TvTEvent.isParticipating()) {
            boolean isParticipant = TvTEvent.isPlayerParticipant(playerInstance.getObjectId());
            String htmContent2 = !isParticipant ? HtmCache.getInstance().getHtm("data/html/mods/TvTEvent/Participation.htm") : HtmCache.getInstance().getHtm("data/html/mods/TvTEvent/RemoveParticipation.htm");
            if (htmContent2 != null) {
                int[] teamsPlayerCounts = TvTEvent.getTeamsPlayerCounts();
                NpcHtmlMessage npcHtmlMessage = new NpcHtmlMessage(this.getObjectId());
                npcHtmlMessage.setHtml(htmContent2);
                npcHtmlMessage.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
                npcHtmlMessage.replace((CharSequence)"%team1name%", Config.TVT_EVENT_TEAM_1_NAME);
                npcHtmlMessage.replace((CharSequence)"%team1playercount%", String.valueOf(teamsPlayerCounts[0]));
                npcHtmlMessage.replace((CharSequence)"%team2name%", Config.TVT_EVENT_TEAM_2_NAME);
                npcHtmlMessage.replace((CharSequence)"%team2playercount%", String.valueOf(teamsPlayerCounts[1]));
                npcHtmlMessage.replace((CharSequence)"%playercount%", String.valueOf(teamsPlayerCounts[0] + teamsPlayerCounts[1]));
                if (!isParticipant) {
                    npcHtmlMessage.replace((CharSequence)"%fee%", TvTEvent.getParticipationFee());
                }
                playerInstance.sendPacket(npcHtmlMessage);
            }
        } else if ((TvTEvent.isStarting() || TvTEvent.isStarted()) && (htmContent = HtmCache.getInstance().getHtm("data/html/mods/TvTEvent/Status.htm")) != null) {
            int[] teamsPlayerCounts = TvTEvent.getTeamsPlayerCounts();
            int[] teamsPointsCounts = TvTEvent.getTeamsPoints();
            NpcHtmlMessage npcHtmlMessage = new NpcHtmlMessage(this.getObjectId());
            npcHtmlMessage.setHtml(htmContent);
            npcHtmlMessage.replace((CharSequence)"%team1name%", Config.TVT_EVENT_TEAM_1_NAME);
            npcHtmlMessage.replace((CharSequence)"%team1playercount%", String.valueOf(teamsPlayerCounts[0]));
            npcHtmlMessage.replace((CharSequence)"%team1points%", String.valueOf(teamsPointsCounts[0]));
            npcHtmlMessage.replace((CharSequence)"%team2name%", Config.TVT_EVENT_TEAM_2_NAME);
            npcHtmlMessage.replace((CharSequence)"%team2playercount%", String.valueOf(teamsPlayerCounts[1]));
            npcHtmlMessage.replace((CharSequence)"%team2points%", String.valueOf(teamsPointsCounts[1]));
            playerInstance.sendPacket(npcHtmlMessage);
        }
        playerInstance.sendPacket(ActionFailed.STATIC_PACKET);
    }
}

