/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.status;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.instancemanager.DuelManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.model.actor.stat.PcStat;
import com.l2jserver.gameserver.model.actor.status.PlayableStatus;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Formulas;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;

public class PcStatus
extends PlayableStatus {
    private double _currentCp = 0.0;

    public PcStatus(L2PcInstance activeChar) {
        super(activeChar);
    }

    @Override
    public final void reduceCp(int value) {
        if (this.getCurrentCp() > (double)value) {
            this.setCurrentCp(this.getCurrentCp() - (double)value);
        } else {
            this.setCurrentCp(0.0);
        }
    }

    @Override
    public final void reduceHp(double value, L2Character attacker) {
        this.reduceHp(value, attacker, true, false, false);
    }

    @Override
    public final void reduceHp(double value, L2Character attacker, boolean awake, boolean isDOT, boolean isHPConsumption) {
        if (this.getActiveChar().isDead()) {
            return;
        }
        if (this.getActiveChar().isInvul()) {
            if (attacker == this.getActiveChar()) {
                if (!isDOT && !isHPConsumption) {
                    return;
                }
            } else {
                return;
            }
        }
        if (!isHPConsumption) {
            if (awake && this.getActiveChar().isSleeping()) {
                this.getActiveChar().stopSleeping(null);
            }
            if (this.getActiveChar().isSitting()) {
                this.getActiveChar().standUp();
            }
            if (this.getActiveChar().isFakeDeath()) {
                this.getActiveChar().stopFakeDeath(null);
            }
            if (!isDOT) {
                if (this.getActiveChar().isStunned() && Rnd.get(10) == 0) {
                    this.getActiveChar().stopStunning(null);
                }
                if (this.getActiveChar().isImmobileUntilAttacked()) {
                    this.getActiveChar().stopImmobileUntilAttacked(null);
                }
            }
        }
        int fullValue = (int)value;
        int tDmg = 0;
        if (attacker != null && attacker != this.getActiveChar()) {
            L2Summon summon;
            L2PcInstance attackerPlayer = attacker.getActingPlayer();
            if (attackerPlayer != null) {
                if (attackerPlayer.isGM() && !attackerPlayer.getAccessLevel().canGiveDamage()) {
                    return;
                }
                if (this.getActiveChar().isInDuel()) {
                    if (this.getActiveChar().getDuelState() == 2) {
                        return;
                    }
                    if (this.getActiveChar().getDuelState() == 3) {
                        return;
                    }
                    if (attackerPlayer.getDuelId() != this.getActiveChar().getDuelId()) {
                        this.getActiveChar().setDuelState(4);
                    }
                }
            }
            if ((summon = this.getActiveChar().getPet()) != null && summon instanceof L2SummonInstance && Util.checkIfInRange(900, this.getActiveChar(), summon, true)) {
                tDmg = (int)value * (int)this.getActiveChar().getStat().calcStat(Stats.TRANSFER_DAMAGE_PERCENT, 0.0, null, null) / 100;
                tDmg = Math.min((int)summon.getCurrentHp() - 1, tDmg);
                if (tDmg > 0) {
                    summon.reduceCurrentHp(tDmg, attacker, null);
                    fullValue = (int)(value -= (double)tDmg);
                }
            }
            if (attacker instanceof L2Playable) {
                if (this.getCurrentCp() >= value) {
                    this.setCurrentCp(this.getCurrentCp() - value);
                    value = 0.0;
                } else {
                    value -= this.getCurrentCp();
                    this.setCurrentCp(0.0, false);
                }
            }
            if (fullValue > 0 && !isDOT) {
                SystemMessage smsg = new SystemMessage(SystemMessageId.C1_RECEIVED_DAMAGE_OF_S3_FROM_C2);
                smsg.addString(this.getActiveChar().getName());
                smsg.addCharName(attacker);
                smsg.addNumber(fullValue);
                this.getActiveChar().sendPacket(smsg);
                if (tDmg > 0) {
                    smsg = new SystemMessage(SystemMessageId.C1_RECEIVED_DAMAGE_OF_S3_FROM_C2);
                    smsg.addString(this.getActiveChar().getPet().getName());
                    smsg.addCharName(attacker);
                    smsg.addNumber(tDmg);
                    this.getActiveChar().sendPacket(smsg);
                    if (attackerPlayer != null) {
                        smsg = new SystemMessage(SystemMessageId.GIVEN_S1_DAMAGE_TO_YOUR_TARGET_AND_S2_DAMAGE_TO_SERVITOR);
                        smsg.addNumber(fullValue);
                        smsg.addNumber(tDmg);
                        attackerPlayer.sendPacket(smsg);
                    }
                }
            }
        }
        if (value > 0.0) {
            value = this.getCurrentHp() - value;
            if (value <= 0.0) {
                if (this.getActiveChar().isInDuel()) {
                    this.getActiveChar().disableAllSkills();
                    this.stopHpMpRegeneration();
                    attacker.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                    attacker.sendPacket(ActionFailed.STATIC_PACKET);
                    DuelManager.getInstance().onPlayerDefeat(this.getActiveChar());
                    value = 1.0;
                } else {
                    value = 0.0;
                }
            }
            this.setCurrentHp(value);
        }
        if (this.getActiveChar().getCurrentHp() < 0.5) {
            this.getActiveChar().abortAttack();
            this.getActiveChar().abortCast();
            if (this.getActiveChar().isInOlympiadMode()) {
                this.stopHpMpRegeneration();
                this.getActiveChar().setIsDead(true);
                this.getActiveChar().setIsPendingRevive(true);
                if (this.getActiveChar().getPet() != null) {
                    this.getActiveChar().getPet().getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE, null);
                }
                return;
            }
            this.getActiveChar().doDie(attacker);
            QuestState qs = this.getActiveChar().getQuestState("255_Tutorial");
            if (qs != null) {
                qs.getQuest().notifyEvent("CE30", null, this.getActiveChar());
            }
        }
    }

    @Override
    public final void setCurrentHp(double newHp, boolean broadcastPacket) {
        QuestState qs;
        super.setCurrentHp(newHp, broadcastPacket);
        if (this.getCurrentHp() <= (double)this.getActiveChar().getStat().getMaxHp() * 0.3 && (qs = this.getActiveChar().getQuestState("255_Tutorial")) != null) {
            qs.getQuest().notifyEvent("CE45", null, this.getActiveChar());
        }
    }

    @Override
    public final double getCurrentCp() {
        return this._currentCp;
    }

    @Override
    public final void setCurrentCp(double newCp) {
        this.setCurrentCp(newCp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCurrentCp(double newCp, boolean broadcastPacket) {
        int maxCp = this.getActiveChar().getStat().getMaxCp();
        PcStatus pcStatus = this;
        synchronized (pcStatus) {
            if (this.getActiveChar().isDead()) {
                return;
            }
            if (newCp < 0.0) {
                newCp = 0.0;
            }
            if (newCp >= (double)maxCp) {
                this._currentCp = maxCp;
                this._flagsRegenActive = (byte)(this._flagsRegenActive & 0xFFFFFFFB);
                if (this._flagsRegenActive == 0) {
                    this.stopHpMpRegeneration();
                }
            } else {
                this._currentCp = newCp;
                this._flagsRegenActive = (byte)(this._flagsRegenActive | 4);
                this.startHpMpRegeneration();
            }
        }
        if (broadcastPacket) {
            this.getActiveChar().broadcastStatusUpdate();
        }
    }

    @Override
    protected void doRegeneration() {
        PcStat charstat = this.getActiveChar().getStat();
        if (this.getCurrentCp() < (double)charstat.getMaxCp()) {
            this.setCurrentCp(this.getCurrentCp() + Formulas.calcCpRegen(this.getActiveChar()), false);
        }
        if (this.getCurrentHp() < (double)charstat.getMaxHp()) {
            this.setCurrentHp(this.getCurrentHp() + Formulas.calcHpRegen(this.getActiveChar()), false);
        }
        if (this.getCurrentMp() < (double)charstat.getMaxMp()) {
            this.setCurrentMp(this.getCurrentMp() + Formulas.calcMpRegen(this.getActiveChar()), false);
        }
        this.getActiveChar().broadcastStatusUpdate();
    }

    @Override
    public L2PcInstance getActiveChar() {
        return (L2PcInstance)super.getActiveChar();
    }
}

