/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.cache.CrestCache;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RequestSetAllyCrest
extends L2GameClientPacket {
    private static final String _C__87_REQUESTSETALLYCREST = "[C] 87 RequestSetAllyCrest";
    static Logger _log = Logger.getLogger(RequestSetAllyCrest.class.getName());
    private int _length;
    private byte[] _data;

    @Override
    protected void readImpl() {
        this._length = this.readD();
        if (this._length < 0 || this._length > 192) {
            return;
        }
        this._data = new byte[this._length];
        this.readB(this._data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (this._length < 0) {
            activeChar.sendMessage("File transfer error.");
            return;
        }
        if (this._length > 192) {
            activeChar.sendMessage("The crest file size was too big (max 192 bytes).");
            return;
        }
        if (activeChar.getAllyId() != 0) {
            int newId;
            L2Clan leaderclan = ClanTable.getInstance().getClan(activeChar.getAllyId());
            if (activeChar.getClanId() != leaderclan.getClanId() || !activeChar.isClanLeader()) {
                SystemMessage sm = new SystemMessage(SystemMessageId.FEATURE_ONLY_FOR_ALLIANCE_LEADER);
                activeChar.sendPacket(sm);
                return;
            }
            CrestCache crestCache = CrestCache.getInstance();
            if (!crestCache.saveAllyCrest(newId = IdFactory.getInstance().getNextId(), this._data)) {
                _log.log(Level.INFO, "Error loading crest of ally:" + leaderclan.getAllyName());
                return;
            }
            if (leaderclan.getAllyCrestId() != 0) {
                crestCache.removeAllyCrest(leaderclan.getAllyCrestId());
            }
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("UPDATE clan_data SET ally_crest_id = ? WHERE ally_id = ?");
                statement.setInt(1, newId);
                statement.setInt(2, leaderclan.getAllyId());
                statement.executeUpdate();
                statement.close();
            }
            catch (SQLException e) {
                _log.warning("could not update the ally crest id:" + e.getMessage());
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
            for (L2Clan clan : ClanTable.getInstance().getClans()) {
                if (clan.getAllyId() != activeChar.getAllyId()) continue;
                clan.setAllyCrestId(newId);
                for (L2PcInstance member : clan.getOnlineMembers(0)) {
                    member.broadcastUserInfo();
                }
            }
        }
    }

    @Override
    public String getType() {
        return _C__87_REQUESTSETALLYCREST;
    }
}

