/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.communityserver.readpackets;

import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExMailArrived;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import org.netcon.BaseReadPacket;

public final class RequestPlayerShowMessage
extends BaseReadPacket {
    public RequestPlayerShowMessage(byte[] data) {
        super(data);
    }

    public final void run() {
        int playerObjId = super.readD();
        int type = super.readD();
        L2PcInstance player = (L2PcInstance)L2World.getInstance().findObject(playerObjId);
        if (player == null) {
            System.out.println("error: player not found!!!");
            return;
        }
        switch (type) {
            case -1: {
                player.sendPacket(new ExMailArrived());
                break;
            }
            case 0: {
                player.sendMessage(super.readS());
                break;
            }
            case 236: {
                player.sendPacket(new SystemMessage(SystemMessageId.ONLY_THE_CLAN_LEADER_IS_ENABLED));
                break;
            }
            case 1050: {
                player.sendPacket(new SystemMessage(SystemMessageId.NO_CB_IN_MY_CLAN));
                break;
            }
            case 1070: {
                player.sendPacket(new SystemMessage(SystemMessageId.NO_READ_PERMISSION));
                break;
            }
            case 1071: {
                player.sendPacket(new SystemMessage(SystemMessageId.NO_WRITE_PERMISSION));
                break;
            }
            case 1205: {
                player.sendPacket(new SystemMessage(SystemMessageId.MAILBOX_FULL));
                break;
            }
            case 1206: {
                player.sendPacket(new SystemMessage(SystemMessageId.MEMOBOX_FULL));
                break;
            }
            case 1227: {
                try {
                    SystemMessage sm = new SystemMessage(SystemMessageId.S1_UNREAD_MESSAGES);
                    int number = super.readD();
                    sm.addNumber(number);
                    player.sendPacket(sm);
                }
                catch (Exception e) {
                    System.out.println("Incorrect packet from CBserver!");
                }
                break;
            }
            case 1228: {
                try {
                    SystemMessage sm = new SystemMessage(SystemMessageId.C1_BLOCKED_YOU_CANNOT_MAIL);
                    String name = super.readS();
                    sm.addString(name);
                    player.sendPacket(sm);
                }
                catch (Exception e) {
                    System.out.println("Incorrect packet from CBserver!");
                }
                break;
            }
            case 1229: {
                player.sendPacket(new SystemMessage(SystemMessageId.NO_MORE_MESSAGES_TODAY));
                break;
            }
            case 1230: {
                player.sendPacket(new SystemMessage(SystemMessageId.ONLY_FIVE_RECIPIENTS));
                break;
            }
            case 1231: {
                player.sendPacket(new SystemMessage(SystemMessageId.SENT_MAIL));
                break;
            }
            case 1232: {
                player.sendPacket(new SystemMessage(SystemMessageId.MESSAGE_NOT_SENT));
                break;
            }
            case 1233: {
                player.sendPacket(new SystemMessage(SystemMessageId.NEW_MAIL));
                break;
            }
            case 1234: {
                player.sendPacket(new SystemMessage(SystemMessageId.MAIL_STORED_IN_MAILBOX));
                break;
            }
            case 1238: {
                player.sendPacket(new SystemMessage(SystemMessageId.TEMP_MAILBOX_FULL));
                break;
            }
            case 1370: {
                try {
                    SystemMessage sm = new SystemMessage(SystemMessageId.CANNOT_MAIL_GM_C1);
                    String name = super.readS();
                    sm.addString(name);
                    player.sendPacket(sm);
                }
                catch (Exception e) {
                    System.out.println("Incorrect packet from CBserver!");
                }
                break;
            }
            default: {
                System.out.println("error: Unknown message request from CB server: " + type);
            }
        }
    }
}

