/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;

public class ExReplyDominionInfo
extends L2GameServerPacket {
    private static Logger _log = Logger.getLogger(ExReplyDominionInfo.class.getName());
    private int _warTime = (int)(Calendar.getInstance().getTimeInMillis() / 1000L);

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(146);
        List<Castle> castles = CastleManager.getInstance().getCastles();
        this.writeD(castles.size());
        for (Castle castle : castles) {
            this.writeD(80 + castle.getCastleId());
            this.writeS(castle.getName().toLowerCase() + "_dominion");
            if (castle.getOwnerId() > 0) {
                if (ClanTable.getInstance().getClan(castle.getOwnerId()) != null) {
                    this.writeS(ClanTable.getInstance().getClan(castle.getOwnerId()).getName());
                } else {
                    _log.warning("Castle owner with no name! Castle: " + castle.getName() + " has an OwnerId = " + castle.getOwnerId() + " who does not have a  name!");
                    this.writeS("");
                }
            } else {
                this.writeS("");
            }
            this.writeD(1);
            this.writeD(80 + castle.getCastleId());
            this.writeD(this._warTime);
        }
    }

    @Override
    public String getType() {
        return "[S] FE:92 ExReplyDominionInfo";
    }
}

