/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.Calendar;
import java.util.List;

public class ExShowDominionRegistry
extends L2GameServerPacket {
    private int _territoryId;
    private int _clanReq = 0;
    private int _mercReq = 0;
    private String _clanName = "";
    private String _clanLeader = "";
    private String _allyName = "";
    private int _warTime = (int)(Calendar.getInstance().getTimeInMillis() / 1000L);
    private int _currentTime = (int)(Calendar.getInstance().getTimeInMillis() / 1000L);

    public ExShowDominionRegistry(int castleId) {
        this._territoryId = 80 + castleId;
        int owner = CastleManager.getInstance().getCastleById(castleId).getOwnerId();
        if (owner != 0) {
            try {
                L2Clan clan = ClanTable.getInstance().getClan(owner);
                this._clanName = clan.getName();
                this._clanLeader = clan.getLeaderName();
                this._allyName = clan.getAllyName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getType() {
        return "[S] FE:90 ExShowDominionRegistry";
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(144);
        this.writeD(this._territoryId);
        this.writeS(this._clanName);
        this.writeS(this._clanLeader);
        this.writeS(this._allyName);
        this.writeD(this._clanReq);
        this.writeD(this._mercReq);
        this.writeD(this._warTime);
        this.writeD(this._currentTime);
        this.writeD(0);
        this.writeD(0);
        this.writeD(1);
        List<Castle> castles = CastleManager.getInstance().getCastles();
        this.writeD(castles.size());
        for (Castle castle : castles) {
            this.writeD(80 + castle.getCastleId());
            this.writeD(1);
            this.writeD(80 + castle.getCastleId());
        }
    }
}

