/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class GMViewWarehouseWithdrawList
extends L2GameServerPacket {
    private static final String _S__95_GMViewWarehouseWithdrawList = "[S] 9b GMViewWarehouseWithdrawList";
    private L2ItemInstance[] _items;
    private String _playerName;
    private L2PcInstance _activeChar;
    private long _money;

    public GMViewWarehouseWithdrawList(L2PcInstance cha) {
        this._activeChar = cha;
        this._items = this._activeChar.getWarehouse().getItems();
        this._playerName = this._activeChar.getName();
        this._money = this._activeChar.getAdena();
    }

    @Override
    protected final void writeImpl() {
        this.writeC(155);
        this.writeS(this._playerName);
        this.writeQ(this._money);
        this.writeH(this._items.length);
        for (L2ItemInstance item : this._items) {
            this.writeH(item.getItem().getType1());
            this.writeD(item.getObjectId());
            this.writeD(item.getItemId());
            this.writeQ(item.getCount());
            this.writeH(item.getItem().getType2());
            this.writeH(item.getCustomType1());
            this.writeD(item.getItem().getBodyPart());
            this.writeH(item.getEnchantLevel());
            this.writeH(0);
            this.writeH(item.getCustomType2());
            this.writeD(item.getObjectId());
            if (item.isAugmented()) {
                this.writeD(0xFFFF & item.getAugmentation().getAugmentationId());
                this.writeD(item.getAugmentation().getAugmentationId() >> 16);
            } else {
                this.writeQ(0L);
            }
            this.writeH(item.getAttackElementType());
            this.writeH(item.getAttackElementPower());
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.writeH(item.getElementDefAttr(i));
            }
            this.writeD(item.getMana());
            this.writeD(item.isTimeLimitedItem() ? (int)(item.getRemainingTime() / 1000L) : -1);
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
        }
    }

    @Override
    public String getType() {
        return _S__95_GMViewWarehouseWithdrawList;
    }
}

