/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.pathfinding.cellnodes;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.pathfinding.AbstractNodeLoc;
import com.l2jserver.gameserver.pathfinding.Node;
import com.l2jserver.gameserver.pathfinding.PathFinding;
import com.l2jserver.gameserver.pathfinding.cellnodes.NodeLoc;
import java.util.List;

public class CellPathFinding
extends PathFinding {
    public static CellPathFinding getInstance() {
        return SingletonHolder._instance;
    }

    @Override
    public boolean pathNodesExist(short regionoffset) {
        return false;
    }

    @Override
    public List<AbstractNodeLoc> findPath(int x, int y, int z, int tx, int ty, int tz, int instanceId) {
        int gx = x - -327680 >> 4;
        int gy = y - -262144 >> 4;
        if (!GeoData.getInstance().hasGeo(x, y)) {
            return null;
        }
        short gz = GeoData.getInstance().getHeight(x, y, z);
        int gtx = tx - -327680 >> 4;
        int gty = ty - -262144 >> 4;
        if (!GeoData.getInstance().hasGeo(tx, ty)) {
            return null;
        }
        short gtz = GeoData.getInstance().getHeight(tx, ty, tz);
        Node start = this.readNode(gx, gy, gz);
        Node end = this.readNode(gtx, gty, gtz);
        return this.searchByClosest(start, end);
    }

    @Override
    public Node[] readNeighbors(Node n, int idx) {
        return GeoData.getInstance().getNeighbors(n);
    }

    public Node readNode(int gx, int gy, short z) {
        return new Node(new NodeLoc(gx, gy, z), 0);
    }

    private CellPathFinding() {
    }

    private static class SingletonHolder {
        protected static final CellPathFinding _instance = new CellPathFinding();

        private SingletonHolder() {
        }
    }
}

