/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.script.faenor;

import com.l2jserver.Config;
import com.l2jserver.gameserver.script.IntList;
import com.l2jserver.gameserver.script.Parser;
import com.l2jserver.gameserver.script.ParserFactory;
import com.l2jserver.gameserver.script.ScriptEngine;
import com.l2jserver.gameserver.script.faenor.FaenorParser;
import java.util.Map;
import java.util.logging.Logger;
import javax.script.ScriptContext;
import javolution.util.FastMap;
import org.w3c.dom.Node;

public class FaenorWorldDataParser
extends FaenorParser {
    static Logger _log = Logger.getLogger(FaenorWorldDataParser.class.getName());
    private static final String PET_DATA = "PetData";

    @Override
    public void parseScript(Node eventNode, ScriptContext context) {
        if (Config.DEBUG) {
            _log.info("Parsing WorldData");
        }
        for (Node node = eventNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!FaenorWorldDataParser.isNodeName(node, PET_DATA)) continue;
            this.parsePetData(node, context);
        }
    }

    private void parsePetData(Node petNode, ScriptContext context) {
        PetData petData = new PetData();
        try {
            petData.petId = FaenorWorldDataParser.getInt(FaenorWorldDataParser.attribute(petNode, "ID"));
            int[] levelRange = IntList.parse(FaenorWorldDataParser.attribute(petNode, "Levels"));
            petData.levelStart = levelRange[0];
            petData.levelEnd = levelRange[1];
            for (Node node = petNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!FaenorWorldDataParser.isNodeName(node, "Stat")) continue;
                this.parseStat(node, petData);
            }
            _bridge.addPetData(context, petData.petId, petData.levelStart, petData.levelEnd, petData.statValues);
        }
        catch (Exception e) {
            petData.petId = -1;
            _log.warning("Error in pet Data parser.");
            e.printStackTrace();
        }
    }

    private void parseStat(Node stat, PetData petData) {
        try {
            String statName = FaenorWorldDataParser.attribute(stat, "Name");
            for (Node node = stat.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!FaenorWorldDataParser.isNodeName(node, "Formula")) continue;
                String formula = this.parseForumla(node);
                petData.statValues.put(statName, formula);
            }
        }
        catch (Exception e) {
            petData.petId = -1;
            _log.warning("ERROR(parseStat):" + e.getMessage());
        }
    }

    private String parseForumla(Node formulaNode) {
        return formulaNode.getTextContent().trim();
    }

    static {
        ScriptEngine.parserFactories.put(FaenorWorldDataParser.getParserName("WorldData"), new FaenorWorldDataParserFactory());
    }

    static class FaenorWorldDataParserFactory
    extends ParserFactory {
        FaenorWorldDataParserFactory() {
        }

        @Override
        public Parser create() {
            return new FaenorWorldDataParser();
        }
    }

    public class PetData {
        public int petId;
        public int levelStart;
        public int levelEnd;
        Map<String, String> statValues = new FastMap();
    }
}

