/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.funcs;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.skills.funcs.Func;
import com.l2jserver.gameserver.skills.funcs.Lambda;
import com.l2jserver.gameserver.templates.item.L2WeaponType;

public class FuncEnchant
extends Func {
    public FuncEnchant(Stats pStat, int pOrder, Object owner, Lambda lambda) {
        super(pStat, pOrder, owner);
    }

    @Override
    public void calc(Env env) {
        L2PcInstance player;
        if (this.cond != null && !this.cond.test(env)) {
            return;
        }
        L2ItemInstance item = (L2ItemInstance)this.funcOwner;
        int enchant = item.getEnchantLevel();
        if (enchant <= 0) {
            return;
        }
        int overenchant = 0;
        if (enchant > 3) {
            overenchant = enchant - 3;
            enchant = 3;
        }
        if (env.player != null && env.player instanceof L2PcInstance && (player = (L2PcInstance)env.player).isInOlympiadMode() && Config.ALT_OLY_ENCHANT_LIMIT >= 0 && enchant + overenchant > Config.ALT_OLY_ENCHANT_LIMIT) {
            if (Config.ALT_OLY_ENCHANT_LIMIT > 3) {
                overenchant = Config.ALT_OLY_ENCHANT_LIMIT - 3;
            } else {
                overenchant = 0;
                enchant = Config.ALT_OLY_ENCHANT_LIMIT;
            }
        }
        if (this.stat == Stats.MAGIC_DEFENCE || this.stat == Stats.POWER_DEFENCE) {
            env.value += (double)(enchant + 3 * overenchant);
            return;
        }
        if (this.stat == Stats.MAGIC_ATTACK) {
            switch (item.getItem().getItemGradeSPlus()) {
                case 5: {
                    env.value += (double)(4 * enchant + 8 * overenchant);
                    break;
                }
                case 4: {
                    env.value += (double)(3 * enchant + 6 * overenchant);
                    break;
                }
                case 3: {
                    env.value += (double)(3 * enchant + 6 * overenchant);
                    break;
                }
                case 2: {
                    env.value += (double)(3 * enchant + 6 * overenchant);
                    break;
                }
                case 1: {
                    env.value += (double)(2 * enchant + 4 * overenchant);
                }
            }
            return;
        }
        if (item.isWeapon()) {
            L2WeaponType type = (L2WeaponType)item.getItemType();
            block7 : switch (item.getItem().getItemGradeSPlus()) {
                case 5: {
                    switch (type) {
                        case BOW: 
                        case CROSSBOW: {
                            env.value += (double)(10 * enchant + 20 * overenchant);
                            break block7;
                        }
                    }
                    env.value += (double)(5 * enchant + 10 * overenchant);
                    break;
                }
                case 4: {
                    switch (type) {
                        case BOW: 
                        case CROSSBOW: {
                            env.value += (double)(8 * enchant + 16 * overenchant);
                            break block7;
                        }
                    }
                    env.value += (double)(4 * enchant + 8 * overenchant);
                    break;
                }
                case 3: {
                    switch (type) {
                        case BOW: 
                        case CROSSBOW: {
                            env.value += (double)(6 * enchant + 12 * overenchant);
                            break block7;
                        }
                    }
                    env.value += (double)(3 * enchant + 6 * overenchant);
                    break;
                }
                case 2: {
                    switch (type) {
                        case BOW: 
                        case CROSSBOW: {
                            env.value += (double)(6 * enchant + 12 * overenchant);
                            break block7;
                        }
                    }
                    env.value += (double)(3 * enchant + 6 * overenchant);
                    break;
                }
                case 0: 
                case 1: {
                    switch (type) {
                        case BOW: 
                        case CROSSBOW: {
                            env.value += (double)(4 * enchant + 8 * overenchant);
                            break block7;
                        }
                    }
                    env.value += (double)(2 * enchant + 4 * overenchant);
                }
            }
        }
    }
}

