/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class DecayTaskManager {
    protected static final Logger _log = Logger.getLogger(DecayTaskManager.class.getName());
    protected Map<L2Character, Long> _decayTasks = new FastMap().setShared(true);
    public static final int RAID_BOSS_DECAY_TIME = 30000;
    public static final int ATTACKABLE_DECAY_TIME = 8500;

    private DecayTaskManager() {
        ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new DecayScheduler(), 10000L, 5000L);
    }

    public static DecayTaskManager getInstance() {
        return SingletonHolder._instance;
    }

    public void addDecayTask(L2Character actor) {
        this._decayTasks.put(actor, System.currentTimeMillis());
    }

    public void addDecayTask(L2Character actor, int interval) {
        this._decayTasks.put(actor, System.currentTimeMillis() + (long)interval);
    }

    public void cancelDecayTask(L2Character actor) {
        try {
            this._decayTasks.remove(actor);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public String toString() {
        String ret = "============= DecayTask Manager Report ============\r\n";
        ret = ret + "Tasks count: " + this._decayTasks.size() + "\r\n";
        ret = ret + "Tasks dump:\r\n";
        Long current = System.currentTimeMillis();
        for (L2Character actor : this._decayTasks.keySet()) {
            ret = ret + "Class/Name: " + actor.getClass().getSimpleName() + "/" + actor.getName() + " decay timer: " + (current - this._decayTasks.get(actor)) + "\r\n";
        }
        return ret;
    }

    public Map<L2Character, Long> getTasks() {
        return this._decayTasks;
    }

    private static class SingletonHolder {
        protected static final DecayTaskManager _instance = new DecayTaskManager();

        private SingletonHolder() {
        }
    }

    private class DecayScheduler
    implements Runnable {
        protected DecayScheduler() {
        }

        @Override
        public void run() {
            Long current = System.currentTimeMillis();
            try {
                if (DecayTaskManager.this._decayTasks != null) {
                    for (L2Character actor : DecayTaskManager.this._decayTasks.keySet()) {
                        int delay = actor.isRaid() && !actor.isRaidMinion() ? 30000 : 8500;
                        if (current - DecayTaskManager.this._decayTasks.get(actor) <= (long)delay) continue;
                        actor.onDecay();
                        DecayTaskManager.this._decayTasks.remove(actor);
                    }
                }
            }
            catch (Exception e) {
                _log.warning(e.toString());
            }
        }
    }
}

