/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.taskmanager.Task;
import com.l2jserver.gameserver.taskmanager.TaskTypes;
import com.l2jserver.gameserver.taskmanager.tasks.TaskCleanUp;
import com.l2jserver.gameserver.taskmanager.tasks.TaskJython;
import com.l2jserver.gameserver.taskmanager.tasks.TaskOlympiadSave;
import com.l2jserver.gameserver.taskmanager.tasks.TaskRaidPointsReset;
import com.l2jserver.gameserver.taskmanager.tasks.TaskRecom;
import com.l2jserver.gameserver.taskmanager.tasks.TaskRestart;
import com.l2jserver.gameserver.taskmanager.tasks.TaskScript;
import com.l2jserver.gameserver.taskmanager.tasks.TaskSevenSignsUpdate;
import com.l2jserver.gameserver.taskmanager.tasks.TaskShutdown;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public final class TaskManager {
    protected static final Logger _log = Logger.getLogger(TaskManager.class.getName());
    protected static final String[] SQL_STATEMENTS = new String[]{"SELECT id,task,type,last_activation,param1,param2,param3 FROM global_tasks", "UPDATE global_tasks SET last_activation=? WHERE id=?", "SELECT id FROM global_tasks WHERE task=?", "INSERT INTO global_tasks (task,type,last_activation,param1,param2,param3) VALUES(?,?,?,?,?,?)"};
    private final FastMap<Integer, Task> _tasks = new FastMap();
    protected final FastList<ExecutedTask> _currentTasks = new FastList();

    public static TaskManager getInstance() {
        return SingletonHolder._instance;
    }

    private TaskManager() {
        this.initializate();
        this.startAllTasks();
    }

    private void initializate() {
        this.registerTask(new TaskCleanUp());
        this.registerTask(new TaskScript());
        this.registerTask(new TaskJython());
        this.registerTask(new TaskOlympiadSave());
        this.registerTask(new TaskRaidPointsReset());
        this.registerTask(new TaskRecom());
        this.registerTask(new TaskRestart());
        this.registerTask(new TaskSevenSignsUpdate());
        this.registerTask(new TaskShutdown());
    }

    public void registerTask(Task task) {
        int key = task.getName().hashCode();
        if (!this._tasks.containsKey((Object)key)) {
            this._tasks.put((Object)key, (Object)task);
            task.initializate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAllTasks() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(SQL_STATEMENTS[0]);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                ExecutedTask current;
                TaskTypes type;
                Task task = (Task)this._tasks.get((Object)rset.getString("task").trim().toLowerCase().hashCode());
                if (task == null || (type = TaskTypes.valueOf(rset.getString("type"))) == TaskTypes.TYPE_NONE || !this.launchTask(current = new ExecutedTask(task, type, rset))) continue;
                this._currentTasks.add((Object)current);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.severe("error while loading Global Task table " + e);
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean launchTask(ExecutedTask task) {
        ThreadPoolManager scheduler = ThreadPoolManager.getInstance();
        TaskTypes type = task.getType();
        switch (type) {
            case TYPE_STARTUP: {
                task.run();
                return false;
            }
            case TYPE_SHEDULED: {
                long delay = Long.valueOf(task.getParams()[0]);
                task.scheduled = scheduler.scheduleGeneral(task, delay);
                return true;
            }
            case TYPE_FIXED_SHEDULED: {
                long delay = Long.valueOf(task.getParams()[0]);
                long interval = Long.valueOf(task.getParams()[1]);
                task.scheduled = scheduler.scheduleGeneralAtFixedRate(task, delay, interval);
                return true;
            }
            case TYPE_TIME: {
                try {
                    Date desired = DateFormat.getInstance().parse(task.getParams()[0]);
                    long diff = desired.getTime() - System.currentTimeMillis();
                    if (diff >= 0L) {
                        task.scheduled = scheduler.scheduleGeneral(task, diff);
                        return true;
                    }
                    _log.info("Task " + task.getId() + " is obsoleted.");
                }
                catch (Exception e) {}
                break;
            }
            case TYPE_SPECIAL: {
                ScheduledFuture<?> result = task.getTask().launchSpecial(task);
                if (result == null) break;
                task.scheduled = result;
                return true;
            }
            case TYPE_GLOBAL_TASK: {
                long interval = Long.valueOf(task.getParams()[0]) * 86400000L;
                String[] hour = task.getParams()[1].split(":");
                if (hour.length != 3) {
                    _log.warning("Task " + task.getId() + " has incorrect parameters");
                    return false;
                }
                Calendar check = Calendar.getInstance();
                check.setTimeInMillis(task.getLastActivation() + interval);
                Calendar min = Calendar.getInstance();
                try {
                    min.set(11, Integer.parseInt(hour[0]));
                    min.set(12, Integer.parseInt(hour[1]));
                    min.set(13, Integer.parseInt(hour[2]));
                }
                catch (Exception e) {
                    _log.warning("Bad parameter on task " + task.getId() + ": " + e.getMessage());
                    return false;
                }
                long delay = min.getTimeInMillis() - System.currentTimeMillis();
                if (check.after(min) || delay < 0L) {
                    delay += interval;
                }
                task.scheduled = scheduler.scheduleGeneralAtFixedRate(task, delay, interval);
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public static boolean addUniqueTask(String task, TaskTypes type, String param1, String param2, String param3) {
        return TaskManager.addUniqueTask(task, type, param1, param2, param3, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addUniqueTask(String task, TaskTypes type, String param1, String param2, String param3, long lastActivation) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(SQL_STATEMENTS[2]);
            statement.setString(1, task);
            ResultSet rset = statement.executeQuery();
            if (!rset.next()) {
                statement = con.prepareStatement(SQL_STATEMENTS[3]);
                statement.setString(1, task);
                statement.setString(2, type.toString());
                statement.setLong(3, lastActivation);
                statement.setString(4, param1);
                statement.setString(5, param2);
                statement.setString(6, param3);
                statement.execute();
            }
            rset.close();
            statement.close();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            _log.warning("cannot add the unique task: " + e.getMessage());
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return false;
    }

    public static boolean addTask(String task, TaskTypes type, String param1, String param2, String param3) {
        return TaskManager.addTask(task, type, param1, param2, param3, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addTask(String task, TaskTypes type, String param1, String param2, String param3, long lastActivation) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(SQL_STATEMENTS[3]);
            statement.setString(1, task);
            statement.setString(2, type.toString());
            statement.setLong(3, lastActivation);
            statement.setString(4, param1);
            statement.setString(5, param2);
            statement.setString(6, param3);
            statement.execute();
            statement.close();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            _log.warning("cannot add the task:  " + e.getMessage());
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return false;
    }

    private static class SingletonHolder {
        protected static final TaskManager _instance = new TaskManager();

        private SingletonHolder() {
        }
    }

    public class ExecutedTask
    implements Runnable {
        int id;
        long lastActivation;
        Task task;
        TaskTypes type;
        String[] params;
        ScheduledFuture<?> scheduled;

        public ExecutedTask(Task ptask, TaskTypes ptype, ResultSet rset) throws SQLException {
            this.task = ptask;
            this.type = ptype;
            this.id = rset.getInt("id");
            this.lastActivation = rset.getLong("last_activation");
            this.params = new String[]{rset.getString("param1"), rset.getString("param2"), rset.getString("param3")};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.task.onTimeElapsed(this);
            this.lastActivation = System.currentTimeMillis();
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement(SQL_STATEMENTS[1]);
                statement.setLong(1, this.lastActivation);
                statement.setInt(2, this.id);
                statement.executeUpdate();
                statement.close();
            }
            catch (SQLException e) {
                _log.warning("cannot updated the Global Task " + this.id + ": " + e.getMessage());
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
            if (this.type == TaskTypes.TYPE_SHEDULED || this.type == TaskTypes.TYPE_TIME) {
                this.stopTask();
            }
        }

        public boolean equals(Object object) {
            return this.id == ((ExecutedTask)object).id;
        }

        public Task getTask() {
            return this.task;
        }

        public TaskTypes getType() {
            return this.type;
        }

        public int getId() {
            return this.id;
        }

        public String[] getParams() {
            return this.params;
        }

        public long getLastActivation() {
            return this.lastActivation;
        }

        public void stopTask() {
            this.task.onDestroy();
            if (this.scheduled != null) {
                this.scheduled.cancel(true);
            }
            TaskManager.this._currentTasks.remove((Object)this);
        }
    }
}

