/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.util.FloodProtectorConfig;
import com.l2jserver.gameserver.util.StringUtil;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FloodProtectorAction {
    private static final Logger _log = Logger.getLogger(FloodProtectorAction.class.getName());
    private final L2PcInstance _player;
    private final FloodProtectorConfig _config;
    private volatile int _nextGameTick = GameTimeController.getGameTicks();
    private AtomicInteger _count = new AtomicInteger(0);
    private boolean _logged;
    private volatile boolean _punishmentInProgress;

    public FloodProtectorAction(L2PcInstance player, FloodProtectorConfig config) {
        this._player = player;
        this._config = config;
    }

    public boolean tryPerformAction(String command) {
        int curTick = GameTimeController.getGameTicks();
        if (curTick < this._nextGameTick || this._punishmentInProgress) {
            if (this._config.LOG_FLOODING && !this._logged && _log.isLoggable(Level.WARNING)) {
                _log.warning(StringUtil.concat(this._config.FLOOD_PROTECTOR_TYPE, ": Player [", this._player.getName(), "] called command [", command, "] [~", String.valueOf((this._config.FLOOD_PROTECTION_INTERVAL - (this._nextGameTick - curTick)) * 100), " ms] after previous command"));
                this._logged = true;
            }
            this._count.incrementAndGet();
            if (!this._punishmentInProgress && this._config.PUNISHMENT_LIMIT > 0 && this._count.get() > this._config.PUNISHMENT_LIMIT && this._config.PUNISHMENT_TYPE != null) {
                this._punishmentInProgress = true;
                if ("kick".equals(this._config.PUNISHMENT_TYPE)) {
                    this.kickPlayer();
                } else if ("ban".equals(this._config.PUNISHMENT_TYPE)) {
                    this.banAccount();
                } else if ("jail".equals(this._config.PUNISHMENT_TYPE)) {
                    this.jailChar();
                }
                this._punishmentInProgress = false;
            }
            return false;
        }
        if (this._count.get() > 0 && this._config.LOG_FLOODING && _log.isLoggable(Level.WARNING)) {
            _log.warning(StringUtil.concat(this._config.FLOOD_PROTECTOR_TYPE, ": Player [", this._player.getName(), "] issued [", String.valueOf(this._count), "] extra requests within [~", String.valueOf(this._config.FLOOD_PROTECTION_INTERVAL * 100), " ms]"));
        }
        this._nextGameTick = curTick + this._config.FLOOD_PROTECTION_INTERVAL;
        this._logged = false;
        this._count.set(0);
        return true;
    }

    private void kickPlayer() {
        this._player.logout(false);
        if (_log.isLoggable(Level.WARNING)) {
            _log.warning(StringUtil.concat(this._config.FLOOD_PROTECTOR_TYPE, ": Account [", this._player.getAccountName(), "] kicked for flooding [char ", this._player.getName(), "]"));
        }
    }

    private void banAccount() {
        this._player.setPunishLevel(L2PcInstance.PunishLevel.ACC, this._config.PUNISHMENT_TIME);
        if (_log.isLoggable(Level.WARNING)) {
            _log.warning(StringUtil.concat(this._config.FLOOD_PROTECTOR_TYPE, ": Account [", this._player.getAccountName(), "] banned for flooding [char ", this._player.getName(), "] ", this._config.PUNISHMENT_TIME <= 0 ? "forever" : "for " + this._config.PUNISHMENT_TIME + " mins"));
        }
        this._player.logout();
    }

    private void jailChar() {
        this._player.setPunishLevel(L2PcInstance.PunishLevel.JAIL, this._config.PUNISHMENT_TIME);
        if (_log.isLoggable(Level.WARNING)) {
            _log.warning(StringUtil.concat(this._config.FLOOD_PROTECTOR_TYPE, ": Player [", this._player.getName(), "] jailed for flooding [char ", this._player.getName(), "] ", this._config.PUNISHMENT_TIME <= 0 ? "forever" : "for " + this._config.PUNISHMENT_TIME + " mins"));
        }
    }
}

