/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarClassLoader
extends ClassLoader {
    private static Logger _log = Logger.getLogger(JarClassLoader.class.getCanonicalName());
    HashSet<String> _jars = new HashSet();

    public void addJarFile(String filename) {
        this._jars.add(filename);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            byte[] b = this.loadClassData(name);
            return this.defineClass(name, b, 0, b.length);
        }
        catch (Exception e) {
            throw new ClassNotFoundException(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassData(String name) throws IOException {
        byte[] classData = null;
        for (String jarFile : this._jars) {
            ZipFile zipFile = null;
            FilterInputStream zipStream = null;
            try {
                File file = new File(jarFile);
                zipFile = new ZipFile(file);
                String fileName = name.replace('.', '/') + ".class";
                ZipEntry entry = zipFile.getEntry(fileName);
                if (entry == null) continue;
                classData = new byte[(int)entry.getSize()];
                zipStream = new DataInputStream(zipFile.getInputStream(entry));
                ((DataInputStream)zipStream).readFully(classData, 0, (int)entry.getSize());
                break;
            }
            catch (IOException e) {
                _log.log(Level.WARNING, jarFile + ":" + e.toString(), e);
            }
            finally {
                try {
                    zipFile.close();
                }
                catch (Exception e) {}
                try {
                    zipStream.close();
                }
                catch (Exception e) {}
            }
        }
        if (classData == null) {
            throw new IOException("class not found in " + this._jars);
        }
        return classData;
    }
}

