/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gsregistering;

import com.l2jserver.gsregistering.BaseGameServerRegister;
import com.l2jserver.loginserver.GameServerTable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.sql.SQLException;
import java.util.Map;
import java.util.ResourceBundle;

public class GameServerRegister
extends BaseGameServerRegister {
    private LineNumberReader _in;

    public static void main(String[] args) {
        BaseGameServerRegister.main(args);
    }

    public GameServerRegister(ResourceBundle bundle) {
        super(bundle);
        this.load();
        int size = GameServerTable.getInstance().getServerNames().size();
        if (size == 0) {
            System.out.println(this.getBundle().getString("noServerNames"));
            System.exit(1);
        }
    }

    public void consoleUI() throws IOException {
        this._in = new LineNumberReader(new InputStreamReader(System.in));
        boolean choiceOk = false;
        while (true) {
            this.hr();
            System.out.println("GSRegister");
            System.out.println('\n');
            System.out.println("1 - " + this.getBundle().getString("cmdMenuRegister"));
            System.out.println("2 - " + this.getBundle().getString("cmdMenuListNames"));
            System.out.println("3 - " + this.getBundle().getString("cmdMenuRemoveGS"));
            System.out.println("4 - " + this.getBundle().getString("cmdMenuRemoveAll"));
            System.out.println("5 - " + this.getBundle().getString("cmdMenuExit"));
            do {
                System.out.print(this.getBundle().getString("yourChoice") + ' ');
                String choice = this._in.readLine();
                try {
                    int choiceNumber = Integer.parseInt(choice);
                    choiceOk = true;
                    switch (choiceNumber) {
                        case 1: {
                            this.registerNewGS();
                            break;
                        }
                        case 2: {
                            this.listGSNames();
                            break;
                        }
                        case 3: {
                            this.unregisterSingleGS();
                            break;
                        }
                        case 4: {
                            this.unregisterAllGS();
                            break;
                        }
                        case 5: {
                            System.exit(0);
                            break;
                        }
                        default: {
                            System.out.printf(this.getBundle().getString("invalidChoice") + '\n', choice);
                            choiceOk = false;
                            break;
                        }
                    }
                }
                catch (NumberFormatException nfe) {
                    System.out.printf(this.getBundle().getString("invalidChoice") + '\n', choice);
                }
            } while (!choiceOk);
        }
    }

    private void hr() {
        System.out.println("_____________________________________________________\n");
    }

    private void listGSNames() {
        int idMaxLen = 0;
        int nameMaxLen = 0;
        for (Map.Entry<Integer, String> e : GameServerTable.getInstance().getServerNames().entrySet()) {
            if (e.getKey().toString().length() > idMaxLen) {
                idMaxLen = e.getKey().toString().length();
            }
            if (e.getValue().length() <= nameMaxLen) continue;
            nameMaxLen = e.getValue().length();
        }
        idMaxLen += 2;
        nameMaxLen += 2;
        String gsInUse = this.getBundle().getString("gsInUse");
        String gsFree = this.getBundle().getString("gsFree");
        int gsStatusMaxLen = Math.max(gsInUse.length(), gsFree.length()) + 2;
        for (Map.Entry<Integer, String> e : GameServerTable.getInstance().getServerNames().entrySet()) {
            int i;
            String id = e.getKey().toString();
            System.out.print(id);
            for (i = id.length(); i < idMaxLen; ++i) {
                System.out.print(' ');
            }
            System.out.print("| ");
            System.out.print(e.getValue());
            for (i = e.getValue().length(); i < nameMaxLen; ++i) {
                System.out.print(' ');
            }
            System.out.print("| ");
            boolean inUse = GameServerTable.getInstance().hasRegisteredGameServerOnId(e.getKey());
            String inUseStr = inUse ? gsInUse : gsFree;
            System.out.print(inUseStr);
            for (int i2 = inUseStr.length(); i2 < gsStatusMaxLen; ++i2) {
                System.out.print(' ');
            }
            System.out.println('|');
        }
    }

    private void unregisterAllGS() throws IOException {
        if (this.yesNoQuestion(this.getBundle().getString("confirmRemoveAllText"))) {
            try {
                BaseGameServerRegister.unregisterAllGameServers();
                System.out.println(this.getBundle().getString("unregisterAllOk"));
            }
            catch (SQLException e) {
                this.showError(this.getBundle().getString("sqlErrorUnregisterAll"), e);
            }
        }
    }

    private boolean yesNoQuestion(String question) throws IOException {
        while (true) {
            this.hr();
            System.out.println(question);
            System.out.println("1 - " + this.getBundle().getString("yes"));
            System.out.println("2 - " + this.getBundle().getString("no"));
            System.out.print(this.getBundle().getString("yourChoice") + ' ');
            String choice = this._in.readLine();
            if (choice.equals("1")) {
                return true;
            }
            if (choice.equals("2")) {
                return false;
            }
            System.out.printf(this.getBundle().getString("invalidChoice") + '\n', choice);
        }
    }

    private void unregisterSingleGS() throws IOException {
        int id = Integer.MIN_VALUE;
        do {
            System.out.print(this.getBundle().getString("enterDesiredId") + ' ');
            String line = this._in.readLine();
            try {
                id = Integer.parseInt(line);
            }
            catch (NumberFormatException e) {
                System.out.printf(this.getBundle().getString("invalidChoice") + '\n', line);
            }
        } while (id == Integer.MIN_VALUE);
        String name = GameServerTable.getInstance().getServerNameById(id);
        if (name == null) {
            System.out.printf(this.getBundle().getString("noNameForId") + '\n', id);
        } else if (GameServerTable.getInstance().hasRegisteredGameServerOnId(id)) {
            System.out.printf(this.getBundle().getString("confirmRemoveText") + '\n', id, name);
            try {
                BaseGameServerRegister.unregisterGameServer(id);
                System.out.printf(this.getBundle().getString("unregisterOk") + '\n', id);
            }
            catch (SQLException e) {
                this.showError(this.getBundle().getString("sqlErrorUnregister"), e);
            }
        } else {
            System.out.printf(this.getBundle().getString("noServerForId") + '\n', id);
        }
    }

    private void registerNewGS() throws IOException {
        int id = Integer.MIN_VALUE;
        do {
            System.out.println(this.getBundle().getString("enterDesiredId"));
            String line = this._in.readLine();
            try {
                id = Integer.parseInt(line);
            }
            catch (NumberFormatException e) {
                System.out.printf(this.getBundle().getString("invalidChoice") + '\n', line);
            }
        } while (id == Integer.MIN_VALUE);
        String name = GameServerTable.getInstance().getServerNameById(id);
        if (name == null) {
            System.out.printf(this.getBundle().getString("noNameForId") + '\n', id);
        } else if (GameServerTable.getInstance().hasRegisteredGameServerOnId(id)) {
            System.out.println(this.getBundle().getString("idIsNotFree"));
        } else {
            try {
                BaseGameServerRegister.registerGameServer(id, ".");
            }
            catch (IOException e) {
                this.showError(this.getBundle().getString("ioErrorRegister"), e);
            }
        }
    }

    @Override
    public void showError(String msg, Throwable t) {
        String title;
        if (this.getBundle() != null) {
            title = this.getBundle().getString("error");
            msg = msg + '\n' + this.getBundle().getString("reason") + ' ' + t.getLocalizedMessage();
        } else {
            title = "Error";
            msg = msg + "\nCause: " + t.getLocalizedMessage();
        }
        System.out.println(title + ": " + msg);
    }
}

