/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.cache;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.cache.FastMRUCache;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Clan;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class CrestCache {
    private static Logger _log = Logger.getLogger(CrestCache.class.getName());
    private FastMRUCache<Integer, byte[]> _cachePledge = new FastMRUCache();
    private FastMRUCache<Integer, byte[]> _cachePledgeLarge = new FastMRUCache();
    private FastMRUCache<Integer, byte[]> _cacheAlly = new FastMRUCache();
    private int _loadedFiles;
    private long _bytesBuffLen;

    public static CrestCache getInstance() {
        return SingletonHolder._instance;
    }

    private CrestCache() {
        this.convertOldPedgeFiles();
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        BmpFilter filter = new BmpFilter();
        File dir = new File(Config.DATAPACK_ROOT, "data/crests/");
        File[] files = dir.listFiles(filter);
        CrestCache crestCache = this;
        synchronized (crestCache) {
            this._loadedFiles = 0;
            this._bytesBuffLen = 0L;
            this._cachePledge.clear();
            this._cachePledgeLarge.clear();
            this._cacheAlly.clear();
        }
        FastMap<Integer, byte[]> _mapPledge = this._cachePledge.getContentMap();
        FastMap<Integer, byte[]> _mapPledgeLarge = this._cachePledgeLarge.getContentMap();
        FastMap<Integer, byte[]> _mapAlly = this._cacheAlly.getContentMap();
        for (File file : files) {
            RandomAccessFile f = null;
            CrestCache crestCache2 = this;
            synchronized (crestCache2) {
                try {
                    f = new RandomAccessFile(file, "r");
                    byte[] content = new byte[(int)f.length()];
                    f.readFully(content);
                    if (file.getName().startsWith("Crest_Large_")) {
                        _mapPledgeLarge.put((Object)Integer.valueOf(file.getName().substring(12, file.getName().length() - 4)), (Object)content);
                    } else if (file.getName().startsWith("Crest_")) {
                        _mapPledge.put((Object)Integer.valueOf(file.getName().substring(6, file.getName().length() - 4)), (Object)content);
                    } else if (file.getName().startsWith("AllyCrest_")) {
                        _mapAlly.put((Object)Integer.valueOf(file.getName().substring(10, file.getName().length() - 4)), (Object)content);
                    }
                    ++this._loadedFiles;
                    this._bytesBuffLen += (long)content.length;
                }
                catch (Exception e) {
                    _log.warning("problem with crest bmp file " + e);
                }
                finally {
                    try {
                        f.close();
                    }
                    catch (Exception e1) {}
                }
            }
        }
        _log.info("Cache[Crest]: " + String.format("%.3f", Float.valueOf(this.getMemoryUsage())) + "MB on " + this.getLoadedFiles() + " files loaded. (Forget Time: " + this._cachePledge.getForgetTime() / 1000 + "s , Capacity: " + this._cachePledge.capacity() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertOldPedgeFiles() {
        File[] files;
        File dir = new File(Config.DATAPACK_ROOT, "data/crests/");
        for (File file : files = dir.listFiles(new OldPledgeFilter())) {
            int clanId = Integer.parseInt(file.getName().substring(7, file.getName().length() - 4));
            _log.info("Found old crest file \"" + file.getName() + "\" for clanId " + clanId);
            int newId = IdFactory.getInstance().getNextId();
            L2Clan clan = ClanTable.getInstance().getClan(clanId);
            if (clan != null) {
                this.removeOldPledgeCrest(clan.getCrestId());
                file.renameTo(new File(Config.DATAPACK_ROOT, "data/crests/Crest_" + newId + ".bmp"));
                _log.info("Renamed Clan crest to new format: Crest_" + newId + ".bmp");
                Connection con = null;
                try {
                    con = L2DatabaseFactory.getInstance().getConnection();
                    PreparedStatement statement = con.prepareStatement("UPDATE clan_data SET crest_id = ? WHERE clan_id = ?");
                    statement.setInt(1, newId);
                    statement.setInt(2, clan.getClanId());
                    statement.executeUpdate();
                    statement.close();
                }
                catch (SQLException e) {
                    _log.warning("could not update the crest id:" + e.getMessage());
                }
                finally {
                    try {
                        con.close();
                    }
                    catch (Exception e) {}
                }
                clan.setCrestId(newId);
                clan.setHasCrest(true);
                continue;
            }
            _log.info("Clan Id: " + clanId + " does not exist in table.. deleting.");
            file.delete();
        }
    }

    public float getMemoryUsage() {
        return (float)this._bytesBuffLen / 1048576.0f;
    }

    public int getLoadedFiles() {
        return this._loadedFiles;
    }

    public byte[] getPledgeCrest(int id) {
        return this._cachePledge.get(id);
    }

    public byte[] getPledgeCrestLarge(int id) {
        return this._cachePledgeLarge.get(id);
    }

    public byte[] getAllyCrest(int id) {
        return this._cacheAlly.get(id);
    }

    public void removePledgeCrest(int id) {
        File crestFile = new File(Config.DATAPACK_ROOT, "data/crests/Crest_" + id + ".bmp");
        this._cachePledge.remove(id);
        try {
            crestFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removePledgeCrestLarge(int id) {
        File crestFile = new File(Config.DATAPACK_ROOT, "data/crests/Crest_Large_" + id + ".bmp");
        this._cachePledgeLarge.remove(id);
        try {
            crestFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeOldPledgeCrest(int id) {
        File crestFile = new File(Config.DATAPACK_ROOT, "data/crests/Pledge_" + id + ".bmp");
        try {
            crestFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeAllyCrest(int id) {
        File crestFile = new File(Config.DATAPACK_ROOT, "data/crests/AllyCrest_" + id + ".bmp");
        this._cacheAlly.remove(id);
        try {
            crestFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean savePledgeCrest(int newId, byte[] data) {
        File crestFile = new File(Config.DATAPACK_ROOT, "data/crests/Crest_" + newId + ".bmp");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(crestFile);
            out.write(data);
            this._cachePledge.getContentMap().put((Object)newId, (Object)data);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            _log.log(Level.INFO, "Error saving pledge crest" + crestFile + ":", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean savePledgeCrestLarge(int newId, byte[] data) {
        File crestFile = new File(Config.DATAPACK_ROOT, "data/crests/Crest_Large_" + newId + ".bmp");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(crestFile);
            out.write(data);
            this._cachePledgeLarge.getContentMap().put((Object)newId, (Object)data);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            _log.log(Level.INFO, "Error saving Large pledge crest" + crestFile + ":", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAllyCrest(int newId, byte[] data) {
        File crestFile = new File(Config.DATAPACK_ROOT, "data/crests/AllyCrest_" + newId + ".bmp");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(crestFile);
            out.write(data);
            this._cacheAlly.getContentMap().put((Object)newId, (Object)data);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            _log.log(Level.INFO, "Error saving ally crest" + crestFile + ":", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {}
        }
    }

    private static class SingletonHolder {
        protected static final CrestCache _instance = new CrestCache();

        private SingletonHolder() {
        }
    }

    class OldPledgeFilter
    implements FileFilter {
        OldPledgeFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().startsWith("Pledge_");
        }
    }

    class BmpFilter
    implements FileFilter {
        BmpFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(".bmp");
        }
    }
}

