/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2PetData;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import gnu.trove.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Logger;

public class PetDataTable {
    private static Logger _log = Logger.getLogger(L2PetInstance.class.getName());
    private static TIntObjectHashMap<TIntObjectHashMap<L2PetData>> _petTable;

    public static PetDataTable getInstance() {
        return SingletonHolder._instance;
    }

    private PetDataTable() {
        _petTable = new TIntObjectHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPetsData() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT typeID, level, expMax, hpMax, mpMax, patk, pdef, matk, mdef, acc, evasion, crit, speed, atk_speed, cast_speed, feedMax, feedbattle, feednormal, loadMax, hpregen, mpregen, owner_exp_taken, soulshot_count, spiritshot_count FROM pets_stats");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int petId = rset.getInt("typeID");
                int petLevel = rset.getInt("level");
                L2PetData petData = new L2PetData();
                petData.setPetID(petId);
                petData.setPetLevel(petLevel);
                petData.setPetMaxExp(rset.getLong("expMax"));
                petData.setPetMaxHP(rset.getInt("hpMax"));
                petData.setPetMaxMP(rset.getInt("mpMax"));
                petData.setPetPAtk(rset.getInt("patk"));
                petData.setPetPDef(rset.getInt("pdef"));
                petData.setPetMAtk(rset.getInt("matk"));
                petData.setPetMDef(rset.getInt("mdef"));
                petData.setPetAccuracy(rset.getInt("acc"));
                petData.setPetEvasion(rset.getInt("evasion"));
                petData.setPetCritical(rset.getInt("crit"));
                petData.setPetSpeed(rset.getInt("speed"));
                petData.setPetAtkSpeed(rset.getInt("atk_speed"));
                petData.setPetCastSpeed(rset.getInt("cast_speed"));
                petData.setPetMaxFeed(rset.getInt("feedMax"));
                petData.setPetFeedNormal(rset.getInt("feednormal"));
                petData.setPetFeedBattle(rset.getInt("feedbattle"));
                petData.setPetMaxLoad(rset.getInt("loadMax"));
                petData.setPetRegenHP(rset.getInt("hpregen"));
                petData.setPetRegenMP(rset.getInt("mpregen"));
                petData.setOwnerExpTaken(rset.getFloat("owner_exp_taken"));
                petData.setPetSoulShot((short)rset.getInt("soulshot_count"));
                petData.setPetSpiritShot((short)rset.getInt("spiritshot_count"));
                if (!_petTable.containsKey(petId)) {
                    _petTable.put(petId, (Object)new TIntObjectHashMap());
                }
                ((TIntObjectHashMap)_petTable.get(petId)).put(petLevel, (Object)petData);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("Could not load pets stats: " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public void addPetData(L2PetData petData) {
        TIntObjectHashMap h = (TIntObjectHashMap)_petTable.get(petData.getPetID());
        if (h == null) {
            TIntObjectHashMap statTable = new TIntObjectHashMap();
            statTable.put(petData.getPetLevel(), (Object)petData);
            _petTable.put(petData.getPetID(), (Object)statTable);
            return;
        }
        h.put(petData.getPetLevel(), (Object)petData);
    }

    public void addPetData(L2PetData[] petLevelsList) {
        for (L2PetData petData : petLevelsList) {
            this.addPetData(petData);
        }
    }

    public L2PetData getPetData(int petID, int petLevel) {
        return (L2PetData)((TIntObjectHashMap)_petTable.get(petID)).get(petLevel);
    }

    public static boolean isWolf(int npcId) {
        return npcId == 12077;
    }

    public static boolean isEvolvedWolf(int npcId) {
        return npcId == 16030 || npcId == 16037 || npcId == 16025 || npcId == 16041 || npcId == 16042;
    }

    public static boolean isSinEater(int npcId) {
        return npcId == 12564;
    }

    public static boolean isHatchling(int npcId) {
        return npcId > 12310 && npcId < 12314;
    }

    public static boolean isStrider(int npcId) {
        return npcId > 12525 && npcId < 12529 || npcId > 16037 && npcId < 16041 || npcId == 16068;
    }

    public static boolean isWyvern(int npcId) {
        return npcId == 12621;
    }

    public static boolean isBaby(int npcId) {
        return npcId > 12779 && npcId < 12783;
    }

    public static boolean isImprovedBaby(int npcId) {
        return npcId > 16033 && npcId < 16037;
    }

    public static boolean isPetFood(int itemId) {
        switch (itemId) {
            case 2515: 
            case 4038: 
            case 5168: 
            case 5169: 
            case 6316: 
            case 7582: 
            case 9668: 
            case 10425: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWolfFood(int itemId) {
        return itemId == 2515;
    }

    public static boolean isEvolvedWolfFood(int itemId) {
        return itemId == 9668;
    }

    public static boolean isSinEaterFood(int itemId) {
        return itemId == 2515;
    }

    public static boolean isHatchlingFood(int itemId) {
        return itemId == 4038;
    }

    public static boolean isStriderFood(int itemId) {
        return itemId == 5168 || itemId == 5169;
    }

    public static boolean isWyvernFood(int itemId) {
        return itemId == 6316;
    }

    public static boolean isBabyFood(int itemId) {
        return itemId == 7582;
    }

    public static boolean isImprovedBabyFood(int itemId) {
        return itemId == 10425;
    }

    public static int[] getFoodItemId(int npcId) {
        switch (npcId) {
            case 12077: 
            case 12564: {
                return new int[]{2515};
            }
            case 16025: 
            case 16030: 
            case 16037: 
            case 16041: 
            case 16042: {
                return new int[]{9668};
            }
            case 12311: 
            case 12312: 
            case 12313: {
                return new int[]{4038};
            }
            case 12526: 
            case 12527: 
            case 12528: 
            case 16038: 
            case 16039: 
            case 16040: 
            case 16068: {
                return new int[]{5168, 5169};
            }
            case 12621: {
                return new int[]{6316};
            }
            case 12780: 
            case 12781: 
            case 12782: {
                return new int[]{7582};
            }
            case 16034: 
            case 16035: 
            case 16036: {
                return new int[]{10425};
            }
        }
        return new int[]{0};
    }

    public static boolean isPetItem(int itemId) {
        switch (itemId) {
            case 2375: 
            case 3500: 
            case 3501: 
            case 3502: 
            case 4422: 
            case 4423: 
            case 4424: 
            case 4425: 
            case 6648: 
            case 6649: 
            case 6650: 
            case 8663: 
            case 9882: 
            case 10163: 
            case 10307: 
            case 10308: 
            case 10309: 
            case 10310: 
            case 10311: 
            case 10312: 
            case 10313: 
            case 10426: 
            case 10611: 
            case 14819: {
                return true;
            }
        }
        return false;
    }

    public static int[] getPetItemsByNpc(int npcId) {
        switch (npcId) {
            case 12077: {
                return new int[]{2375};
            }
            case 16025: {
                return new int[]{9882};
            }
            case 16030: {
                return new int[]{10163};
            }
            case 16037: {
                return new int[]{10307};
            }
            case 16041: {
                return new int[]{10426};
            }
            case 16042: {
                return new int[]{10611};
            }
            case 12564: {
                return new int[]{4425};
            }
            case 12311: 
            case 12312: 
            case 12313: {
                return new int[]{3500, 3501, 3502};
            }
            case 12526: 
            case 12527: 
            case 12528: 
            case 16038: 
            case 16039: 
            case 16040: 
            case 16068: {
                return new int[]{4422, 4423, 4424, 10308, 10309, 10310, 14819};
            }
            case 12621: {
                return new int[]{8663};
            }
            case 12780: 
            case 12781: 
            case 12782: {
                return new int[]{6648, 6649, 6650};
            }
            case 16034: 
            case 16035: 
            case 16036: {
                return new int[]{10311, 10312, 10313};
            }
        }
        return new int[]{0};
    }

    public static boolean isMountable(int npcId) {
        return npcId == 12526 || npcId == 12527 || npcId == 12528 || npcId == 12621 || npcId == 16037 || npcId == 16041 || npcId == 16042 || npcId == 16038 || npcId == 16039 || npcId == 16040 || npcId == 16068;
    }

    private static class SingletonHolder {
        protected static final PetDataTable _instance = new PetDataTable();

        private SingletonHolder() {
        }
    }
}

