/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.skills.SkillsEngine;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;

public class SkillTable {
    private final TIntObjectHashMap<L2Skill> _skills = new TIntObjectHashMap();
    private final TIntIntHashMap _skillMaxLevel = new TIntIntHashMap();

    public static SkillTable getInstance() {
        return SingletonHolder._instance;
    }

    private SkillTable() {
        this.reload();
    }

    public void reload() {
        this._skills.clear();
        SkillsEngine.getInstance().loadAllSkills(this._skills);
        this._skillMaxLevel.clear();
        for (L2Skill skill : (L2Skill[])this._skills.getValues((Object[])new L2Skill[this._skills.size()])) {
            int maxLvl;
            int skillId = skill.getId();
            int skillLvl = skill.getLevel();
            if (skillLvl <= (maxLvl = this._skillMaxLevel.get(skillId))) continue;
            this._skillMaxLevel.put(skillId, skillLvl);
        }
    }

    public static int getSkillHashCode(L2Skill skill) {
        return SkillTable.getSkillHashCode(skill.getId(), skill.getLevel());
    }

    public static int getSkillHashCode(int skillId, int skillLevel) {
        return skillId * 1021 + skillLevel;
    }

    public final L2Skill getInfo(int skillId, int level) {
        L2Skill result = (L2Skill)this._skills.get(SkillTable.getSkillHashCode(skillId, level));
        if (result != null) {
            return result;
        }
        int maxLvl = this._skillMaxLevel.get(skillId);
        if (maxLvl > 0 && level > maxLvl) {
            return (L2Skill)this._skills.get(SkillTable.getSkillHashCode(skillId, maxLvl));
        }
        return null;
    }

    public final int getMaxLevel(int skillId) {
        return this._skillMaxLevel.get(skillId);
    }

    public L2Skill[] getSiegeSkills(boolean addNoble) {
        L2Skill[] temp = null;
        if (addNoble) {
            temp = new L2Skill[3];
            temp[2] = (L2Skill)this._skills.get(SkillTable.getSkillHashCode(326, 1));
        } else {
            temp = new L2Skill[]{(L2Skill)this._skills.get(SkillTable.getSkillHashCode(246, 1)), (L2Skill)this._skills.get(SkillTable.getSkillHashCode(247, 1))};
        }
        return temp;
    }

    private static class SingletonHolder {
        protected static final SkillTable _instance = new SkillTable();

        private SingletonHolder() {
        }
    }
}

