/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.geoeditorcon;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Logger;
import javolution.util.FastList;

public class GeoEditorThread
extends Thread {
    private static Logger _log = Logger.getLogger(GeoEditorThread.class.getName());
    private boolean _working = false;
    private int _mode = 0;
    private int _sendDelay = 1000;
    private Socket _geSocket;
    private OutputStream _out;
    private FastList<L2PcInstance> _gms;

    public GeoEditorThread(Socket ge) {
        this._geSocket = ge;
        this._working = true;
        this._gms = new FastList();
    }

    @Override
    public void interrupt() {
        try {
            this._geSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._out = this._geSocket.getOutputStream();
            int timer = 0;
            while (this._working) {
                if (!this.isConnected()) {
                    this._working = false;
                }
                if (this._mode == 2 && timer > this._sendDelay) {
                    for (L2PcInstance gm : this._gms) {
                        if (!gm.getClient().getConnection().isClosed()) {
                            this.sendGmPosition(gm);
                            continue;
                        }
                        this._gms.remove((Object)gm);
                    }
                    timer = 0;
                }
                try {
                    GeoEditorThread.sleep(100L);
                    if (this._mode != 2) continue;
                    timer += 100;
                }
                catch (Exception exception) {}
            }
        }
        catch (SocketException e) {
            _log.warning("GeoEditor disconnected. " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this._geSocket.close();
            }
            catch (Exception e) {}
            this._working = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendGmPosition(int gx, int gy, short z) {
        if (!this.isConnected()) {
            return;
        }
        try {
            OutputStream outputStream = this._out;
            synchronized (outputStream) {
                this.writeC(11);
                this.writeC(1);
                this.writeD(gx);
                this.writeD(gy);
                this.writeH(z);
                this._out.flush();
            }
        }
        catch (SocketException e) {
            _log.warning("GeoEditor disconnected. " + e.getMessage());
            this._working = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this._geSocket.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this._working = false;
        }
    }

    public void sendGmPosition(L2PcInstance _gm) {
        this.sendGmPosition(_gm.getX(), _gm.getY(), (short)_gm.getZ());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPing() {
        if (!this.isConnected()) {
            return;
        }
        try {
            OutputStream outputStream = this._out;
            synchronized (outputStream) {
                this.writeC(1);
                this.writeC(2);
                this._out.flush();
            }
        }
        catch (SocketException e) {
            _log.warning("GeoEditor disconnected. " + e.getMessage());
            this._working = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this._geSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._working = false;
        }
    }

    private void writeD(int value) throws IOException {
        this._out.write(value & 0xFF);
        this._out.write(value >> 8 & 0xFF);
        this._out.write(value >> 16 & 0xFF);
        this._out.write(value >> 24 & 0xFF);
    }

    private void writeH(int value) throws IOException {
        this._out.write(value & 0xFF);
        this._out.write(value >> 8 & 0xFF);
    }

    private void writeC(int value) throws IOException {
        this._out.write(value & 0xFF);
    }

    public void setMode(int value) {
        this._mode = value;
    }

    public void setTimer(int value) {
        this._sendDelay = value < 500 ? 500 : (value > 60000 ? 60000 : value);
    }

    public void addGM(L2PcInstance gm) {
        if (!this._gms.contains((Object)gm)) {
            this._gms.add((Object)gm);
        }
    }

    public void removeGM(L2PcInstance gm) {
        if (this._gms.contains((Object)gm)) {
            this._gms.remove((Object)gm);
        }
    }

    public boolean isSend(L2PcInstance gm) {
        return this._mode == 1 && this._gms.contains((Object)gm);
    }

    private boolean isConnected() {
        return this._geSocket.isConnected() && !this._geSocket.isClosed();
    }

    public boolean isWorking() {
        this.sendPing();
        return this._working;
    }

    public int getMode() {
        return this._mode;
    }
}

