/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Instance;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.logging.Logger;
import javolution.io.UTF8StreamReader;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamReaderImpl;

public class InstanceManager {
    private static final Logger _log = Logger.getLogger(InstanceManager.class.getName());
    private FastMap<Integer, Instance> _instanceList = new FastMap();
    private FastMap<Integer, InstanceWorld> _instanceWorlds = new FastMap();
    private int _dynamic = 300000;
    private static final Map<Integer, String> _instanceIdNames = new FastMap();
    private Map<Integer, Map<Integer, Long>> _playerInstanceTimes = new FastMap();
    private static final String ADD_INSTANCE_TIME = "INSERT INTO character_instance_time (charId,instanceId,time) values (?,?,?) ON DUPLICATE KEY UPDATE time=?";
    private static final String RESTORE_INSTANCE_TIMES = "SELECT instanceId,time FROM character_instance_time WHERE charId=?";
    private static final String DELETE_INSTANCE_TIME = "DELETE FROM character_instance_time WHERE charId=? AND instanceId=?";

    public long getInstanceTime(int playerObjId, int id) {
        if (!this._playerInstanceTimes.containsKey(playerObjId)) {
            this.restoreInstanceTimes(playerObjId);
        }
        if (this._playerInstanceTimes.get(playerObjId).containsKey(id)) {
            return this._playerInstanceTimes.get(playerObjId).get(id);
        }
        return -1L;
    }

    public Map<Integer, Long> getAllInstanceTimes(int playerObjId) {
        if (!this._playerInstanceTimes.containsKey(playerObjId)) {
            this.restoreInstanceTimes(playerObjId);
        }
        return this._playerInstanceTimes.get(playerObjId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstanceTime(int playerObjId, int id, long time) {
        if (!this._playerInstanceTimes.containsKey(playerObjId)) {
            this.restoreInstanceTimes(playerObjId);
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = null;
            statement = con.prepareStatement(ADD_INSTANCE_TIME);
            statement.setInt(1, playerObjId);
            statement.setInt(2, id);
            statement.setLong(3, time);
            statement.setLong(4, time);
            statement.execute();
            statement.close();
            this._playerInstanceTimes.get(playerObjId).put(id, time);
        }
        catch (Exception e) {
            _log.warning("Could not insert character instance time data: " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteInstanceTime(int playerObjId, int id) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = null;
            statement = con.prepareStatement(DELETE_INSTANCE_TIME);
            statement.setInt(1, playerObjId);
            statement.setInt(2, id);
            statement.execute();
            statement.close();
            this._playerInstanceTimes.get(playerObjId).remove(id);
        }
        catch (Exception e) {
            _log.warning("Could not delete character instance time data: " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreInstanceTimes(int playerObjId) {
        if (this._playerInstanceTimes.containsKey(playerObjId)) {
            return;
        }
        this._playerInstanceTimes.put(playerObjId, (Map<Integer, Long>)new FastMap());
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(RESTORE_INSTANCE_TIMES);
            statement.setInt(1, playerObjId);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int id = rset.getInt("instanceId");
                long time = rset.getLong("time");
                if (time < System.currentTimeMillis()) {
                    this.deleteInstanceTime(playerObjId, id);
                    continue;
                }
                this._playerInstanceTimes.get(playerObjId).put(id, time);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("Could not delete character instance time data: " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public String getInstanceIdName(int id) {
        if (_instanceIdNames.containsKey(id)) {
            return _instanceIdNames.get(id);
        }
        return "UnknownInstance";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInstanceNames() {
        InputStream in = null;
        try {
            in = new FileInputStream(Config.DATAPACK_ROOT + "/data/instancenames.xml");
            XMLStreamReaderImpl xpp = new XMLStreamReaderImpl();
            xpp.setInput((Reader)new UTF8StreamReader().setInput(in));
            int e = xpp.getEventType();
            while (e != 8) {
                if (e == 1 && xpp.getLocalName().toString().equals("instance")) {
                    Integer id = Integer.valueOf(xpp.getAttributeValue(null, (CharSequence)"id").toString());
                    String name = xpp.getAttributeValue(null, (CharSequence)"name").toString();
                    _instanceIdNames.put(id, name);
                }
                e = xpp.next();
            }
        }
        catch (FileNotFoundException e) {
            _log.warning("instancenames.xml could not be loaded: file not found");
        }
        catch (XMLStreamException xppe) {
            xppe.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
    }

    public void addWorld(InstanceWorld world) {
        this._instanceWorlds.put((Object)world.instanceId, (Object)world);
    }

    public InstanceWorld getWorld(int instanceId) {
        return (InstanceWorld)this._instanceWorlds.get((Object)instanceId);
    }

    public InstanceWorld getPlayerWorld(L2PcInstance player) {
        for (InstanceWorld temp : this._instanceWorlds.values()) {
            if (temp == null || !temp.allowed.contains((Object)player.getObjectId())) continue;
            return temp;
        }
        return null;
    }

    private InstanceManager() {
        _log.info("Initializing InstanceManager");
        this.loadInstanceNames();
        _log.info("Loaded " + _instanceIdNames.size() + " instance names");
        this.createWorld();
    }

    public static final InstanceManager getInstance() {
        return SingletonHolder._instance;
    }

    private void createWorld() {
        Instance themultiverse = new Instance(-1);
        themultiverse.setName("multiverse");
        this._instanceList.put((Object)-1, (Object)themultiverse);
        _log.info("Multiverse Instance created");
        Instance universe = new Instance(0);
        universe.setName("universe");
        this._instanceList.put((Object)0, (Object)universe);
        _log.info("Universe Instance created");
    }

    public void destroyInstance(int instanceid) {
        if (instanceid <= 0) {
            return;
        }
        Instance temp = (Instance)this._instanceList.get((Object)instanceid);
        if (temp != null) {
            temp.cancelQuestTimers();
            temp.removeNpcs();
            temp.removePlayers();
            temp.removeDoors();
            temp.cancelTimer();
            this._instanceList.remove((Object)instanceid);
            if (this._instanceWorlds.containsKey((Object)instanceid)) {
                this._instanceWorlds.remove((Object)instanceid);
            }
        }
    }

    public Instance getInstance(int instanceid) {
        return (Instance)this._instanceList.get((Object)instanceid);
    }

    public FastMap<Integer, Instance> getInstances() {
        return this._instanceList;
    }

    public int getPlayerInstance(int objectId) {
        for (Instance temp : this._instanceList.values()) {
            if (temp == null || !temp.containsPlayer(objectId)) continue;
            return temp.getId();
        }
        return 0;
    }

    public boolean createInstance(int id) {
        if (this.getInstance(id) != null) {
            return false;
        }
        Instance instance = new Instance(id);
        this._instanceList.put((Object)id, (Object)instance);
        return true;
    }

    public boolean createInstanceFromTemplate(int id, String template) throws FileNotFoundException {
        if (this.getInstance(id) != null) {
            return false;
        }
        Instance instance = new Instance(id);
        this._instanceList.put((Object)id, (Object)instance);
        instance.loadInstanceTemplate(template);
        return true;
    }

    public int createDynamicInstance(String template) {
        while (this.getInstance(this._dynamic) != null) {
            ++this._dynamic;
            if (this._dynamic != Integer.MAX_VALUE) continue;
            _log.warning("InstanceManager: More then 2147183647 instances created");
            this._dynamic = 300000;
        }
        Instance instance = new Instance(this._dynamic);
        this._instanceList.put((Object)this._dynamic, (Object)instance);
        if (template != null) {
            try {
                instance.loadInstanceTemplate(template);
            }
            catch (FileNotFoundException e) {
                _log.warning("InstanceManager: Failed creating instance from template " + template + ", " + e.getMessage());
                e.printStackTrace();
            }
        }
        return this._dynamic++;
    }

    private static class SingletonHolder {
        protected static final InstanceManager _instance = new InstanceManager();

        private SingletonHolder() {
        }
    }

    public class InstanceWorld {
        public int instanceId;
        public int templateId = -1;
        public FastList<Integer> allowed = new FastList();
        public int status;
    }
}

