/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.util.List;
import javolution.util.FastTable;

public final class L2EnchantSkillLearn {
    private final int _id;
    private final int _baseLvl;
    private List<EnchantSkillDetail>[] _enchantDetails = new List[0];

    public L2EnchantSkillLearn(int id, int baseLvl) {
        this._id = id;
        this._baseLvl = baseLvl;
    }

    public int getId() {
        return this._id;
    }

    public int getBaseLevel() {
        return this._baseLvl;
    }

    public void addEnchantDetail(EnchantSkillDetail esd) {
        int enchantType = L2EnchantSkillLearn.getEnchantType(esd.getLevel());
        if (enchantType < 0) {
            throw new IllegalArgumentException("Skill enchantments should have level higher then 100");
        }
        if (enchantType >= this._enchantDetails.length) {
            List[] newArray = new List[enchantType + 1];
            System.arraycopy(this._enchantDetails, 0, newArray, 0, this._enchantDetails.length);
            this._enchantDetails = newArray;
            this._enchantDetails[enchantType] = new FastTable();
        }
        int index = L2EnchantSkillLearn.getEnchantIndex(esd.getLevel());
        this._enchantDetails[enchantType].add(index, esd);
    }

    public List<EnchantSkillDetail>[] getEnchantRoutes() {
        return this._enchantDetails;
    }

    public EnchantSkillDetail getEnchantSkillDetail(int level) {
        int enchantType = L2EnchantSkillLearn.getEnchantType(level);
        if (enchantType < 0 || enchantType >= this._enchantDetails.length) {
            return null;
        }
        int index = L2EnchantSkillLearn.getEnchantIndex(level);
        if (index < 0 || index >= this._enchantDetails[enchantType].size()) {
            return null;
        }
        return this._enchantDetails[enchantType].get(index);
    }

    public static int getEnchantIndex(int level) {
        return level % 100 - 1;
    }

    public static int getEnchantType(int level) {
        return (level - 1) / 100 - 1;
    }

    public static class EnchantSkillDetail {
        private final int _level;
        private final int _spCost;
        private final int _minSkillLevel;
        private final int _exp;
        private final byte _rate76;
        private final byte _rate77;
        private final byte _rate78;
        private final byte _rate79;
        private final byte _rate80;
        private final byte _rate81;
        private final byte _rate82;
        private final byte _rate83;
        private final byte _rate84;
        private final byte _rate85;

        public EnchantSkillDetail(int lvl, int minSkillLvl, int cost, int exp, byte rate76, byte rate77, byte rate78, byte rate79, byte rate80, byte rate81, byte rate82, byte rate83, byte rate84, byte rate85) {
            this._level = lvl;
            this._minSkillLevel = minSkillLvl;
            this._spCost = cost;
            this._exp = exp;
            this._rate76 = rate76;
            this._rate77 = rate77;
            this._rate78 = rate78;
            this._rate79 = rate79;
            this._rate80 = rate80;
            this._rate81 = rate81;
            this._rate82 = rate82;
            this._rate83 = rate83;
            this._rate84 = rate84;
            this._rate85 = rate85;
        }

        public int getLevel() {
            return this._level;
        }

        public int getMinSkillLevel() {
            return this._minSkillLevel;
        }

        public int getSpCost() {
            return this._spCost;
        }

        public int getAdena() {
            return this._exp / 3;
        }

        public byte getRate(L2PcInstance ply) {
            byte result;
            switch (ply.getLevel()) {
                case 76: {
                    result = this._rate76;
                    break;
                }
                case 77: {
                    result = this._rate77;
                    break;
                }
                case 78: {
                    result = this._rate78;
                    break;
                }
                case 79: {
                    result = this._rate79;
                    break;
                }
                case 80: {
                    result = this._rate80;
                    break;
                }
                case 81: {
                    result = this._rate81;
                    break;
                }
                case 82: {
                    result = this._rate82;
                    break;
                }
                case 83: {
                    result = this._rate83;
                    break;
                }
                case 84: {
                    result = this._rate84;
                    break;
                }
                case 85: {
                    result = this._rate85;
                    break;
                }
                default: {
                    result = this._rate85;
                }
            }
            return result;
        }
    }
}

