/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2FortSiegeGuardAI;
import com.l2jserver.gameserver.ai.L2SiegeGuardAI;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.DefenderKnownList;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2DefenderInstance
extends L2Attackable {
    private Castle _castle = null;
    private Fort _fort = null;

    public L2DefenderInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public DefenderKnownList getKnownList() {
        return (DefenderKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new DefenderKnownList(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public L2CharacterAI getAI() {
        L2CharacterAI ai = this._ai;
        if (ai == null) {
            L2DefenderInstance l2DefenderInstance = this;
            synchronized (l2DefenderInstance) {
                if (this._ai == null) {
                    this._ai = this.getCastle() == null ? new L2FortSiegeGuardAI(new L2Character.AIAccessor()) : new L2SiegeGuardAI(new L2Character.AIAccessor());
                }
                return this._ai;
            }
        }
        return ai;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        if (!(attacker instanceof L2Playable)) {
            return false;
        }
        L2PcInstance player = attacker.getActingPlayer();
        if (this._fort != null && this._fort.getZone().isActive() || this._castle != null && this._castle.getZone().isActive()) {
            int activeSiegeId;
            int n = this._fort != null ? this._fort.getFortId() : (activeSiegeId = this._castle != null ? this._castle.getCastleId() : 0);
            if (player != null && (player.getSiegeState() == 2 && !player.isRegisteredOnThisSiegeField(activeSiegeId) || player.getSiegeState() == 1 || player.getSiegeState() == 0)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasRandomAnimation() {
        return false;
    }

    @Override
    public void returnHome() {
        if (this.getWalkSpeed() <= 0) {
            return;
        }
        if (this.getSpawn() == null) {
            return;
        }
        if (!this.isInsideRadius(this.getSpawn().getLocx(), this.getSpawn().getLocy(), 40, false)) {
            if (Config.DEBUG) {
                _log.info(this.getObjectId() + ": moving home");
            }
            this.setisReturningToSpawnPoint(true);
            this.clearAggroList();
            if (this.hasAI()) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(this.getSpawn().getLocx(), this.getSpawn().getLocy(), this.getSpawn().getLocz(), 0));
            }
        }
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this._fort = FortManager.getInstance().getFort(this.getX(), this.getY(), this.getZ());
        this._castle = CastleManager.getInstance().getCastle(this.getX(), this.getY(), this.getZ());
        if (this._fort == null && this._castle == null) {
            _log.warning("L2DefenderInstance spawned outside of Fortress or Castle Zone! NpcId: " + this.getNpcId() + " x=" + this.getX() + " y=" + this.getY() + " z=" + this.getZ());
        }
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (!this.canTarget(player)) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (this != player.getTarget()) {
            if (Config.DEBUG) {
                _log.info("new target selected:" + this.getObjectId());
            }
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            StatusUpdate su = new StatusUpdate(this.getObjectId());
            su.addAttribute(9, (int)this.getStatus().getCurrentHp());
            su.addAttribute(10, this.getMaxHp());
            player.sendPacket(su);
            player.sendPacket(new ValidateLocation(this));
        } else if (interact) {
            if (this.isAutoAttackable(player) && !this.isAlikeDead() && Math.abs(player.getZ() - this.getZ()) < 600) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
            }
            if (!this.isAutoAttackable(player) && !this.canInteract(player)) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
            }
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public void addDamageHate(L2Character attacker, int damage, int aggro) {
        if (attacker == null) {
            return;
        }
        if (!(attacker instanceof L2DefenderInstance)) {
            if (damage == 0 && aggro <= 1 && attacker instanceof L2Playable) {
                L2PcInstance player = attacker.getActingPlayer();
                if (this._fort != null && this._fort.getZone().isActive() || this._castle != null && this._castle.getZone().isActive()) {
                    int activeSiegeId;
                    int n = this._fort != null ? this._fort.getFortId() : (activeSiegeId = this._castle != null ? this._castle.getCastleId() : 0);
                    if (player != null && player.getSiegeState() == 2 && player.isRegisteredOnThisSiegeField(activeSiegeId)) {
                        return;
                    }
                }
            }
            super.addDamageHate(attacker, damage, aggro);
        }
    }
}

