/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.StringTokenizer;

public class L2FortSiegeNpcInstance
extends L2Npc {
    public L2FortSiegeNpcInstance(int objectID, L2NpcTemplate template) {
        super(objectID, template);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        StringTokenizer st = new StringTokenizer(command, " ");
        String actualCommand = st.nextToken();
        String par = "";
        if (st.countTokens() >= 1) {
            par = st.nextToken();
        }
        if (actualCommand.equalsIgnoreCase("Chat")) {
            int val = 0;
            try {
                val = Integer.parseInt(par);
            }
            catch (IndexOutOfBoundsException ioobe) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.showMessageWindow(player, val);
        } else if (actualCommand.equalsIgnoreCase("register")) {
            if ((player.getClanPrivileges() & 0x40000) == 262144) {
                if (this.getFort().getSiege().registerAttacker(player, false)) {
                    SystemMessage sm = new SystemMessage(SystemMessageId.REGISTERED_TO_S1_FORTRESS_BATTLE);
                    sm.addString(this.getFort().getName());
                    player.sendPacket(sm);
                    this.showMessageWindow(player, 7);
                }
            } else {
                this.showMessageWindow(player, 10);
            }
        } else if (actualCommand.equalsIgnoreCase("unregister")) {
            if ((player.getClanPrivileges() & 0x40000) == 262144) {
                this.getFort().getSiege().removeSiegeClan(player);
                this.showMessageWindow(player, 8);
            } else {
                this.showMessageWindow(player, 10);
            }
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        this.showMessageWindow(player, 0);
    }

    private void showMessageWindow(L2PcInstance player, int val) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        String filename = val == 0 ? "data/html/fortress/merchant.htm" : "data/html/fortress/merchant-" + val + ".htm";
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(filename);
        html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
        html.replace((CharSequence)"%npcId%", String.valueOf(this.getNpcId()));
        if (this.getFort().getOwnerClan() != null) {
            html.replace((CharSequence)"%clanname%", this.getFort().getOwnerClan().getName());
        } else {
            html.replace((CharSequence)"%clanname%", "NPC");
        }
        player.sendPacket(html);
    }

    @Override
    public boolean hasRandomAnimation() {
        return false;
    }
}

