/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.StringTokenizer;

public final class L2MercManagerInstance
extends L2MerchantInstance {
    private static final int COND_ALL_FALSE = 0;
    private static final int COND_BUSY_BECAUSE_OF_SIEGE = 1;
    private static final int COND_OWNER = 2;

    public L2MercManagerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        int condition = this.validateCondition(player);
        if (condition <= 0) {
            return;
        }
        if (condition == 1) {
            return;
        }
        if (condition == 2) {
            StringTokenizer st = new StringTokenizer(command, " ");
            String actualCommand = st.nextToken();
            String val = "";
            if (st.countTokens() >= 1) {
                val = st.nextToken();
            }
            if (actualCommand.equalsIgnoreCase("hire")) {
                if (val.isEmpty()) {
                    return;
                }
                this.showBuyWindow(player, Integer.parseInt(val));
                return;
            }
        }
        super.onBypassFeedback(player, command);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        String filename = "data/html/mercmanager/mercmanager-no.htm";
        int condition = this.validateCondition(player);
        if (condition == 1) {
            filename = "data/html/mercmanager/mercmanager-busy.htm";
        } else if (condition == 2) {
            filename = "data/html/mercmanager/mercmanager.htm";
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(filename);
        html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
        html.replace((CharSequence)"%npcId%", String.valueOf(this.getNpcId()));
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }

    private int validateCondition(L2PcInstance player) {
        if (this.getCastle() != null && this.getCastle().getCastleId() > 0 && player.getClan() != null) {
            if (this.getCastle().getSiege().getIsInProgress()) {
                return 1;
            }
            if (this.getCastle().getOwnerId() == player.getClanId() && (player.getClanPrivileges() & 0x400000) == 0x400000) {
                return 2;
            }
        }
        return 0;
    }
}

