/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MinionInstance;
import com.l2jserver.gameserver.model.actor.knownlist.MonsterKnownList;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.MinionList;
import com.l2jserver.util.Rnd;
import java.util.List;
import java.util.concurrent.ScheduledFuture;

public class L2MonsterInstance
extends L2Attackable {
    protected final MinionList _minionList = this.getTemplate().getMinionData() != null ? new MinionList(this) : null;
    protected ScheduledFuture<?> _maintenanceTask = null;
    private static final int MONSTER_MAINTENANCE_INTERVAL = 1000;

    public L2MonsterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        if (this.getNpcId() == 29002) {
            this.setIsInvul(true);
        }
    }

    @Override
    public final MonsterKnownList getKnownList() {
        return (MonsterKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new MonsterKnownList(this));
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        if (attacker instanceof L2MonsterInstance) {
            return false;
        }
        return !this.isEventMob;
    }

    @Override
    public boolean isAggressive() {
        return this.getAggroRange() > 0 && !this.isEventMob;
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        if (this._minionList != null) {
            try {
                for (L2MinionInstance minion : this.getSpawnedMinions()) {
                    if (minion == null) continue;
                    this.getSpawnedMinions().remove(minion);
                    minion.deleteMe();
                }
                this._minionList.clearRespawnList();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        this.startMaintenanceTask();
    }

    protected int getMaintenanceInterval() {
        return 1000;
    }

    protected void startMaintenanceTask() {
        if (this._minionList == null) {
            return;
        }
        this._maintenanceTask = ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

            @Override
            public void run() {
                L2MonsterInstance.this._minionList.spawnMinions();
            }
        }, this.getMaintenanceInterval() + Rnd.get(1000));
    }

    public void callMinions() {
        if (this.hasMinions()) {
            for (L2MinionInstance minion : this._minionList.getSpawnedMinions()) {
                if (minion == null || minion.isDead() || minion.isMovementDisabled() || this.isInsideRadius(minion, 200, false, false)) continue;
                int minionX = Rnd.nextInt(340);
                int minionY = Rnd.nextInt(340);
                minionX = minionX < 171 ? this.getX() + minionX + 30 : this.getX() - minionX + 140;
                minionY = minionY < 171 ? this.getY() + minionY + 30 : this.getY() - minionY + 140;
                if (minion.isInCombat() || minion.isDead() || minion.isMovementDisabled()) continue;
                minion.moveToLocation(minionX, minionY, this.getZ(), 0);
            }
        }
    }

    public void callMinionsToAssist(L2Character attacker) {
        if (this.hasMinions()) {
            for (L2MinionInstance minion : this._minionList.getSpawnedMinions()) {
                if (minion == null || minion.isDead()) continue;
                if (this.isRaid() && !this.isRaidMinion()) {
                    minion.addDamage(attacker, 100, null);
                    continue;
                }
                minion.addDamage(attacker, 1, null);
            }
        }
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (this._maintenanceTask != null) {
            this._maintenanceTask.cancel(true);
        }
        if (this.hasMinions() && this.isRaid()) {
            this.deleteSpawnedMinions();
        }
        return true;
    }

    public List<L2MinionInstance> getSpawnedMinions() {
        if (this._minionList == null) {
            return null;
        }
        return this._minionList.getSpawnedMinions();
    }

    public int getTotalSpawnedMinionsInstances() {
        if (this._minionList == null) {
            return 0;
        }
        return this._minionList.countSpawnedMinions();
    }

    public int getTotalSpawnedMinionsGroups() {
        if (this._minionList == null) {
            return 0;
        }
        return this._minionList.lazyCountSpawnedMinionsGroups();
    }

    public void notifyMinionDied(L2MinionInstance minion) {
        this._minionList.moveMinionToRespawnList(minion);
    }

    public void notifyMinionSpawned(L2MinionInstance minion) {
        this._minionList.addSpawnedMinion(minion);
    }

    public boolean hasMinions() {
        if (this._minionList == null) {
            return false;
        }
        return this._minionList.hasMinions();
    }

    @Override
    public void addDamageHate(L2Character attacker, int damage, int aggro) {
        super.addDamageHate(attacker, damage, aggro);
    }

    @Override
    public void deleteMe() {
        if (this.hasMinions()) {
            if (this._maintenanceTask != null) {
                this._maintenanceTask.cancel(true);
            }
            this.deleteSpawnedMinions();
        }
        super.deleteMe();
    }

    public void deleteSpawnedMinions() {
        for (L2MinionInstance minion : this.getSpawnedMinions()) {
            if (minion == null) continue;
            minion.abortAttack();
            minion.abortCast();
            minion.deleteMe();
            this.getSpawnedMinions().remove(minion);
        }
        this._minionList.clearRespawnList();
    }
}

