/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.NpcBufferTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import gnu.trove.TIntIntHashMap;
import java.util.logging.Logger;

public class L2NpcBufferInstance
extends L2Npc {
    static final Logger _log = Logger.getLogger(L2NpcBufferInstance.class.getName());
    private static TIntIntHashMap pageVal = new TIntIntHashMap();

    public L2NpcBufferInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public void showChatWindow(L2PcInstance playerInstance, int val) {
        String htmContent;
        if (playerInstance == null) {
            return;
        }
        String string = htmContent = val > 0 ? HtmCache.getInstance().getHtm("data/html/mods/NpcBuffer-" + val + ".htm") : HtmCache.getInstance().getHtm("data/html/mods/NpcBuffer.htm");
        if (htmContent != null) {
            NpcHtmlMessage npcHtmlMessage = new NpcHtmlMessage(this.getObjectId());
            npcHtmlMessage.setHtml(htmContent);
            npcHtmlMessage.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
            playerInstance.sendPacket(npcHtmlMessage);
        }
        playerInstance.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (player == null || player.getLastFolkNPC() == null || player.getLastFolkNPC().getObjectId() != this.getObjectId()) {
            return;
        }
        int npcId = this.getNpcId();
        if (command.startsWith("Chat")) {
            int val = Integer.parseInt(command.substring(5));
            pageVal.put(player.getObjectId(), val);
            this.showChatWindow(player, val);
        } else if (command.startsWith("Buff")) {
            String[] buffGroupArray;
            for (String buffGroupList : buffGroupArray = command.substring(5).split(" ")) {
                L2Skill skill;
                if (buffGroupList == null) {
                    _log.warning("NPC Buffer Warning: npcId = " + npcId + " has no buffGroup set in the bypass for the buff selected.");
                    return;
                }
                int buffGroup = Integer.parseInt(buffGroupList);
                int[] npcBuffGroupInfo = NpcBufferTable.getInstance().getSkillInfo(npcId, buffGroup);
                if (npcBuffGroupInfo == null) {
                    _log.warning("NPC Buffer Warning: npcId = " + npcId + " Location: " + this.getX() + ", " + this.getY() + ", " + this.getZ() + " Player: " + player.getName() + " has tried to use skill group (" + buffGroup + ") not assigned to the NPC Buffer!");
                    return;
                }
                int skillId = npcBuffGroupInfo[0];
                int skillLevel = npcBuffGroupInfo[1];
                int skillFeeId = npcBuffGroupInfo[2];
                int skillFeeAmount = npcBuffGroupInfo[3];
                if (skillFeeId != 0) {
                    L2ItemInstance itemInstance = player.getInventory().getItemByItemId(skillFeeId);
                    if (itemInstance == null || !itemInstance.isStackable() && player.getInventory().getInventoryItemCount(skillFeeId, -1) < (long)skillFeeAmount) {
                        SystemMessage sm = new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL);
                        player.sendPacket(sm);
                        continue;
                    }
                    if (itemInstance.isStackable()) {
                        if (skillFeeId == 57) {
                            if (!player.reduceAdena("Npc Buffer", skillFeeAmount, player.getTarget(), true)) {
                                continue;
                            }
                        } else if (!player.destroyItemByItemId("Npc Buffer", skillFeeId, skillFeeAmount, player.getTarget(), true)) {
                            SystemMessage sm = new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL);
                            player.sendPacket(sm);
                            continue;
                        }
                    } else {
                        for (int i = 0; i < skillFeeAmount; ++i) {
                            player.destroyItemByItemId("Npc Buffer", skillFeeId, 1L, player.getTarget(), true);
                        }
                    }
                }
                if ((skill = SkillTable.getInstance().getInfo(skillId, skillLevel)) == null) continue;
                L2PcInstance caster = player;
                long castTimeLeft = caster.getCastEndTimeLeftMilli();
                if (castTimeLeft > 0L) {
                    try {
                        Thread.sleep(castTimeLeft);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (skill.getSkillType() == L2SkillType.SUMMON) {
                    caster.doCast(skill);
                    continue;
                }
                this.broadcastPacket(new MagicSkillUse(caster, player, skill.getId(), skill.getLevel(), skill.getHitTime(), 0));
                skill.getEffects(caster, player);
                try {
                    Thread.sleep(100 + skill.getCoolTime() + skill.getHitTime());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.showChatWindow(player, pageVal.get(player.getObjectId()));
        } else if (command.startsWith("Heal")) {
            if (!player.isInCombat() && !AttackStanceTaskManager.getInstance().getAttackStanceTask(player)) {
                String[] healArray;
                for (String healType : healArray = command.substring(5).split(" ")) {
                    if (healType.equalsIgnoreCase("HP")) {
                        player.setCurrentHp(player.getMaxHp());
                        continue;
                    }
                    if (healType.equalsIgnoreCase("MP")) {
                        player.setCurrentMp(player.getMaxMp());
                        continue;
                    }
                    if (!healType.equalsIgnoreCase("CP")) continue;
                    player.setCurrentCp(player.getMaxCp());
                }
            }
            this.showChatWindow(player, 0);
        } else if (command.startsWith("RemoveBuffs")) {
            player.stopAllEffectsExceptThoseThatLastThroughDeath();
            this.showChatWindow(player, 0);
        } else {
            super.onBypassFeedback(player, command);
        }
    }
}

