/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.Arrays;

public class L2WyvernManagerInstance
extends L2Npc {
    private static final int[] STRIDERS = new int[]{12526, 12527, 12528, 16038, 16039, 16040};

    public L2WyvernManagerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("RideWyvern")) {
            if (command.equals("RideWyvern 0")) {
                this.showMessageWindow(player);
                return;
            }
            if (!this.isOwnerClan(player)) {
                return;
            }
            if (!Config.ALLOW_WYVERN_DURING_SIEGE && this.isInSiege()) {
                player.sendMessage("You cannot ride wyvern during siege.");
                return;
            }
            if (SevenSigns.getInstance().getSealOwner(3) == 1 && SevenSigns.getInstance().isSealValidationPeriod()) {
                player.sendMessage("\u6226\u4e71\u306e\u5c01\u5370\u3092\u9ec4\u660f\u306e\u9769\u547d\u8ecd\u304c\u6240\u6709\u3059\u308b\u5834\u5408\u3001\u30ef\u30a4\u30d0\u30fc\u30f3\u306b\u4e57\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                return;
            }
            if (player.isFlying()) {
                return;
            }
            if (Arrays.binarySearch(STRIDERS, player.getMountNpcId()) >= 0) {
                if (player.getInventory().getItemByItemId(1460) != null && player.getInventory().getItemByItemId(1460).getCount() >= 25L) {
                    if (player.getMountLevel() < 55) {
                        player.sendMessage("\u30b9\u30c8\u30e9\u30a4\u30c0\u30fc\u306e\u30ec\u30d9\u30eb\u304c55\u306b\u9054\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
                        return;
                    }
                    player.dismount();
                    if (player.mount(12621, 0, true)) {
                        player.getInventory().destroyItemByItemId("Wyvern", 1460, 25L, player, player.getTarget());
                        player.addSkill(SkillTable.getInstance().getInfo(4289, 1));
                        player.sendMessage("\u30ef\u30a4\u30d0\u30fc\u30f3\u306b\u4e57\u308a\u307e\u3057\u305f\u3002");
                    }
                    return;
                }
                player.sendMessage("25\u500b\u306e\u30af\u30ea\u30b9\u30bf\u30eb:B\u30b0\u30ec\u30fc\u30c9\u304c\u5fc5\u8981\u3067\u3059\u3002");
                return;
            }
            player.sendMessage("\u30b9\u30c8\u30e9\u30a4\u30c0\u30fc\u306b\u642d\u4e57\u3057\u305f\u72b6\u614b\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
            return;
        }
        super.onBypassFeedback(player, command);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        String filename = "data/html/wyvernmanager/wyvernmanager-no.htm";
        if (this.isOwnerClan(player)) {
            filename = "data/html/wyvernmanager/wyvernmanager.htm";
        }
        NpcHtmlMessage html = new NpcHtmlMessage(1);
        html.setFile(filename);
        html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }

    private void showMessageWindow(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        String filename = "data/html/wyvernmanager/wyvernmanager-no.htm";
        if (this.isOwnerClan(player)) {
            filename = "data/html/wyvernmanager/wyvernmanager.htm";
        }
        NpcHtmlMessage html = new NpcHtmlMessage(1);
        html.setFile(filename);
        html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }

    protected boolean isOwnerClan(L2PcInstance player) {
        return true;
    }

    protected boolean isInSiege() {
        return false;
    }
}

