/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.PlayableKnownList;
import com.l2jserver.gameserver.network.serverpackets.DeleteObject;
import com.l2jserver.gameserver.network.serverpackets.SpawnItem;

public class PcKnownList
extends PlayableKnownList {
    public PcKnownList(L2PcInstance activeChar) {
        super(activeChar);
    }

    @Override
    public boolean addKnownObject(L2Object object) {
        if (!super.addKnownObject(object)) {
            return false;
        }
        if (object.getPoly().isMorphed() && object.getPoly().getPolyType().equals("item")) {
            this.getActiveChar().sendPacket(new SpawnItem(object));
        } else {
            L2Character obj;
            object.sendInfo(this.getActiveChar());
            if (object instanceof L2Character && (obj = (L2Character)object).getAI() != null) {
                obj.getAI().describeStateToPlayer(this.getActiveChar());
            }
        }
        return true;
    }

    @Override
    public boolean removeKnownObject(L2Object object) {
        if (!super.removeKnownObject(object)) {
            return false;
        }
        this.getActiveChar().sendPacket(new DeleteObject(object));
        if (Config.CHECK_KNOWN && object instanceof L2Npc) {
            this.getActiveChar().sendMessage("Removed NPC: " + ((L2Npc)object).getName());
        }
        return true;
    }

    @Override
    public final L2PcInstance getActiveChar() {
        return (L2PcInstance)super.getActiveChar();
    }

    @Override
    public int getDistanceToForgetObject(L2Object object) {
        int knownlistSize = this.getKnownObjects().size();
        if (knownlistSize <= 25) {
            return 4000;
        }
        if (knownlistSize <= 35) {
            return 3500;
        }
        if (knownlistSize <= 70) {
            return 2910;
        }
        return 2310;
    }

    @Override
    public int getDistanceToWatchObject(L2Object object) {
        int knownlistSize = this.getKnownObjects().size();
        if (knownlistSize <= 25) {
            return 3400;
        }
        if (knownlistSize <= 35) {
            return 2900;
        }
        if (knownlistSize <= 70) {
            return 2300;
        }
        return 1700;
    }
}

