/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.stat;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.stat.CharStat;
import com.l2jserver.gameserver.skills.Stats;

public class NpcStat
extends CharStat {
    public NpcStat(L2Npc activeChar) {
        super(activeChar);
    }

    @Override
    public byte getLevel() {
        return this.getActiveChar().getTemplate().level;
    }

    @Override
    public L2Npc getActiveChar() {
        return (L2Npc)super.getActiveChar();
    }

    @Override
    public final int getMaxHp() {
        return (int)this.calcStat(Stats.MAX_HP, this.getActiveChar().getTemplate().baseHpMax, null, null);
    }

    @Override
    public int getWalkSpeed() {
        return (int)this.calcStat(Stats.WALK_SPEED, this.getActiveChar().getTemplate().baseWalkSpd, null, null);
    }

    @Override
    public float getMovementSpeedMultiplier() {
        if (this.getActiveChar() == null) {
            return 1.0f;
        }
        L2Npc ac = this.getActiveChar();
        if (ac.isRunning()) {
            int baseRunSpd = ac.getTemplate().baseRunSpd;
            if (baseRunSpd == 0) {
                return 1.0f;
            }
            return (float)this.getRunSpeed() / (float)baseRunSpd;
        }
        int baseWalkSpd = ac.getTemplate().baseWalkSpd;
        if (baseWalkSpd == 0) {
            return 1.0f;
        }
        return (float)this.getWalkSpeed() / (float)baseWalkSpd;
    }
}

