/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2DecoyInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;
import com.l2jserver.util.Rnd;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javolution.util.FastList;

public class BossEntity {
    public static Logger _log = Logger.getLogger(BossEntity.class.getName());
    private L2BossZone _zone;
    @Deprecated
    static final boolean DEBUG = false;

    public void registerZone(L2BossZone zone) {
        this._zone = zone;
        this._zone.registerEntity(this);
    }

    public L2BossZone registerZone(int x, int y, int z) {
        this._zone = GrandBossManager.getInstance().getZone(x, y, z);
        this._zone.registerEntity(this);
        return this._zone;
    }

    public L2BossZone getZone() {
        return this._zone;
    }

    public void onEnter(L2PcInstance player) {
    }

    public void checkAnnihilated() {
    }

    public boolean checkIfInZone(L2Character cha) {
        if (this._zone != null) {
            return this._zone.isInsideZone(cha);
        }
        _log.warning(this.getClassName() + " has no zone defined");
        return false;
    }

    public List<L2PcInstance> getPlayersInside() {
        FastList lst = new FastList();
        for (L2Character cha : this.getZone().getCharactersInside().values()) {
            if (!(cha instanceof L2PcInstance)) continue;
            lst.add((L2PcInstance)cha);
        }
        return lst;
    }

    public L2PcInstance getRandomPlayer() {
        Collection lst = this.getZone().getCharactersInside().values();
        L2PcInstance[] array = new L2PcInstance[lst.size()];
        int count = 0;
        for (L2Character cha : lst) {
            if (cha.isDead() || !(cha instanceof L2PcInstance)) continue;
            array[count++] = (L2PcInstance)cha;
        }
        return count > 0 ? array[Rnd.get(count)] : null;
    }

    public L2Character getRandomTarget() {
        Collection lst = this.getZone().getCharactersInside().values();
        L2Character[] array = new L2Character[lst.size()];
        int count = 0;
        for (L2Character cha : lst) {
            if (cha.isDead() || !(cha instanceof L2PcInstance) && !(cha instanceof L2DecoyInstance)) continue;
            array[count++] = (L2PcInstance)cha;
        }
        return count > 0 ? array[Rnd.get(count)] : null;
    }

    public void banishForeigners() {
        this.getZone().oustAllPlayers();
    }

    public String getClassName() {
        return this.getClass().getSimpleName();
    }

    @Deprecated
    public void TRACE(String msg) {
    }

    @Deprecated
    public void TRACE(String title, String msg) {
    }
}

