/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.cache.CrestCache;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RequestExSetPledgeCrestLarge
extends L2GameClientPacket {
    private static final String _C__D0_11_REQUESTEXSETPLEDGECRESTLARGE = "[C] D0:11 RequestExSetPledgeCrestLarge";
    static Logger _log = Logger.getLogger(RequestExSetPledgeCrestLarge.class.getName());
    private int _size;
    private byte[] _data;

    @Override
    protected void readImpl() {
        this._size = this.readD();
        if (this._size > 2176) {
            return;
        }
        if (this._size > 0) {
            this._data = new byte[this._size];
            this.readB(this._data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2Clan clan = activeChar.getClan();
        if (clan == null) {
            return;
        }
        if (this._data == null) {
            CrestCache.getInstance().removePledgeCrestLarge(clan.getCrestId());
            clan.setHasCrestLarge(false);
            activeChar.sendMessage("The insignia has been removed.");
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                member.broadcastUserInfo();
            }
            return;
        }
        if (this._size > 2176) {
            activeChar.sendMessage("The insignia file size is greater than 2176 bytes.");
            return;
        }
        if ((activeChar.getClanPrivileges() & 0x80) == 128) {
            int newId;
            if (clan.getHasCastle() == 0 && clan.getHasHideout() == 0) {
                activeChar.sendMessage("Only a clan that owns a clan hall or a castle can get their emblem displayed on clan related items");
                return;
            }
            CrestCache crestCache = CrestCache.getInstance();
            if (!crestCache.savePledgeCrestLarge(newId = IdFactory.getInstance().getNextId(), this._data)) {
                _log.log(Level.INFO, "Error loading large crest of clan:" + clan.getName());
                return;
            }
            if (clan.hasCrestLarge()) {
                crestCache.removePledgeCrestLarge(clan.getCrestLargeId());
            }
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("UPDATE clan_data SET crest_large_id = ? WHERE clan_id = ?");
                statement.setInt(1, newId);
                statement.setInt(2, clan.getClanId());
                statement.executeUpdate();
                statement.close();
            }
            catch (SQLException e) {
                _log.warning("could not update the large crest id:" + e.getMessage());
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
            clan.setCrestLargeId(newId);
            clan.setHasCrestLarge(true);
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CLAN_EMBLEM_WAS_SUCCESSFULLY_REGISTERED));
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                member.broadcastUserInfo();
            }
        }
    }

    @Override
    public String getType() {
        return _C__D0_11_REQUESTEXSETPLEDGECRESTLARGE;
    }
}

