/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.script.faenor;

import com.l2jserver.Config;
import com.l2jserver.gameserver.script.Parser;
import com.l2jserver.gameserver.script.ParserNotCreatedException;
import com.l2jserver.gameserver.script.ScriptDocument;
import com.l2jserver.gameserver.script.ScriptEngine;
import com.l2jserver.gameserver.script.ScriptPackage;
import com.l2jserver.gameserver.scripting.L2ScriptEngineManager;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.script.ScriptContext;
import org.w3c.dom.Node;

public class FaenorScriptEngine
extends ScriptEngine {
    static Logger _log = Logger.getLogger(FaenorScriptEngine.class.getName());
    public static final String PACKAGE_DIRECTORY = "data/faenor/";
    public static final boolean DEBUG = true;
    private LinkedList<ScriptDocument> _scripts = new LinkedList();

    public static FaenorScriptEngine getInstance() {
        return SingletonHolder._instance;
    }

    private FaenorScriptEngine() {
        this.loadPackages();
        this.parsePackages();
    }

    public void reloadPackages() {
        this._scripts = new LinkedList();
        this.parsePackages();
    }

    private void loadPackages() {
        File packDirectory = new File(Config.DATAPACK_ROOT, PACKAGE_DIRECTORY);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".zip");
            }
        };
        File[] files = packDirectory.listFiles(fileFilter);
        if (files == null) {
            return;
        }
        for (File file : files) {
            ZipFile zipPack;
            try {
                zipPack = new ZipFile(file);
            }
            catch (ZipException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            ScriptPackage module = new ScriptPackage(zipPack);
            List<ScriptDocument> scrpts = module.getScriptFiles();
            for (ScriptDocument script : scrpts) {
                this._scripts.add(script);
            }
            try {
                zipPack.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void orderScripts() {
        if (this._scripts.size() > 1) {
            int i = 0;
            while (i < this._scripts.size()) {
                if (this._scripts.get(i).getName().contains("NpcStatData")) {
                    this._scripts.addFirst(this._scripts.remove(i));
                    continue;
                }
                ++i;
            }
        }
    }

    public void parsePackages() {
        L2ScriptEngineManager sem = L2ScriptEngineManager.getInstance();
        ScriptContext context = sem.getScriptContext("beanshell");
        try {
            sem.eval("beanshell", "double log1p(double d) { return Math.log1p(d); }");
            sem.eval("beanshell", "double pow(double d, double p) { return Math.pow(d,p); }");
            for (ScriptDocument script : this._scripts) {
                this.parseScript(script, context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parseScript(ScriptDocument script, ScriptContext context) {
        _log.fine("Parsing Script: " + script.getName());
        Node node = script.getDocument().getFirstChild();
        String parserClass = "faenor.Faenor" + node.getNodeName() + "Parser";
        Parser parser = null;
        try {
            parser = FaenorScriptEngine.createParser(parserClass);
        }
        catch (ParserNotCreatedException e) {
            _log.warning("ERROR: No parser registered for Script: " + parserClass);
            e.printStackTrace();
        }
        if (parser == null) {
            _log.warning("Unknown Script Type: " + script.getName());
            return;
        }
        try {
            parser.parseScript(node, context);
            _log.fine(script.getName() + "Script Sucessfullty Parsed.");
        }
        catch (Exception e) {
            e.printStackTrace();
            _log.warning("Script Parsing Failed.");
        }
    }

    public String toString() {
        if (this._scripts.isEmpty()) {
            return "No Packages Loaded.";
        }
        String out = "Script Packages currently loaded:\n";
        for (ScriptDocument script : this._scripts) {
            out = out + script;
        }
        return out;
    }

    private static class SingletonHolder {
        protected static final FaenorScriptEngine _instance = new FaenorScriptEngine();

        private SingletonHolder() {
        }
    }
}

