/*
 * Decompiled with CFR 0.152.
 */
package org.mmocore.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import org.mmocore.network.MMOClient;
import org.mmocore.network.NioNetStackList;
import org.mmocore.network.SelectorThread;
import org.mmocore.network.SendablePacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MMOConnection<T extends MMOClient<?>> {
    private final SelectorThread<T> _selectorThread;
    private final Socket _socket;
    private final InetAddress _address;
    private final ReadableByteChannel _readableByteChannel;
    private final WritableByteChannel _writableByteChannel;
    private final int _port;
    private final NioNetStackList<SendablePacket<T>> _sendQueue;
    private final SelectionKey _selectionKey;
    private SendablePacket<T> _closePacket;
    private ByteBuffer _readBuffer;
    private ByteBuffer _primaryWriteBuffer;
    private ByteBuffer _secondaryWriteBuffer;
    private boolean _pendingClose;
    private T _client;

    public MMOConnection(SelectorThread<T> selectorThread, Socket socket, SelectionKey key) {
        this._selectorThread = selectorThread;
        this._socket = socket;
        this._address = socket.getInetAddress();
        this._readableByteChannel = socket.getChannel();
        this._writableByteChannel = socket.getChannel();
        this._port = socket.getPort();
        this._selectionKey = key;
        this._sendQueue = new NioNetStackList();
    }

    final void setClient(T client) {
        this._client = client;
    }

    public final T getClient() {
        return this._client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendPacket(SendablePacket<T> sp) {
        sp._client = this._client;
        NioNetStackList<SendablePacket<T>> nioNetStackList = this.getSendQueue();
        synchronized (nioNetStackList) {
            if (!this._pendingClose) {
                this._sendQueue.addLast(sp);
            }
        }
        if (!this._sendQueue.isEmpty()) {
            try {
                this._selectionKey.interestOps(this._selectionKey.interestOps() | 4);
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
    }

    final SelectionKey getSelectionKey() {
        return this._selectionKey;
    }

    public final InetAddress getInetAddress() {
        return this._address;
    }

    public final int getPort() {
        return this._port;
    }

    final void close() throws IOException {
        this._socket.close();
    }

    final int read(ByteBuffer buf) throws IOException {
        return this._readableByteChannel.read(buf);
    }

    final int write(ByteBuffer buf) throws IOException {
        return this._writableByteChannel.write(buf);
    }

    final void createWriteBuffer(ByteBuffer buf) {
        if (this._primaryWriteBuffer == null) {
            this._primaryWriteBuffer = this._selectorThread.getPooledBuffer();
            this._primaryWriteBuffer.put(buf);
        } else {
            ByteBuffer temp = this._selectorThread.getPooledBuffer();
            temp.put(buf);
            int remaining = temp.remaining();
            this._primaryWriteBuffer.flip();
            int limit = this._primaryWriteBuffer.limit();
            if (remaining >= this._primaryWriteBuffer.remaining()) {
                temp.put(this._primaryWriteBuffer);
                this._selectorThread.recycleBuffer(this._primaryWriteBuffer);
                this._primaryWriteBuffer = temp;
            } else {
                this._primaryWriteBuffer.limit(remaining);
                temp.put(this._primaryWriteBuffer);
                this._primaryWriteBuffer.limit(limit);
                this._primaryWriteBuffer.compact();
                this._secondaryWriteBuffer = this._primaryWriteBuffer;
                this._primaryWriteBuffer = temp;
            }
        }
    }

    final boolean hasPendingWriteBuffer() {
        return this._primaryWriteBuffer != null;
    }

    final void movePendingWriteBufferTo(ByteBuffer dest) {
        this._primaryWriteBuffer.flip();
        dest.put(this._primaryWriteBuffer);
        this._selectorThread.recycleBuffer(this._primaryWriteBuffer);
        this._primaryWriteBuffer = this._secondaryWriteBuffer;
        this._secondaryWriteBuffer = null;
    }

    final void setReadBuffer(ByteBuffer buf) {
        this._readBuffer = buf;
    }

    final ByteBuffer getReadBuffer() {
        return this._readBuffer;
    }

    public final boolean isClosed() {
        return this._pendingClose;
    }

    final NioNetStackList<SendablePacket<T>> getSendQueue() {
        return this._sendQueue;
    }

    final SendablePacket<T> getClosePacket() {
        return this._closePacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(SendablePacket<T> sp) {
        NioNetStackList<SendablePacket<T>> nioNetStackList = this.getSendQueue();
        synchronized (nioNetStackList) {
            if (!this._pendingClose) {
                this._pendingClose = true;
            }
            this._sendQueue.clear();
        }
        try {
            this._selectionKey.interestOps(this._selectionKey.interestOps() & 0xFFFFFFFB);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
        this._closePacket = sp;
        this._selectorThread.closeConnection(this);
    }

    final void releaseBuffers() {
        if (this._primaryWriteBuffer != null) {
            this._selectorThread.recycleBuffer(this._primaryWriteBuffer);
            this._primaryWriteBuffer = null;
            if (this._secondaryWriteBuffer != null) {
                this._selectorThread.recycleBuffer(this._secondaryWriteBuffer);
                this._secondaryWriteBuffer = null;
            }
        }
        if (this._readBuffer != null) {
            this._selectorThread.recycleBuffer(this._readBuffer);
            this._readBuffer = null;
        }
    }
}

