/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javolution.Javolution;
import javolution.JavolutionError;
import javolution.context.PersistentContext;
import javolution.lang.ClassInitializer;
import javolution.lang.Reflection;
import javolution.lang.Reusable;
import javolution.text.CharArray;
import javolution.text.Text;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.util.FastMap;
import javolution.util.Index;
import javolution.xml.QName;
import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamReader;
import javolution.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLBinding
implements Reusable,
XMLSerializable {
    static final XMLFormat XML = new XMLFormat(XMLBinding.class){

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
            XMLBinding binding = (XMLBinding)obj;
            binding._classAttribute = xml.get("classAttribute", QName.class);
            binding._classToAlias.putAll(xml.get("aliases", FastMap.class));
            binding._aliasToClass.putAll(binding._classToAlias.reverse());
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            XMLBinding binding = (XMLBinding)obj;
            xml.add(binding._classAttribute, "classAttribute", QName.class);
            xml.add(binding._classToAlias, "aliases", FastMap.class);
        }
    };
    private static FastMap STATIC_MAPPING = new FastMap().setShared(true);
    static final XMLBinding DEFAULT = new XMLBinding();
    private QName _classAttribute = QName.valueOf("class");
    private final FastMap _classToAlias = new FastMap();
    private final FastMap _aliasToClass = new FastMap();
    static final XMLFormat<Object> OBJECT_XML = new XMLFormat(Object.class){

        public void read(XMLFormat.InputElement xml, Object obj) {
        }

        public void write(Object obj, XMLFormat.OutputElement xml) {
        }
    };
    static final XMLFormat<Class> CLASS_XML = new XMLFormat(Class.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, XMLFormat.InputElement xml) throws XMLStreamException {
            Class clazz;
            CharArray name = xml.getAttribute("name");
            if (name == null) {
                throw new XMLStreamException("Attribute 'name' missing");
            }
            try {
                clazz = Reflection.getClass(name);
            }
            catch (ClassNotFoundException e) {
                throw new XMLStreamException(e);
            }
            return clazz;
        }

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("name", ((Class)obj).getName());
        }
    };
    static final XMLFormat<String> STRING_XML = new XMLFormat(String.class){

        public Object newInstance(Class cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return xml.getAttribute("value", "");
        }

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (String)obj);
        }
    };
    static final XMLFormat<Appendable> APPENDABLE_XML = new XMLFormat(Appendable.class){

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
            CharArray csq = xml.getAttribute("value");
            if (csq != null) {
                try {
                    ((Appendable)obj).append(csq);
                }
                catch (IOException e) {
                    throw new XMLStreamException(e);
                }
            }
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (obj instanceof CharSequence) {
                xml.setAttribute("value", (CharSequence)obj);
            } else {
                xml.setAttribute("value", obj.toString());
            }
        }
    };
    static final XMLFormat<Collection> COLLECTION_XML = new XMLFormat(Collection.class){

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
            Collection collection = (Collection)obj;
            while (xml.hasNext()) {
                collection.add(xml.getNext());
            }
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            Collection collection = (Collection)obj;
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                xml.add(i.next());
            }
        }
    };
    static final XMLFormat<Map> MAP_XML = new XMLFormat(Map.class){

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
            Map map = (Map)obj;
            while (xml.hasNext()) {
                Object key = xml.get("Key");
                Object value = xml.get("Value");
                map.put(key, value);
            }
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                xml.add(entry.getKey(), "Key");
                xml.add(entry.getValue(), "Value");
            }
        }
    };
    static final XMLFormat<Object[]> OBJECT_ARRAY_XML = new XMLFormat((Class)new Object[0].getClass()){

        public Object newInstance(Class cls, XMLFormat.InputElement xml) throws XMLStreamException {
            Class<?> componentType = cls.getComponentType();
            int length = xml.getAttribute("length", 0);
            return Array.newInstance(componentType, length);
        }

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
            Object[] array = (Object[])obj;
            for (int i = 0; i < array.length; ++i) {
                array[i] = xml.getNext();
            }
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            Object[] array = (Object[])obj;
            xml.setAttribute("length", array.length);
            for (int i = 0; i < array.length; ++i) {
                xml.add(array[i]);
            }
        }
    };
    static final XMLFormat<Boolean> BOOLEAN_XML = new XMLFormat(Boolean.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return xml.getAttribute("value", false) ? Boolean.TRUE : Boolean.FALSE;
        }

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (Boolean)obj);
        }
    };
    static final XMLFormat<Byte> BYTE_XML = new XMLFormat(Byte.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return new Byte((byte)xml.getAttribute("value", 0));
        }

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (Byte)obj);
        }
    };
    static final XMLFormat<Character> CHARACTER_XML = new XMLFormat(Character.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, XMLFormat.InputElement xml) throws XMLStreamException {
            CharArray csq = xml.getAttribute("value");
            if (csq == null || csq.length() != 1) {
                throw new XMLStreamException("Missing or invalid value attribute");
            }
            return new Character(csq.charAt(0));
        }

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", Text.valueOf(((Character)obj).charValue()));
        }
    };
    static final XMLFormat<Short> SHORT_XML = new XMLFormat(Short.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return new Short((short)xml.getAttribute("value", 0));
        }

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (Short)obj);
        }
    };
    static final XMLFormat<Integer> INTEGER_XML = new XMLFormat(Integer.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return new Integer(xml.getAttribute("value", 0));
        }

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (Integer)obj);
        }
    };
    static final XMLFormat<Long> LONG_XML = new XMLFormat(Long.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return new Long(xml.getAttribute("value", 0L));
        }

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (Long)obj);
        }
    };
    static final XMLFormat<Float> FLOAT_XML = new XMLFormat(Float.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return new Float(xml.getAttribute("value", 0.0f));
        }

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", ((Float)obj).floatValue());
        }
    };
    static final XMLFormat<Double> DOUBLE_XML = new XMLFormat(Double.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return new Double(xml.getAttribute("value", 0.0));
        }

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (Double)obj);
        }
    };
    static final XMLFormat<Text> TEXT_XML = new XMLFormat(Text.class){

        public Object newInstance(Class cls, XMLFormat.InputElement xml) throws XMLStreamException {
            CharArray csq = xml.getAttribute("value");
            return csq != null ? Text.valueOf(csq) : Text.EMPTY;
        }

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (Text)obj);
        }
    };
    static final XMLFormat<FastMap> FASTMAP_XML = new XMLFormat(FastMap.class){

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
            FastComparator valueComparator;
            FastMap fm = (FastMap)obj;
            fm.setShared(xml.getAttribute("shared", false));
            FastComparator keyComparator = (FastComparator)xml.get("KeyComparator");
            if (keyComparator != null) {
                fm.setKeyComparator(keyComparator);
            }
            if ((valueComparator = (FastComparator)xml.get("ValueComparator")) != null) {
                fm.setValueComparator(valueComparator);
            }
            while (xml.hasNext()) {
                Object key = xml.get("Key");
                Object value = xml.get("Value");
                fm.put(key, value);
            }
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            FastMap fm = (FastMap)obj;
            if (fm.isShared()) {
                xml.setAttribute("shared", true);
            }
            if (fm.getKeyComparator() != FastComparator.DEFAULT) {
                xml.add(fm.getKeyComparator(), "KeyComparator");
            }
            if (fm.getValueComparator() != FastComparator.DEFAULT) {
                xml.add(fm.getValueComparator(), "ValueComparator");
            }
            FastCollection.Record e = fm.head();
            FastMap.Entry end = fm.tail();
            while ((e = ((FastMap.Entry)e).getNext()) != end) {
                xml.add(((FastMap.Entry)e).getKey(), "Key");
                xml.add(((FastMap.Entry)e).getValue(), "Value");
            }
        }
    };
    static final XMLFormat<FastCollection> FASTCOLLECTION_XML = new XMLFormat(FastCollection.class){

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
            FastCollection fc = (FastCollection)obj;
            while (xml.hasNext()) {
                fc.add(xml.getNext());
            }
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            FastCollection fc = (FastCollection)obj;
            FastCollection.Record r = fc.head();
            FastCollection.Record end = fc.tail();
            while ((r = r.getNext()) != end) {
                xml.add(fc.valueOf(r));
            }
        }
    };
    static final XMLFormat<FastComparator> FASTCOMPARATOR_XML = new XMLFormat(FastComparator.class){

        public Object newInstance(Class cls, XMLFormat.InputElement xml) throws XMLStreamException {
            if (cls == FastComparator.DEFAULT.getClass()) {
                return FastComparator.DEFAULT;
            }
            if (cls == FastComparator.DIRECT.getClass()) {
                return FastComparator.DIRECT;
            }
            if (cls == FastComparator.IDENTITY.getClass()) {
                return FastComparator.IDENTITY;
            }
            if (cls == FastComparator.LEXICAL.getClass()) {
                return FastComparator.LEXICAL;
            }
            if (cls == FastComparator.REHASH.getClass()) {
                return FastComparator.REHASH;
            }
            if (cls == FastComparator.STRING.getClass()) {
                return FastComparator.STRING;
            }
            return super.newInstance(cls, xml);
        }

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
        }
    };
    static final XMLFormat<Index> INDEX_XML = new XMLFormat(Index.class){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return Index.valueOf(xml.getAttribute("value", 0));
        }

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", ((Index)obj).intValue());
        }
    };
    static final XMLFormat<PersistentContext> PERSISTENT_CONTEXT_XML = new XMLFormat(PersistentContext.class){

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
            PersistentContext ctx = (PersistentContext)obj;
            ctx.getIdToValue().putAll((FastMap)xml.get("References"));
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            PersistentContext ctx = (PersistentContext)obj;
            xml.add(ctx.getIdToValue(), "References");
        }
    };

    public void setAlias(Class cls, QName qName) {
        this._classToAlias.put(cls, qName);
        this._aliasToClass.put(qName, cls);
    }

    public final void setAlias(Class cls, String alias) {
        this.setAlias(cls, QName.valueOf(alias));
    }

    public void setClassAttribute(QName classAttribute) {
        this._classAttribute = classAttribute;
    }

    public final void setClassAttribute(String name) {
        this.setClassAttribute(name == null ? null : QName.valueOf(name));
    }

    protected <T> XMLFormat<T> getFormat(Class<T> cls) {
        Object xmlFormat = STATIC_MAPPING.get(cls);
        return xmlFormat != null ? (XMLFormat)xmlFormat : this.searchFormat(cls);
    }

    private XMLFormat searchFormat(Class cls) {
        ClassInitializer.initialize(cls);
        XMLFormat bestMatchFormat = null;
        int j = XMLFormat._ClassInstancesLength;
        for (int i = 0; i < j; ++i) {
            XMLFormat xmlFormat = XMLFormat._ClassInstances[i];
            if (!xmlFormat._class.isAssignableFrom(cls) || bestMatchFormat != null && !bestMatchFormat._class.isAssignableFrom(xmlFormat._class)) continue;
            bestMatchFormat = xmlFormat;
        }
        if (bestMatchFormat == null) {
            throw new JavolutionError("Cannot find format for " + cls);
        }
        STATIC_MAPPING.put(cls, bestMatchFormat);
        return bestMatchFormat;
    }

    protected Class readClass(XMLStreamReader reader, boolean useAttributes) throws XMLStreamException {
        QName className;
        if (useAttributes) {
            if (this._classAttribute == null) {
                throw new XMLStreamException("Binding has no class attribute defined, cannot retrieve class");
            }
            className = QName.valueOf(reader.getAttributeValue(this._classAttribute.getNamespaceURI(), this._classAttribute.getLocalName()));
            if (className == null) {
                throw new XMLStreamException("Cannot retrieve class (class attribute not found)");
            }
        } else {
            className = QName.valueOf(reader.getNamespaceURI(), reader.getLocalName());
        }
        try {
            Class cls = (Class)this._aliasToClass.get(className);
            if (cls != null) {
                return cls;
            }
            cls = Reflection.getClass(className.getLocalName());
            this._aliasToClass.put(className, cls);
            return cls;
        }
        catch (ClassNotFoundException e) {
            throw new XMLStreamException("Class: " + className + " not found");
        }
    }

    protected void writeClass(Class cls, XMLStreamWriter writer, boolean useAttributes) throws XMLStreamException {
        String name;
        QName qName = (QName)this._classToAlias.get(cls);
        String string = name = qName != null ? qName.toString() : cls.getName();
        if (useAttributes) {
            if (this._classAttribute == null) {
                return;
            }
            if (this._classAttribute.getNamespaceURI() == null) {
                writer.writeAttribute(this._classAttribute.getLocalName(), Javolution.j2meToCharSeq(name));
            } else {
                writer.writeAttribute(this._classAttribute.getNamespaceURI(), this._classAttribute.getLocalName(), Javolution.j2meToCharSeq(name));
            }
        } else if (qName != null) {
            writer.writeStartElement(qName.getNamespaceURI(), qName.getLocalName());
        } else {
            writer.writeStartElement(Javolution.j2meToCharSeq(name));
        }
    }

    @Override
    public void reset() {
        this._classAttribute = QName.valueOf("class");
        this._aliasToClass.reset();
        this._classToAlias.reset();
    }
}

