/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.script.java;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

public final class MemoryClassLoader
extends URLClassLoader {
    private Map<String, byte[]> classBytes;

    public MemoryClassLoader(Map<String, byte[]> classBytes, String classPath, ClassLoader parent) {
        super(MemoryClassLoader.toURLs(classPath), parent);
        this.classBytes = classBytes;
    }

    public MemoryClassLoader(Map<String, byte[]> classBytes, String classPath) {
        this(classBytes, classPath, null);
    }

    public Class load(String className) throws ClassNotFoundException {
        return this.loadClass(className);
    }

    public Iterable<Class> loadAll() throws ClassNotFoundException {
        ArrayList<Class> classes = new ArrayList<Class>(this.classBytes.size());
        for (String name : this.classBytes.keySet()) {
            classes.add(this.loadClass(name));
        }
        return classes;
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        byte[] buf = this.classBytes.get(className);
        if (buf != null) {
            this.classBytes.put(className, null);
            return this.defineClass(className, buf, 0, buf.length);
        }
        return super.findClass(className);
    }

    private static URL[] toURLs(String classPath) {
        if (classPath == null) {
            return new URL[0];
        }
        ArrayList<URL> list = new ArrayList<URL>();
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            File file = new File(token);
            if (file.exists()) {
                try {
                    list.add(file.toURI().toURL());
                }
                catch (MalformedURLException mue) {}
                continue;
            }
            try {
                list.add(new URL(token));
            }
            catch (MalformedURLException mue) {}
        }
        URL[] res = new URL[list.size()];
        list.toArray(res);
        return res;
    }
}

