# L2J_JP CREATE SANDMAN
# JOJO Sync: l2jfree-datapack rev4963, timestamp 2008/12/30 19:43
# JOJO Implements Soul Breaking Arrow and Dewdrop of Destruction.
import sys
#from com.l2jserver import Config
from com.l2jserver.gameserver.model.quest import State
from com.l2jserver.gameserver.model.quest import QuestState
from com.l2jserver.gameserver.model.quest.jython import QuestJython as JQuest
from com.l2jserver.gameserver.instancemanager.lastimperialtomb import LastImperialTombManager
from com.l2jserver.gameserver.instancemanager.grandbosses import FrintezzaManager
from com.l2jserver.util import Rnd

qn = "lastimperialtomb"

#NPC
GUIDE         = 32011
ALARM_DEVICE  = 18328
CHOIR_PRAYER  = 18339
CHOIR_CAPTAIN = 18334
FRINTEZZA     = 29045
SCARLET_VAN_HALISHA_WEAK   = 29046
SCARLET_VAN_HALISHA_STRONG = 29047
TELEPORTATION_CUBIC = 29061


class lastimperialtomb (JQuest):
  def __init__(self,id,name,descr) :
    JQuest.__init__(self,id,name,descr)

  def onTalk (self,npc,player) :
    st = player.getQuestState(qn)
    if not st : return "<html><head><body>I have no tasks for you</body></html>"
    npcId = npc.getNpcId()
    if npcId == GUIDE : # Frintezza Teleporter
      if player.isFlying() :
        return "<html><body>tebT e|[^[:<br>Co[撆͒ɓ邱Ƃ͂ł܂B</body></html>"
       #return "<html><body>Imperial Tomb Guide:<br>To enter, get off the wyvern.</body></html>"
      return LastImperialTombManager.getInstance().registration(-1,npc,player)
    elif npcId == TELEPORTATION_CUBIC :
      LastImperialTombManager.getInstance().escapeForeigner(player)
    return

  def onAdvEvent (self,event,npc,player) :
    htmltext=event
    if event == "0" or event == "1" or event == "2" :
      return LastImperialTombManager.getInstance().registration(int(event),npc,player)
    return htmltext

  def onKill (self,npc,player,isPet):
    st = player.getQuestState(qn)
    npcId = npc.getNpcId()
    if npcId == ALARM_DEVICE :
      if st.getRandom(100) < 33 :
          st.giveItems(8556, 1) # Dewdrop of Destruction
#         st.dropItem(npc,player,8556,1) # Dewdrop of Destruction
      LastImperialTombManager.getInstance().onKillHallAlarmDevice()
    elif npcId == CHOIR_PRAYER :
      LastImperialTombManager.getInstance().onKillDarkChoirPlayer()
    elif npcId == CHOIR_CAPTAIN :
      if st.getRandom(100) < 33 :
          st.giveItems(8192, 1) # Soul Breaking Arrow
#         st.dropItem(npc,player,8192,1) # Soul Breaking Arrow
      LastImperialTombManager.getInstance().onKillDarkChoirCaptain()
    elif npcId == SCARLET_VAN_HALISHA_STRONG or npcId == SCARLET_VAN_HALISHA_WEAK :
      FrintezzaManager.getInstance().onKillScarlet(player)
    elif npcId == FRINTEZZA :
      FrintezzaManager.getInstance().onKillFrintezza(player)
    elif npcId >= 18329 and npcId <= 18333 :
      if st.getRandom(100) < 20 :
          st.giveItems(8556, 1) # Dewdrop of Destruction
#         st.dropItem(npc,player,8556,1) # Dewdrop of Destruction
    return

  def onSkillSee (self,npc,player,skill,targets,isPet):
    st = player.getQuestState(qn)
    if not st : return
    if targets[0] == npc:
      # skills/2200-2299.xml
      #  <skill id="2234" name="Soul Breaking Arrow">
      #  <target npcId="29045"/> <!-- Frintezza -->
      if skill.getId() == 2234:
        FrintezzaManager.getInstance().onSoulBreakingArrow(npc,player)
      # skills/2200-2299.xml
      #  <skill id="2276" name="Dewdrop of Destruction">
      #  <target npcId="29048 29049"/> <!-- Evil Spirit -->
      if skill.getId() == 2276:
        npc.doDie(player)

# Quest class and state definition
QUEST = lastimperialtomb(-1, qn, "ai")
# Quest NPC starter initialization
QUEST.addStartNpc(GUIDE)

QUEST.addTalkId(GUIDE)
QUEST.addTalkId(TELEPORTATION_CUBIC)

QUEST.addKillId(ALARM_DEVICE)
QUEST.addKillId(18329) # Hall Keeper Captain
QUEST.addKillId(18330) # Hall Keeper Wizard
QUEST.addKillId(18331) # Hall Keeper Guard
QUEST.addKillId(18332) # Hall Keeper Patrol
QUEST.addKillId(18333) # Hall Keeper Suicidal Soldier
QUEST.addKillId(CHOIR_PRAYER)
QUEST.addKillId(CHOIR_CAPTAIN)
QUEST.addKillId(SCARLET_VAN_HALISHA_WEAK)
QUEST.addKillId(SCARLET_VAN_HALISHA_STRONG)
QUEST.addKillId(FRINTEZZA)

QUEST.addSkillSeeId(FRINTEZZA)
QUEST.addSkillSeeId(29048) # Evil Spirit
QUEST.addSkillSeeId(29049) # Evil Spirit
